/**
 * 
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.task;

import javax.xml.bind.annotation.XmlRootElement;

import org.apache.commons.lang.builder.ToStringBuilder;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;

/**
 * @author Paolo Fabriani
 *
 */
@XmlRootElement
public class ImportTask {

    /**
     * The unique id of the task
     */
    private String id;

    /**
     * The context when the task was scheduled
     */
    private SubmissionInfo submissionInfo;
    
    /**
     * Import paramters (dataset, variables, import frequency, etc..)
     */
    private ImportOptions parameters;
    
    /**
     * The last execution of the task
     */
    private Execution lastExecution;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public SubmissionInfo getSubmissionInfo() {
        return submissionInfo;
    }

    public void setSubmissionInfo(SubmissionInfo info) {
        this.submissionInfo = info;
    }

    public ImportOptions getImportParameters() {
        return parameters;
    }

    public void setImportParameters(ImportOptions parameters) {
        this.parameters = parameters;
    }

    public Execution getLastExecution() {
        return lastExecution;
    }

    public void setLastExecution(Execution lastExecution) {
        this.lastExecution = lastExecution;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString(this);
    }

}
