/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.text.ParseException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.IOUtils;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsDataset;
import org.gcube.dataanalysis.copernicus.cmems.importer.seplugin.thredds.ThreddsDatasetChunk;
import org.gcube.dataanalysis.datasetimporter.exception.ServiceUnreachableException;
import org.gcube.dataanalysis.datasetimporter.util.TextUtil;
import org.gcube.dataanalysis.datasetimporter.util.TimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThreddsClient {
    private static Logger logger = LoggerFactory.getLogger(ThreddsClient.class);
    private URL endpoint;
    private String persistenceId;
    private String catalogue;

    public ThreddsClient(URL endpoint, String persistenceId, String catalogue) {
        this.endpoint = endpoint;
        this.persistenceId = persistenceId;
        this.catalogue = catalogue;
    }

    private URL getEndpoint() {
        return this.endpoint;
    }

    private String getPersistenceId() {
        return this.persistenceId;
    }

    private String getCatalogue() {
        return this.catalogue;
    }

    public ThreddsDataset getDataset(ImportOptions request) throws Exception {
        return this.getDataset(request.getHash());
    }

    public boolean containsDataset(ImportOptions request) {
        return this.containsDataset(request.getHash());
    }

    public boolean containsDataset(String hash) {
        try {
            InputStream stream = this.getNcmlInputStream(hash);
            stream.close();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public ThreddsDataset getDataset(String hash) throws Exception {
        try {
            Map<String, ThreddsDatasetChunk> cs1 = this.getChunksInNcml(hash);
            logger.info("found " + cs1.size() + " chunks in ncml");
            Map<String, ThreddsDatasetChunk> cs2 = this.getChunksInCatalogue(hash);
            logger.info("found " + cs2.size() + " chunks in catalogue");
            for (Map.Entry<String, ThreddsDatasetChunk> e : cs1.entrySet()) {
                ThreddsDatasetChunk c2 = cs2.get(e.getKey());
                e.getValue().setChunkUpdate(c2.getChunkUpdate());
            }
            ImportOptions opts = this.getRequestByHash(hash);
            ThreddsDataset out = new ThreddsDataset();
            out.setOptions(opts);
            for (ThreddsDatasetChunk chunk : cs1.values()) {
                out.addChunk(chunk);
            }
            return out;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("unable to find/parse a dataset at " + this.getNcmlUrl(hash));
        }
    }

    private Document getNcmlDocument(String hash) throws Exception {
        return this.getXmlDocument(this.getNcmlInputStream(hash));
    }

    private Document getCatalog(String hash) throws Exception {
        return this.getXmlDocument(this.getCatalogInputStream(hash));
    }

    private InputStream getNcmlInputStream(String hash) throws IOException {
        String url = this.getNcmlUrl(hash);
        return new URL(url).openStream();
    }

    private InputStream getCatalogInputStream(String hash) throws IOException {
        String url = this.getCatalogUrl(hash);
        logger.debug(url);
        return new URL(url).openStream();
    }

    private String getNcmlUrl(String hash) {
        return this.getEndpoint() + "/" + this.getPersistenceId() + "/fileServer/" + this.getCatalogue() + "/" + hash + ".ncml";
    }

    private String getCatalogUrl(String hash) {
        return this.getEndpoint() + "/" + this.getPersistenceId() + "/" + this.getCatalogue() + "/catalog.xml";
    }

    private Document getXmlDocument(InputStream inputStream) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setIgnoringComments(false);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document doc = db.parse(inputStream);
        doc.getDocumentElement().normalize();
        return doc;
    }

    private ImportOptions getRequestByHash(String hash) throws Exception {
        InputStream stream = this.getNcmlInputStream(hash);
        String ncml = IOUtils.toString((InputStream)stream, (String)"UTF-8");
        return this.getRequestInNcml(ncml);
    }

    private Map<String, ThreddsDatasetChunk> getChunksInNcml(String hash) throws Exception {
        return this.getChunksInNcml(this.getNcmlDocument(hash));
    }

    private Map<String, ThreddsDatasetChunk> getChunksInNcml(Document ncml) throws Exception {
        HashMap<String, ThreddsDatasetChunk> out = new HashMap<String, ThreddsDatasetChunk>();
        if (ncml != null) {
            NodeList nList = ncml.getElementsByTagName("netcdf");
            for (int i = 0; i < nList.getLength(); ++i) {
                Node nNode = nList.item(i);
                Element eElement = (Element)nNode;
                if (!eElement.hasAttribute("location")) continue;
                ThreddsDatasetChunk chunk = new ThreddsDatasetChunk(eElement.getAttribute("location"));
                out.put(chunk.getFileName(), chunk);
            }
        }
        return out;
    }

    private Map<String, ThreddsDatasetChunk> getChunksInCatalogue(String hash) throws Exception {
        Document doc = this.getCatalog(hash);
        HashMap<String, ThreddsDatasetChunk> out = new HashMap<String, ThreddsDatasetChunk>();
        if (doc != null) {
            NodeList nList = doc.getElementsByTagName("dataset");
            for (int i = 0; i < nList.getLength(); ++i) {
                ThreddsDatasetChunk chunk;
                Node nNode = nList.item(i);
                Element eElement = (Element)nNode;
                String name = eElement.getAttribute("name");
                try {
                    chunk = new ThreddsDatasetChunk(name);
                }
                catch (ParseException e) {
                    continue;
                }
                String h = chunk.getName();
                if (!h.equals(hash)) continue;
                try {
                    chunk.setName(h);
                    NodeList children = eElement.getElementsByTagName("date");
                    int j = 0;
                    if (j < children.getLength()) {
                        Element dateNode = (Element)children.item(j);
                        String dateString = dateNode.getTextContent();
                        Calendar date = TimeUtil.toCalendar((String)dateString);
                        chunk.setChunkUpdate(date);
                    }
                    out.put(name, chunk);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return out;
    }

    private ImportOptions getRequestInNcml(String ncml) throws ParseException {
        int start = ncml.indexOf("<!--") + 4;
        int end = ncml.indexOf("-->", start);
        String comment = ncml.substring(start, end).trim();
        HashMap<String, String> out = new HashMap<String, String>();
        for (String entry : comment.split(";")) {
            String[] parts = entry.split(":");
            String key = parts[0].trim();
            String value = parts[1].trim();
            out.put(key, value);
        }
        ImportOptions options = new ImportOptions(out);
        return options;
    }

    public void upload(File localFile) throws Exception {
        this.uploadUsingCurl(localFile);
    }

    private void uploadUsingCurl(File localFile) throws IOException {
        String command = "curl";
        command = command + " -F uploadedFile=@" + localFile.getAbsolutePath();
        command = command + " --header gcube-token:" + SecurityTokenProvider.instance.get();
        command = command + " " + this.getEndpoint() + "/data-transfer-service/gcube/service/REST/" + this.getPersistenceId() + "/" + this.getCatalogue();
        command = command + "?on-existing-file=REWRITE";
        command = command + "&on-existing-dir=APPEND";
        command = command + "&create-dirs=true";
        logger.debug(TextUtil.removePasswords((String)command));
        try {
            String s;
            Process p = Runtime.getRuntime().exec(command);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            logger.info("Here is the standard output of the command:");
            while ((s = stdInput.readLine()) != null) {
                logger.info(s);
            }
            logger.info("Here is the standard error of the command (if any):");
            while ((s = stdError.readLine()) != null) {
                logger.info(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void checkThreddsIsReachable() throws ServiceUnreachableException {
        String endpoint = this.getEndpoint() + "/" + this.getPersistenceId();
        try {
            InputStream stream = new URL(endpoint).openStream();
            Throwable throwable = null;
            if (stream != null) {
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new ServiceUnreachableException(endpoint);
        }
    }

    private void checkThreddsDatasetExists(String hash) throws NoSuchElementException {
        String endpoint = this.getNcmlUrl(hash);
        try {
            InputStream stream = new URL(endpoint).openStream();
            Throwable throwable = null;
            if (stream != null) {
                if (throwable != null) {
                    try {
                        stream.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            throw new NoSuchElementException(endpoint);
        }
    }
}

