package org.gcube.dataanalysis.copernicus.cmems.importer.service.service;

import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;
import java.util.UUID;

import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.vremanagement.executor.api.rest.SmartExecutor;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.SmartExecutorClientFactory;
import org.gcube.vremanagement.executor.exception.ExecutorException;

/**
 * @author Paolo Fabriani
 *
 */
public class SmartExecutorClient {

    private static final String PLUGIN_NAME = "cmems-importer-se-plugin";
    
    public UUID submit(ImportOptions options) throws ExecutorException {
     
        // create a client for the smart executor
        SmartExecutor proxy = SmartExecutorClientFactory.create(PLUGIN_NAME);
        
        // prepare parameters 
        Map<String, Object> params = new HashMap<>();
        for(Entry<String, String> entry : options.toMap().entrySet())
            params.put(entry.getKey(), entry.getValue());
        LaunchParameter parameter = new LaunchParameter(PLUGIN_NAME, params);
          
        // submit the request
        return proxy.launch(parameter);
        
    }
    
}
