/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ExecutionReport;

public class ReportResource
extends AbstractImporterResource {
    private String taskId;
    private String executionId;
    private String reportId;

    public ReportResource(String taskId, String executionId, String reportId) {
        this.taskId = taskId;
        this.executionId = executionId;
        this.reportId = reportId;
    }

    @GET
    public Response getReport() {
        try {
            ExecutionReport report = new TaskStore().getReport(this.taskId, this.executionId, this.reportId);
            return Response.ok().entity((Object)report).build();
        }
        catch (InvalidParameterException | MalformedElementException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @GET
    @Path(value="text")
    @Produces(value={"text/plain"})
    public Response getReportText() {
        try {
            ExecutionReport report = new TaskStore().getReport(this.taskId, this.executionId, this.reportId);
            return Response.ok().entity((Object)report.getText()).build();
        }
        catch (InvalidParameterException | MalformedElementException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }

    @PUT
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response update(ExecutionReport report) {
        try {
            report.setName(this.reportId);
            ExecutionReport out = new TaskStore().update(this.taskId, this.executionId, report);
            return Response.ok().entity((Object)out).build();
        }
        catch (InvalidParameterException | MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
    }
}

