/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task;

import java.util.Calendar;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import org.gcube.dataanalysis.copernicus.cmems.importer.api.ImportOptions;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.AlreadyThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.InvalidParameterException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.MalformedElementException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.NotThereException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.exception.StoreException;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.cmems.AbstractImporterResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.PreviewResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.TaskResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.rest.task.TasksResource;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.SmartExecutorClient;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.service.TaskStore;
import org.gcube.dataanalysis.copernicus.cmems.importer.service.util.SecurityUtils;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.ImportTask;
import org.gcube.dataanalysis.copernicus.cmems.importer.task.SubmissionInfo;
import org.gcube.vremanagement.executor.exception.ExecutorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/tasks")
public class TasksResource
extends AbstractImporterResource {
    private static Logger logger = LoggerFactory.getLogger(TaskResource.class);

    @GET
    @Produces(value={"application/xml"})
    public Response listTasks(@QueryParam(value="scope") String scope, @QueryParam(value="token") String token, @QueryParam(value="user") String user, @QueryParam(value="limit") Integer limit) {
        try {
            List tasks = new TaskStore().searchTasks(user, scope, token, limit);
            1 out = new /* Unavailable Anonymous Inner Class!! */;
            return Response.ok((Object)out).build();
        }
        catch (InvalidParameterException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @Path(value="{taskId}")
    public TaskResource getTask(@PathParam(value="taskId") String taskId) {
        return new TaskResource(taskId);
    }

    @POST
    @Produces(value={"application/xml"})
    @Consumes(value={"application/xml"})
    public Response schedule(ImportOptions options) {
        SubmissionInfo info = new SecurityUtils().getCurrentSubmissionInfo();
        if (info.getToken() == null || info.getScope() == null || info.getUser() == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
        }
        logger.info(String.format("Received a schedule request from user '%s' in scope '%s'", info.getUser(), info.getScope()));
        try {
            Collection errors = this.check(options);
            if (!errors.isEmpty() && !errors.isEmpty()) {
                2 entity = new /* Unavailable Anonymous Inner Class!! */;
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).entity((Object)entity).build();
            }
        }
        catch (Exception e) {
            logger.error(e.toString());
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        info.setScheduled(Calendar.getInstance());
        UUID taskId = null;
        try {
            taskId = new SmartExecutorClient().submit(options);
        }
        catch (ExecutorException e) {
            e.printStackTrace();
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        ImportTask task = new ImportTask();
        task.setId(taskId.toString());
        task.setSubmissionInfo(info);
        task.setImportParameters(options);
        try {
            ImportTask out = new TaskStore().addTask(task);
            return Response.ok().entity((Object)out).build();
        }
        catch (InvalidParameterException | MalformedElementException | StoreException e) {
            return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).build();
        }
        catch (NotThereException e) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        catch (AlreadyThereException e) {
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
    }

    @DELETE
    public void unschedule(String taskId) {
    }

    @Path(value="preview")
    public PreviewResource getPreview() {
        return new PreviewResource();
    }
}

