/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.gcube.common.resources.gcore.GenericResource;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.ConfigurationImpl;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configuration.SVNRepository;
import org.gcube.dataanalysis.dataminer.poolmanager.clients.configurations.AbstractConfiguration;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConfigurationCache {
    private Logger logger = LoggerFactory.getLogger(ClientConfigurationCache.class);
    private SVNRepository svnRepository = null;
    private Map<String, AbstractConfiguration> configurations = new HashMap();
    private long svnRepositoryTimeout = 0L;
    private Map<String, Long> configurationsTimeouts = new HashMap();
    private final long duration = 120000L;

    ClientConfigurationCache() {
    }

    public AbstractConfiguration getConfiguration(ConfigurationImpl.CONFIGURATIONS configuration) {
        block3: {
            long currentTime;
            block2: {
                Long time = (Long)this.configurationsTimeouts.get(configuration.toString());
                currentTime = new Date().getTime();
                if (time == null) break block2;
                long l = time;
                Objects.requireNonNull(this);
                if (currentTime <= l + 120000L) break block3;
            }
            this.configurations.put(configuration.toString(), this.getConfiguration(configuration.getType()));
            this.configurationsTimeouts.put(configuration.toString(), currentTime);
        }
        return (AbstractConfiguration)this.configurations.get(configuration.toString());
    }

    public SVNRepository getSVNRepository() {
        block3: {
            long currentTime;
            block2: {
                currentTime = new Date().getTime();
                if (this.svnRepositoryTimeout == 0L) break block2;
                Objects.requireNonNull(this);
                if (currentTime <= this.svnRepositoryTimeout + 120000L) break block3;
            }
            this.svnRepository = this.queryForRepository();
            this.svnRepositoryTimeout = currentTime;
        }
        return this.svnRepository;
    }

    private SVNRepository queryForRepository() {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult("$resource");
        DiscoveryClient client = ICFactory.clientFor(GenericResource.class);
        List ds = client.submit((Query)query);
        Iterator resourcesIterator = ds.iterator();
        SVNRepository response = null;
        while (resourcesIterator.hasNext() && response == null) {
            GenericResource resource = (GenericResource)resourcesIterator.next();
            String repositoryURL = resource.profile().body().getElementsByTagName("svn.repository").item(0).getTextContent();
            if (repositoryURL == null) continue;
            String repositoryPath = resource.profile().body().getElementsByTagName("svn.algo.main.repo").item(0).getTextContent();
            String repositoryUsername = null;
            String repositoryPassword = null;
            try {
                repositoryUsername = resource.profile().body().getElementsByTagName("svn.repository.username").item(0).getTextContent();
                repositoryPassword = resource.profile().body().getElementsByTagName("svn.repository.password").item(0).getTextContent();
                if (repositoryUsername != null && repositoryUsername.trim() == "") {
                    repositoryUsername = null;
                }
                if (repositoryPassword != null && repositoryPassword.trim() == "") {
                    repositoryPassword = null;
                }
                this.logger.debug("Repository username " + repositoryUsername);
                this.logger.debug("Repository password " + repositoryPassword);
            }
            catch (Exception e) {
                this.logger.debug("SVN Username and password not present");
            }
            this.logger.debug("SVN Repository URL: " + repositoryURL);
            this.logger.debug("SVN Repository path: " + repositoryPath);
            response = new SVNRepository(repositoryURL, repositoryPath, repositoryUsername, repositoryPassword);
        }
        return response;
    }

    private AbstractConfiguration getConfiguration(AbstractConfiguration type) {
        XQuery query = ICFactory.queryFor(GenericResource.class);
        query.addCondition("$resource/Profile/SecondaryType/text() eq 'DMPMConfigurator'").setResult(type.getXMLModel());
        DiscoveryClient client = ICFactory.clientFor(type.getClass());
        List configurations = client.submit((Query)query);
        if (configurations != null && !configurations.isEmpty()) {
            return (AbstractConfiguration)configurations.get(0);
        }
        return null;
    }
}

