package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;
import java.io.File;
import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.*;
import org.n52.wps.algorithm.annotation.*;
import org.n52.wps.io.data.*;
import org.n52.wps.io.data.binding.complex.*;
import org.n52.wps.io.data.binding.literal.*;
import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.*;
@Algorithm(statusSupported=false, title="SGVM_INTERPOLATION", abstrakt="An interpolation method relying on the implementation by the Study Group on VMS (SGVMS). The method uses two interpolation approached to simulate vessels points at a certain temporal resolution. The input is a file in TACSAT format uploaded on the Statistical Manager. The output is another TACSAT file containing interpolated points.The underlying R code has been extracted from the SGVM VMSTools framework. This algorithm comes after a feasibility study (http://goo.gl/risQre) which clarifies the features an e-Infrastructure adds to the original scripts. Limitation: the input will be processed up to 10000 vessels trajectory points. Credits: Hintzen, N. T., Bastardie, F., Beare, D., Piet, G. J., Ulrich, C., Deporte, N., Egekvist, J., et al. 2012. VMStools: Open-source software for the processing, analysis and visualisation of fisheries logbook and VMS data. Fisheries Research, 115-116: 31-43. Hintzen, N. T., Piet, G. J., and Brunel, T. 2010. Improved estimation of trawling tracks using cubic Hermite spline interpolation of position registration data. Fisheries Research, 101: 108-115. VMStools, available as an add-on package for R. Documentation available at https://code.google.com/p/vmstools/.  Build versions of VMStools for Window, Mac, Linux available at https://docs.google.com/. Authors: Niels T. Hintzen, Doug Beare", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.SGVM_INTERPOLATION", version = "1.1.0")
public class SGVM_INTERPOLATION extends AbstractEcologicalEngineMapper implements ITransducer{
@ComplexDataInput(abstrakt="Name of the parameter: InputFile. Input file in TACSAT format. E.g. http://goo.gl/i16kPw", title="Input file in TACSAT format. E.g. http://goo.gl/i16kPw", maxOccurs=1, minOccurs=1, identifier = "InputFile", binding = D4ScienceDataInputBinding.class)	public void setInputFile(GenericFileData file) {inputs.put("InputFile",file);}
@LiteralDataInput(abstrakt="Name of the parameter: npoints. The number of pings or positions required between each real or actual vessel position or ping", defaultValue="10", title="The number of pings or positions required between each real or actual vessel position or ping", identifier = "npoints", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setnpoints(Integer data) {inputs.put("npoints",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: interval. Average time in minutes between two adjacent datapoints", defaultValue="120", title="Average time in minutes between two adjacent datapoints", identifier = "interval", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setinterval(Integer data) {inputs.put("interval",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: margin. Maximum deviation from specified interval to find adjacent datapoints (tolerance)", defaultValue="10", title="Maximum deviation from specified interval to find adjacent datapoints (tolerance)", identifier = "margin", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setmargin(Integer data) {inputs.put("margin",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: res. Number of points to use to create interpolation (including start and end point)", defaultValue="100", title="Number of points to use to create interpolation (including start and end point)", identifier = "res", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setres(Integer data) {inputs.put("res",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: method. Set to cHs for cubic Hermite spline or SL for Straight Line interpolation", allowedValues= {"cHs","SL"}, defaultValue="cHs", title="Set to cHs for cubic Hermite spline or SL for Straight Line interpolation", identifier = "method", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setmethod(String data) {inputs.put("method",data);}
@LiteralDataInput(abstrakt="Name of the parameter: fm. The FM parameter in cubic interpolation", defaultValue="0.5", title="The FM parameter in cubic interpolation", identifier = "fm", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setfm(Double data) {inputs.put("fm",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: distscale. The DistScale parameter for cubic interpolation", defaultValue="20", title="The DistScale parameter for cubic interpolation", identifier = "distscale", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setdistscale(Integer data) {inputs.put("distscale",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: sigline. The Sigline parameter in cubic interpolation", defaultValue="0.2", title="The Sigline parameter in cubic interpolation", identifier = "sigline", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setsigline(Double data) {inputs.put("sigline",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: minspeedThr. A filter on the minimum speed to take into account for interpolation", defaultValue="2", title="A filter on the minimum speed to take into account for interpolation", identifier = "minspeedThr", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setminspeedThr(Double data) {inputs.put("minspeedThr",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: maxspeedThr. A filter on the maximum speed to take into account for interpolation", defaultValue="6", title="A filter on the maximum speed to take into account for interpolation", identifier = "maxspeedThr", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setmaxspeedThr(Double data) {inputs.put("maxspeedThr",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: headingAdjustment. Parameter to adjust the choice of heading depending on its own or previous point (0 or 1). Set 1 in case the heading at the endpoint does not represent the heading of the arriving vessel to that point but the departing vessel.", defaultValue="0", title="Parameter to adjust the choice of heading depending on its own or previous point (0 or 1). Set 1 in case the heading at the endpoint does not represent the heading of the arriving vessel to that point but the departing vessel.", identifier = "headingAdjustment", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setheadingAdjustment(Integer data) {inputs.put("headingAdjustment",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: equalDist. Whether the number of positions returned should be equally spaced or not", defaultValue="true", allowedValues= {"true","false"}, title="Whether the number of positions returned should be equally spaced or not", identifier = "equalDist", maxOccurs=1, minOccurs=1,binding = LiteralBooleanBinding.class) public void setequalDist(Boolean data) {inputs.put("equalDist",""+data);}
@ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier = "non_deterministic_output", binding = GenericXMLDataBinding.class)
 public XmlObject getNon_deterministic_output() {return (XmlObject) outputs.get("non_deterministic_output");}
@Execute	public void run() throws Exception {		super.run();	} }