package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;
import java.io.File;
import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.*;
import org.n52.wps.algorithm.annotation.*;
import org.n52.wps.io.data.*;
import org.n52.wps.io.data.binding.complex.*;
import org.n52.wps.io.data.binding.literal.*;
import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.*;
@Algorithm(statusSupported=false, title="XYEXTRACTOR_TABLE", abstrakt="An algorithm to extract values associated to a table containing geospatial features (e.g. Vessel Routes, Species distribution maps etc. ). A grid of points at a certain resolution is specified by the user and values are associated to the points from the environmental repository. It accepts as one geospatial table and the specification about time and space. The algorithm produces one table containing the values associated to the selected bounding box.", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.XYEXTRACTOR_TABLE", version = "1.1.0")
public class XYEXTRACTOR_TABLE extends AbstractEcologicalEngineMapper implements ITransducer{
@ComplexDataInput(abstrakt="Name of the parameter: geoReferencedTableName. A geospatial table containing at least x,y information [a http link to a table in UTF-8 encoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", title="A geospatial table containing at least x,y information [a http link to a table in UTF-8 encoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", maxOccurs=1, minOccurs=1, identifier = "geoReferencedTableName", binding = GenericFileDataBinding.class)	public void setgeoReferencedTableName(GenericFileData file) {inputs.put("geoReferencedTableName",file);}
@LiteralDataInput(abstrakt="Name of the parameter: xColumn. The column containing x (longitude) information [the name of a column from geoReferencedTableName]", defaultValue="x", title="The column containing x (longitude) information [the name of a column from geoReferencedTableName]", identifier = "xColumn", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setxColumn(String data) {inputs.put("xColumn",data);}
@LiteralDataInput(abstrakt="Name of the parameter: yColumn. The column containing y (latitude) information [the name of a column from geoReferencedTableName]", defaultValue="y", title="The column containing y (latitude) information [the name of a column from geoReferencedTableName]", identifier = "yColumn", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setyColumn(String data) {inputs.put("yColumn",data);}
@LiteralDataInput(abstrakt="Name of the parameter: valueColumn. A column containing real valued features [the name of a column from geoReferencedTableName]", defaultValue="value", title="A column containing real valued features [the name of a column from geoReferencedTableName]", identifier = "valueColumn", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setvalueColumn(String data) {inputs.put("valueColumn",data);}
@LiteralDataInput(abstrakt="Name of the parameter: filter. A filter on one of the columns (e.g. speed=2)", defaultValue=" ", title="A filter on one of the columns (e.g. speed=2)", identifier = "filter", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setfilter(String data) {inputs.put("filter",data);}
@LiteralDataInput(abstrakt="Name of the parameter: zColumn. The column containing z (altitude or depth) information (optional)", defaultValue="z", title="The column containing z (altitude or depth) information (optional)", identifier = "zColumn", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setzColumn(String data) {inputs.put("zColumn",data);}
@LiteralDataInput(abstrakt="Name of the parameter: timeColumn. The column containing time (otional)", defaultValue="datetime", title="The column containing time (otional)", identifier = "timeColumn", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void settimeColumn(String data) {inputs.put("timeColumn",data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_LowerLeftLat. Lower Left Latitute of the Bounding Box", defaultValue="-60", title="Lower Left Latitute of the Bounding Box", identifier = "BBox_LowerLeftLat", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_LowerLeftLat(Double data) {inputs.put("BBox_LowerLeftLat",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_LowerLeftLong. Lower Left Longitude of the Bounding Box", defaultValue="-50", title="Lower Left Longitude of the Bounding Box", identifier = "BBox_LowerLeftLong", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_LowerLeftLong(Double data) {inputs.put("BBox_LowerLeftLong",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_UpperRightLat. Upper Right Latitute of the Bounding Box", defaultValue="60", title="Upper Right Latitute of the Bounding Box", identifier = "BBox_UpperRightLat", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_UpperRightLat(Double data) {inputs.put("BBox_UpperRightLat",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: BBox_UpperRightLong. Upper Right Longitude of the Bounding Box", defaultValue="50", title="Upper Right Longitude of the Bounding Box", identifier = "BBox_UpperRightLong", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setBBox_UpperRightLong(Double data) {inputs.put("BBox_UpperRightLong",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: OutputTableLabel. The name of the table to produce", defaultValue="extr_", title="The name of the table to produce", identifier = "OutputTableLabel", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setOutputTableLabel(String data) {inputs.put("OutputTableLabel",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Z. Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", defaultValue="0", title="Value of Z. Default is 0, that means processing will be at surface level or at the first avaliable Z value in the layer", identifier = "Z", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setZ(Double data) {inputs.put("Z",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: TimeIndex. Time Index. The default is the first time indexed dataset", defaultValue="0", title="Time Index. The default is the first time indexed dataset", identifier = "TimeIndex", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setTimeIndex(Integer data) {inputs.put("TimeIndex",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: XResolution. Projection resolution on the X axis", defaultValue="0.5", title="Projection resolution on the X axis", identifier = "XResolution", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setXResolution(Double data) {inputs.put("XResolution",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: YResolution. Projection resolution on the Y axis", defaultValue="0.5", title="Projection resolution on the Y axis", identifier = "YResolution", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setYResolution(Double data) {inputs.put("YResolution",""+data);}
@ComplexDataOutput(abstrakt="Name of the parameter: OutputTable1. Output table [a http link to a table in UTF-8 ecoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", title="Output table [a http link to a table in UTF-8 ecoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", identifier = "OutputTable1", binding = CsvFileDataBinding.class)	public GenericFileData getOutputTable1() {URL url=null;try {url = new URL((String) outputs.get("OutputTable1")); return new GenericFileData(url.openStream(),"text/csv");} catch (Exception e) {e.printStackTrace();return null;}}
@ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier = "non_deterministic_output", binding = GenericXMLDataBinding.class)
 public XmlObject getNon_deterministic_output() {return (XmlObject) outputs.get("non_deterministic_output");}
@Execute	public void run() throws Exception {		super.run();	} }