/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;

import java.net.URL;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.CsvFileDataBinding;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.ITransducer;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;
import org.n52.wps.algorithm.annotation.Algorithm;
import org.n52.wps.algorithm.annotation.ComplexDataInput;
import org.n52.wps.algorithm.annotation.ComplexDataOutput;
import org.n52.wps.algorithm.annotation.Execute;
import org.n52.wps.algorithm.annotation.LiteralDataInput;
import org.n52.wps.io.data.GenericFileData;
import org.n52.wps.io.data.binding.complex.GenericFileDataBinding;
import org.n52.wps.io.data.binding.complex.GenericXMLDataBinding;
import org.n52.wps.io.data.binding.literal.LiteralDoubleBinding;
import org.n52.wps.io.data.binding.literal.LiteralStringBinding;

@Algorithm(statusSupported=false, title="OCCURRENCE_ENRICHMENT", abstrakt="An algorithm performing occurrences enrichment. Takes as input one table containing occurrence points for a set of species and a list of environmental layer, taken either from the e-infrastructure GeoNetwork (through the GeoExplorer application) or from direct HTTP links. Produces one table reporting the set of environmental values associated to the occurrence points.", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.OCCURRENCE_ENRICHMENT", version="1.1.0")
public class OCCURRENCE_ENRICHMENT
extends AbstractEcologicalEngineMapper
implements ITransducer {
    @ComplexDataInput(abstrakt="Name of the parameter: OccurrenceTable. A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets [a http link to a table in UTF-8 encoding following this template: (OCCURRENCE_SPECIES) http://goo.gl/4ExuR5]", title="A geospatial table containing occurrence records, following the template of the Species Products Discovery datasets [a http link to a table in UTF-8 encoding following this template: (OCCURRENCE_SPECIES) http://goo.gl/4ExuR5]", maxOccurs=1, minOccurs=1, identifier="OccurrenceTable", binding=GenericFileDataBinding.class)
    public void setOccurrenceTable(GenericFileData file) {
        this.inputs.put("OccurrenceTable", file);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: LongitudeColumn. The column containing longitude values [the name of a column from OccurrenceTable]", defaultValue="decimallongitude", title="The column containing longitude values [the name of a column from OccurrenceTable]", identifier="LongitudeColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLongitudeColumn(String data) {
        this.inputs.put("LongitudeColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: LatitudeColumn. The column containing latitude values [the name of a column from OccurrenceTable]", defaultValue="decimallatitude", title="The column containing latitude values [the name of a column from OccurrenceTable]", identifier="LatitudeColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLatitudeColumn(String data) {
        this.inputs.put("LatitudeColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: ScientificNameColumn. The column containing Scientific Names [the name of a column from OccurrenceTable]", defaultValue="scientificname", title="The column containing Scientific Names [the name of a column from OccurrenceTable]", identifier="ScientificNameColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setScientificNameColumn(String data) {
        this.inputs.put("ScientificNameColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: TimeColumn. The column containing time information [the name of a column from OccurrenceTable]", defaultValue="eventdate", title="The column containing time information [the name of a column from OccurrenceTable]", identifier="TimeColumn", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setTimeColumn(String data) {
        this.inputs.put("TimeColumn", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: OptionalFilter. A filter on one of the columns (e.g. basisofrecord='HumanObservation'). Optional", defaultValue=" ", title="A filter on one of the columns (e.g. basisofrecord='HumanObservation'). Optional", identifier="OptionalFilter", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setOptionalFilter(String data) {
        this.inputs.put("OptionalFilter", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: Resolution. The spatial resolution in degrees of the association between observations and environmental features", defaultValue="0.5", title="The spatial resolution in degrees of the association between observations and environmental features", identifier="Resolution", maxOccurs=1, minOccurs=1, binding=LiteralDoubleBinding.class)
    public void setResolution(Double data) {
        this.inputs.put("Resolution", "" + data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: OutputTableName. The name of the output table", defaultValue="enrich_", title="The name of the output table", identifier="OutputTableName", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setOutputTableName(String data) {
        this.inputs.put("OutputTableName", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: Layers. The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff ) [a sequence of values separated by | ] (format: String)", defaultValue="", title="The list of environmental layers to use for enriching the points. Each entry is a layer Title or UUID or HTTP link. E.g. the title or the UUID (preferred) of a layer indexed in the e-Infrastructure on GeoNetwork - You can retrieve it from GeoExplorer. Otherwise you can supply the direct HTTP link of the layer. The format will be guessed from the link. The default is GeoTiff. Supports several standards (NETCDF, WFS, WCS, ASC, GeoTiff ) [a sequence of values separated by | ] (format: String)", identifier="Layers", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setLayers(String data) {
        this.inputs.put("Layers", data);
    }

    @LiteralDataInput(abstrakt="Name of the parameter: FeaturesNames. The list of names for the columns corresponding to the environmental layers. These will be the column names of the resulting table [a sequence of values separated by | ] (format: String)", defaultValue="", title="The list of names for the columns corresponding to the environmental layers. These will be the column names of the resulting table [a sequence of values separated by | ] (format: String)", identifier="FeaturesNames", maxOccurs=1, minOccurs=1, binding=LiteralStringBinding.class)
    public void setFeaturesNames(String data) {
        this.inputs.put("FeaturesNames", data);
    }

    @ComplexDataOutput(abstrakt="Name of the parameter: OutputTable1. Output table [a http link to a table in UTF-8 ecoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", title="Output table [a http link to a table in UTF-8 ecoding following this template: (GENERIC) A generic comma separated csv file in UTF-8 encoding]", identifier="OutputTable1", binding=CsvFileDataBinding.class)
    public GenericFileData getOutputTable1() {
        URL url = null;
        try {
            url = new URL((String)this.outputs.get("OutputTable1"));
            return new GenericFileData(url.openStream(), "text/csv");
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier="non_deterministic_output", binding=GenericXMLDataBinding.class)
    public XmlObject getNon_deterministic_output() {
        return (XmlObject)this.outputs.get("non_deterministic_output");
    }

    @Override
    @Execute
    public void run() throws Exception {
        super.run();
    }
}

