package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers;
import java.io.File;
import java.net.URL;
import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.io.StringWriter;
import org.apache.commons.io.IOUtils;
import org.apache.xmlbeans.XmlObject;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.bindings.*;
import org.n52.wps.algorithm.annotation.*;
import org.n52.wps.io.data.*;
import org.n52.wps.io.data.binding.complex.*;
import org.n52.wps.io.data.binding.literal.*;
import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.AbstractEcologicalEngineMapper;import org.n52.wps.server.*;import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.*;
@Algorithm(statusSupported=true, title="TIME_SERIES_ANALYSIS", abstrakt="An algorithms applying signal processing to a non uniform time series. A maximum of 10000 distinct points in time is allowed to be processed. The process uniformly samples the series, then extracts hidden periodicities and signal properties. The sampling period is the shortest time difference between two points. Finally, by using Caterpillar-SSA the algorithm forecasts the Time Series. The output shows the detected periodicity, the forecasted signal and the spectrogram.", identifier="org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mappedclasses.transducerers.TIME_SERIES_ANALYSIS", version = "1.1.0")
public class TIME_SERIES_ANALYSIS extends AbstractEcologicalEngineMapper implements ITransducer{
@ComplexDataInput(abstrakt="Name of the parameter: TimeSeriesTable. The table containing the time series [a http link to a table in UTF-8 encoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", title="The table containing the time series [a http link to a table in UTF-8 encoding following this template: (TIMESERIES) http://goo.gl/DoW6fg]", maxOccurs=1, minOccurs=1, identifier = "TimeSeriesTable", binding = GenericFileDataBinding.class)	public void setTimeSeriesTable(GenericFileData file) {inputs.put("TimeSeriesTable",file);}
@LiteralDataInput(abstrakt="Name of the parameter: ValueColum. The column containing the values of the time series [the name of a column from TimeSeriesTable]", defaultValue="values", title="The column containing the values of the time series [the name of a column from TimeSeriesTable]", identifier = "ValueColum", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setValueColum(String data) {inputs.put("ValueColum",data);}
@LiteralDataInput(abstrakt="Name of the parameter: FFT_Window_Samples. The number of samples N on which the Fourier Transform (FFT) will be extracted. It should be a power of two and less than the signal length, otherwise it will be automatically recalculated. The FFT will be calculated every N/2 samples, taking N samples each time. The spectrogram will display the FFT on the slices of N samples.", defaultValue="12", title="The number of samples N on which the Fourier Transform (FFT) will be extracted. It should be a power of two and less than the signal length, otherwise it will be automatically recalculated. The FFT will be calculated every N/2 samples, taking N samples each time. The spectrogram will display the FFT on the slices of N samples.", identifier = "FFT_Window_Samples", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setFFT_Window_Samples(Integer data) {inputs.put("FFT_Window_Samples",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: AggregationFunction. Function to apply to samples with the same time instant", allowedValues= {"SUM","AVG"}, defaultValue="SUM", title="Function to apply to samples with the same time instant", identifier = "AggregationFunction", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setAggregationFunction(String data) {inputs.put("AggregationFunction",data);}
@LiteralDataInput(abstrakt="Name of the parameter: Sensitivity. Sensitivity to the frequency components. High sensitivity will report all the frequency components, low sensitivity will report only the most distant ones.", allowedValues= {"LOW","NORMAL","HIGH"}, defaultValue="LOW", title="Sensitivity to the frequency components. High sensitivity will report all the frequency components, low sensitivity will report only the most distant ones.", identifier = "Sensitivity", maxOccurs=1, minOccurs=1, binding = LiteralStringBinding.class) public void setSensitivity(String data) {inputs.put("Sensitivity",data);}
@LiteralDataInput(abstrakt="Name of the parameter: SSA_Window_in_Samples. The number of samples in the produced uniformly sampled signal, to use in the SSA algorithm. Must be strictly less than the Time Series length. This number should identify a portion of the signal long enough to make the system guess the nature of the trend", defaultValue="20", title="The number of samples in the produced uniformly sampled signal, to use in the SSA algorithm. Must be strictly less than the Time Series length. This number should identify a portion of the signal long enough to make the system guess the nature of the trend", identifier = "SSA_Window_in_Samples", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setSSA_Window_in_Samples(Integer data) {inputs.put("SSA_Window_in_Samples",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: SSA_EigenvaluesThreshold. The threshold under which an SSA eigenvalue will be ignored, along with its eigenvector, for the reconstruction of the signal", defaultValue="0.7", title="The threshold under which an SSA eigenvalue will be ignored, along with its eigenvector, for the reconstruction of the signal", identifier = "SSA_EigenvaluesThreshold", maxOccurs=1, minOccurs=1, binding = LiteralDoubleBinding.class) public void setSSA_EigenvaluesThreshold(Double data) {inputs.put("SSA_EigenvaluesThreshold",""+data);}
@LiteralDataInput(abstrakt="Name of the parameter: SSA_Points_to_Forecast. The number of points to forecast over the original length of the time series", defaultValue="10", title="The number of points to forecast over the original length of the time series", identifier = "SSA_Points_to_Forecast", maxOccurs=1, minOccurs=1, binding = LiteralIntBinding.class) public void setSSA_Points_to_Forecast(Integer data) {inputs.put("SSA_Points_to_Forecast",""+data);}

@ComplexDataOutput(abstrakt="Output that is not predetermined", title="NonDeterministicOutput", identifier = "non_deterministic_output", binding = GenericXMLDataBinding.class)
 public XmlObject getNon_deterministic_output() {return (XmlObject) outputs.get("non_deterministic_output");}
@Execute	public void run() throws Exception {		super.run();	} }