/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import org.gcube.common.authorization.client.Constants;
import org.gcube.common.authorization.library.AuthorizationEntry;
import org.gcube.common.authorization.library.provider.AuthorizationProvider;
import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.ConfigurationManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TokenManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TokenManager.class);
    String username;
    String scope;
    String token;
    String tokenQualifier;

    public String getScope() {
        return this.scope;
    }

    public String getUserName() {
        return this.username;
    }

    public String getToken() {
        return this.token;
    }

    public String getTokenQualifier() {
        return this.tokenQualifier;
    }

    public void getCredentials() {
        try {
            LOGGER.debug("Retrieving token credentials");
            this.username = AuthorizationProvider.instance.get().getClient().getId();
            this.token = SecurityTokenProvider.instance.get();
            AuthorizationEntry entry = Constants.authorizationService().get(this.token);
            this.scope = entry.getContext();
            this.tokenQualifier = entry.getQualifier();
        }
        catch (Exception e) {
            LOGGER.error("Error Retrieving token credentials ", (Throwable)e);
            this.scope = null;
            this.username = null;
        }
        if ((this.scope == null || this.username == null) && ConfigurationManager.isSimulationMode().booleanValue()) {
            this.scope = ConfigurationManager.defaultScope;
            this.username = ConfigurationManager.defaultUsername;
        }
        LOGGER.debug("Retrieved scope: {} Username: {} Token {} SIMULATION MODE: {} ", new Object[]{this.scope, this.username, this.token, ConfigurationManager.isSimulationMode()});
    }
}

