/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping;

import java.io.File;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.UUID;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.wps.statisticalmanager.synchserver.mapping.EnvironmentVariableManager;
import org.n52.wps.commons.WPSConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationManager.class);
    public static String serviceUserNameParameterVariable = "ServiceUserName";
    public static String processingSessionVariable = "Session";
    public static String webpathVariable = "WebPath";
    public static String webPersistencePathVariable = "";
    public static String usernameParameter = "user.name";
    public static String scopeParameter = "scope";
    public static String tokenParameter = "usertoken";
    public static String defaultScope = "/gcube/devsec";
    public static String defaultUsername = "statistical.wps";
    private static Integer maxComputations = null;
    private static Boolean useStorage = null;
    static boolean simulationMode = false;
    EnvironmentVariableManager env = null;
    private AlgorithmConfiguration config;
    private String scope;
    private String username;
    private String token;

    public static synchronized Integer getMaxComputations() {
        return maxComputations;
    }

    public static synchronized Boolean useStorage() {
        return useStorage;
    }

    public static synchronized Boolean isSimulationMode() {
        return simulationMode;
    }

    @Deprecated
    public void getInitializationProperties() {
    }

    private void inizializePropertiesUsingTemplateFile() {
        try {
            if (maxComputations == null) {
                Properties options = new Properties();
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("templates/setup.cfg");
                options.load(is);
                is.close();
                maxComputations = Integer.parseInt(options.getProperty("maxcomputations"));
                logger.info("setting max computation to {}", (Object)maxComputations);
                useStorage = Boolean.parseBoolean(options.getProperty("saveond4sstorage"));
                simulationMode = Boolean.parseBoolean(options.getProperty("simulationMode"));
            }
        }
        catch (Exception e) {
            logger.error("error initializing properties", (Throwable)e);
        }
    }

    public String getScope() {
        return this.scope;
    }

    public String getUsername() {
        return this.username;
    }

    public ConfigurationManager(EnvironmentVariableManager env) {
        if (env == null) {
            this.inizializePropertiesUsingTemplateFile();
        } else {
            maxComputations = env.getMaxComputation();
            useStorage = env.isSaveOnStorage();
            simulationMode = env.isSimulationMode();
        }
    }

    public AlgorithmConfiguration getConfig() {
        return this.config;
    }

    public void setComputationId(String computationId) {
        this.config.setTaskID(computationId);
    }

    public void configAlgorithmEnvironment(LinkedHashMap<String, Object> inputs) throws Exception {
        String persistencePath;
        this.config = new AlgorithmConfiguration();
        this.config.setAlgorithmClassLoader(Thread.currentThread().getContextClassLoader());
        String webperspath = WPSConfig.getConfigDir() + "../persistence/";
        String configPath = persistencePath = WPSConfig.getConfigDir() + "../ecocfg/";
        if (!new File(configPath).isDirectory()) {
            configPath = "./cfg/";
            persistencePath = "./";
        }
        logger.debug("Taking configuration from  {}", (Object)configPath);
        this.config.setPersistencePath(configPath);
        this.config.setConfigPath(configPath);
        this.config.setNumberOfResources(Integer.valueOf(1));
        String webapp = WPSConfig.getInstance().getWPSConfig().getServer().getWebappPath();
        String host = WPSConfig.getInstance().getWPSConfig().getServer().getHostname();
        String port = WPSConfig.getInstance().getWPSConfig().getServer().getHostport();
        logger.debug("Host: {}  Port: {} Webapp: {} ", new Object[]{host, port, webapp});
        logger.debug("Web persistence path:{} ", (Object)webperspath);
        String webPath = "http://" + host + ":" + port + "/" + webapp + "/persistence/";
        logger.debug("Web app path: {} ", (Object)webPath);
        this.scope = (String)inputs.get(scopeParameter);
        logger.debug("Retrieved scope: {} ", (Object)this.scope);
        if (this.scope == null) {
            throw new Exception("Error: scope parameter (scope) not set! This violates e-Infrastructure security policies");
        }
        if (!this.scope.startsWith("/")) {
            this.scope = "/" + this.scope;
        }
        this.username = (String)inputs.get(usernameParameter);
        this.token = (String)inputs.get(tokenParameter);
        logger.debug("User name used by the client:{} ", (Object)this.username);
        logger.debug("User token used by the client:{} ", (Object)this.token);
        if (this.username == null || this.username.trim().length() == 0) {
            throw new Exception("Error: user name parameter (user.name) not set! This violates e-Infrastructure security policies");
        }
        if (this.token == null || this.token.trim().length() == 0) {
            throw new Exception("Error: token parameter not set! This violates e-Infrastructure security policies");
        }
        this.config.setGcubeScope(this.scope);
        this.config.setGcubeUserName(this.username);
        this.config.setGcubeToken(this.token);
        this.config.setParam(serviceUserNameParameterVariable, this.username);
        this.config.setParam(processingSessionVariable, UUID.randomUUID().toString());
        this.config.setParam(webpathVariable, webPath);
        this.config.setParam(webPersistencePathVariable, webperspath);
    }
}

