/**
 * 
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.io.File;
import java.io.IOException;
import java.util.NoSuchElementException;

/**
 * 
 * Order of processing is:
 * - command line, if given
 * - configuration file provided on the command line
 * - environment variables
 * - local configuration file
 * - global configuration file
 * 
 * @author Paolo Fabriani
 *
 */
public class ConfigurationUtil {

    private String localConfigurationFile;
    
    public String getProperty(String key) throws NoSuchElementException {
        // look in environment
        String out = this.getPropertyInEnvironment(key);
        // look in local configuration file
        if(out==null) {
            out = this.getProperyInLocalConfigurationFile(key);
        }
        // if not null, return
        if(out!=null) {
            return out.trim();
        }
        throw new NoSuchElementException("Unable to find property " + key + " either in environment and configuration files.");
    }
    
    private String getPropertyInEnvironment(String key) {
        return System.getenv(key);
    }
    
    private String getProperyInLocalConfigurationFile(String key) {
        File f = new File(this.getLocalConfigurationFile());
        if(f.exists()) {
            try {
                return PropertiesUtils.getProperties(f).get(key);
            } catch(IOException e) {
                return null;
            }
        } else {
            return null;
        }
    }

    public String getLocalConfigurationFile() {
        return localConfigurationFile;
    }

    public void setLocalConfigurationFile(String localConfigurationFile) {
        this.localConfigurationFile = localConfigurationFile;
    }

}
