/**
 * 
 */
package org.gcube.dataanalysis.datasetimporter.util;

import java.io.IOException;
import java.net.HttpURLConnection;
/**
 * @author Paolo Fabriani
 *
 */
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Vector;

import org.gcube.common.authorization.library.provider.SecurityTokenProvider;
import org.gcube.common.resources.gcore.GCoreEndpoint;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.SimpleQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ISClient {

    private static final Logger logger = LoggerFactory.getLogger(ISClient.class);
    
    public List<URL> getThreddsServicesEndpoints() {
        return this.retrieveService("SDI", "Thredds");
    }

    public List<URL> getCmemsImporterServiceEndpoint() {
        return this.retrieveService("DataAnalysis", "cmems-importer-service");
    }

    private List<URL> retrieveService(String serviceClass, String serviceName) {
        SimpleQuery query = ICFactory.queryFor(GCoreEndpoint.class);
        query.addCondition("$resource/Profile/ServiceClass/text() eq '"
                + serviceClass + "'");
        query.addCondition("$resource/Profile/ServiceName/text() eq '"
                + serviceName + "'");
        query.setResult(
                "$resource/Profile/AccessPoint/RunningInstanceInterfaces/Endpoint/text()");
        DiscoveryClient<String> client = ICFactory.client();
        return this.toURL(client.submit(query));
    }

    public URL getThreddsEndpoint() {
        try {
            return this.getFirstAvailable(new ISClient().getThreddsServicesEndpoints());
        } catch(IOException e) {
            throw new NoSuchElementException("Thredds resources is not available in current scope");
        }
    }

    public URL getCmemsImporterEndpoint() {
        try {
            return this.getFirstAvailable(new ISClient().getCmemsImporterServiceEndpoint());
        } catch(IOException e) {
            throw new NoSuchElementException("Cmems Importer Service is not available in current scope");
        }
    }
    
    private URL getFirstAvailable(List<URL> urls) throws IOException {
        for (URL url : urls) {
            logger.debug("Checking: " + url.toString());
            if(checkAvailable(url) ) {
                String cmemsImporterEndpoint = String.format("%s://%s:%s", url.getProtocol(), url.getHost(), url.getPort());
                logger.info("Picking the first one: " + cmemsImporterEndpoint);
//                logger.info("Picking the first one: " + url);
                return new URL(cmemsImporterEndpoint);
            }
        }
        return null;
    }
    
    private boolean checkAvailable(URL u) throws IOException {
        HttpURLConnection con = (HttpURLConnection) u.openConnection();
        con.setRequestMethod("GET");
        con.setRequestProperty("gcube-token", SecurityTokenProvider.instance.get());
        return (con.getResponseCode()==200);
    }

    private List<URL> toURL(List<String> addresses) {
        List<URL> out = new Vector<>();
        for (String s : addresses) {
            try {
                out.add(new URL(s));
            } catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

}
