/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.retrieval;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.meta.features.FeaturesManager;
import org.gcube.dataanalysis.geo.utils.EnvDataExplorer;
import org.gcube.dataanalysis.geo.utils.ThreddsDataExplorer;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class GeoIntersector {
    private FeaturesManager featurer = new FeaturesManager();
    private String configDir;

    public GeoIntersector(String scope, String cfgDir) {
        this.featurer.setScope(scope);
        this.configDir = cfgDir;
    }

    public LinkedHashMap<String, Double> getFeaturesInTime(String layerTitle, double x, double y) throws Exception {
        return this.getFeaturesInTime(layerTitle, x, y, 0.0);
    }

    public LinkedHashMap<String, Double> getFeaturesInTime(String layerTitle, double x, double y, double z) throws Exception {
        LinkedHashMap<String, Double> features = new LinkedHashMap<String, Double>();
        Metadata meta = this.featurer.checkForMetadatabyTitle(FeaturesManager.treatTitleForGN(layerTitle), layerTitle);
        if (meta != null) {
            String layer = this.featurer.getLayerName(meta);
            if (layer == null) {
                layer = layerTitle;
            }
            if (this.featurer.isThreddsFile(meta)) {
                Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                String title = id.getCitation().getTitle().toString();
                AnalysisLogger.getLogger().debug((Object)("found a netCDF file with title " + title + " and layer name " + layer));
                features = this.getFeaturesFromNetCDF(this.featurer.getOpenDapLink(meta), layer, x, y, z);
            } else {
                AnalysisLogger.getLogger().debug((Object)("found a Geo Layer with title " + layerTitle + " and layer name " + layer));
                features = this.getFeaturesFromWFS(this.featurer.getWFSLink(meta), layer, x, y);
            }
        }
        return features;
    }

    public List<LinkedHashMap<String, Double>> getFeaturesInTime(String layerTitle, List<Tuple<Double>> triplets) throws Exception {
        ArrayList<LinkedHashMap<String, Double>> featuresSets;
        block6: {
            featuresSets = new ArrayList<LinkedHashMap<String, Double>>();
            Metadata meta = this.featurer.checkForMetadatabyTitle(FeaturesManager.treatTitleForGN(layerTitle), layerTitle);
            if (meta == null) break block6;
            String layer = this.featurer.getLayerName(meta);
            if (layer == null) {
                layer = layerTitle;
            }
            if (this.featurer.isThreddsFile(meta)) {
                Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                String title = id.getCitation().getTitle().toString();
                AnalysisLogger.getLogger().debug((Object)("found a netCDF file with title " + title + " and layer name " + layer));
                for (Tuple<Double> triplet : triplets) {
                    double x = (Double)triplet.getElements().get(0);
                    double y = (Double)triplet.getElements().get(1);
                    double z = 0.0;
                    if (triplet.getElements().size() > 2) {
                        z = (Double)triplet.getElements().get(2);
                    }
                    AnalysisLogger.getLogger().debug((Object)("Taking point: (" + x + "," + y + "," + z + ")"));
                    LinkedHashMap<Object, Object> features = new LinkedHashMap();
                    features = this.getFeaturesFromNetCDF(this.featurer.getOpenDapLink(meta), layer, x, y, z);
                    AnalysisLogger.getLogger().debug((Object)("Got: (" + features + ")"));
                    featuresSets.add(features);
                }
            } else {
                AnalysisLogger.getLogger().debug((Object)("found a Geo Layer with title " + layerTitle + " and layer name " + layer));
                for (Tuple<Double> triplet : triplets) {
                    double x = (Double)triplet.getElements().get(0);
                    double y = (Double)triplet.getElements().get(1);
                    AnalysisLogger.getLogger().debug((Object)("Taking point: (" + x + "," + y + ")"));
                    LinkedHashMap<Object, Object> features = new LinkedHashMap();
                    features = this.getFeaturesFromWFS(this.featurer.getWFSLink(meta), layer, x, y);
                    featuresSets.add(features);
                }
            }
        }
        return featuresSets;
    }

    private LinkedHashMap<String, Double> getFeaturesFromNetCDF(String opendapURL, String layer, double x, double y, double z) {
        if (opendapURL == null) {
            return null;
        }
        return ThreddsDataExplorer.retrieveDataFromNetCDF(opendapURL, layer, x, y, z);
    }

    private LinkedHashMap<String, Double> getFeaturesFromWFS(String wfsUrl, String layer, double x, double y) {
        if (wfsUrl == null) {
            return null;
        }
        return EnvDataExplorer.getFeatures(wfsUrl, layer, x, y);
    }

    public double[][] takeLastTimeChunk(String layerTitle, double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Bounding box: (" + x1 + "," + x2 + ";" + y1 + "," + y2 + ")"));
        if (x2 < x1 || y2 < y1) {
            AnalysisLogger.getLogger().debug((Object)"ERROR: BAD BOUNDING BOX!!!");
            return new double[0][0];
        }
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        double[][] slice = new double[ysteps + 1][xsteps + 1];
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        AnalysisLogger.getLogger().debug((Object)("Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
        int i = 0;
        while (i < ysteps + 1) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            int j = 0;
            while (j < xsteps + 1) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                ++j;
            }
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("Taking " + ysteps + " values..."));
        List<LinkedHashMap<String, Double>> time = this.getFeaturesInTime(layerTitle, tuples);
        AnalysisLogger.getLogger().debug((Object)("Taken " + time.size() + " values"));
        int k = 0;
        int g = 0;
        int ntriplets = ysteps * xsteps;
        int t = 0;
        while (t < ntriplets) {
            LinkedHashMap<String, Double> tvalues = time.get(t);
            double value = Double.NaN;
            Iterator<Double> iterator = tvalues.values().iterator();
            if (iterator.hasNext()) {
                Double val = iterator.next();
                value = val;
            }
            slice[k][g] = value;
            if (++g == xsteps) {
                g = 0;
                ++k;
            }
            ++t;
        }
        AnalysisLogger.getLogger().debug((Object)"Applying nearest Neighbor to all the rows");
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(this.configDir);
        int i2 = 0;
        while (i2 < slice.length) {
            AnalysisLogger.getLogger().debug((Object)"Checking for unfilled values");
            boolean tofill = false;
            int j = 0;
            while (j < slice[i2].length) {
                if (slice[i2][j] == Double.NaN) {
                    tofill = true;
                }
                ++j;
            }
            if (tofill) {
                AnalysisLogger.getLogger().debug((Object)"Filling signal");
                slice[i2] = SignalProcessing.fillSignal((double[])slice[i2]);
            } else {
                AnalysisLogger.getLogger().debug((Object)"Signal yet complete");
            }
            ++i2;
        }
        return slice;
    }
}

