/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.retrieval.GeoIntersector;

public class TestIntersectionNetCDF {
    static String cfg = "./cfg/";

    public static void main1(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)(String.valueOf(cfg) + AlgorithmConfiguration.defaultLoggerFile));
        GeoIntersector inters = new GeoIntersector("/gcube/devsec", cfg);
        System.out.println(inters.getFeaturesInTime("temperature (04091217ruc.nc)", 0.1, 0.1));
    }

    public static void main2(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)(String.valueOf(cfg) + AlgorithmConfiguration.defaultLoggerFile));
        GeoIntersector inters = new GeoIntersector(null, cfg);
        System.out.println(inters.getFeaturesInTime("Statistical Mean in [07-01-01 01:00] (3D) {World Ocean Atlas 09: Sea Water Temperature - annual: dods://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/temperature_annual_1deg_ENVIRONMENT_OCEANS_.nc}", -70.0, 0.1, 3000.0));
    }

    public static void main(String[] args) throws Exception {
        AnalysisLogger.setLogger((String)(String.valueOf(cfg) + AlgorithmConfiguration.defaultLoggerFile));
        GeoIntersector inters = new GeoIntersector(null, cfg);
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        double start = -180.0;
        double end = 360.0;
        int steps = 30;
        double step = (end - start) / (double)steps;
        double y = 0.0;
        int i = 0;
        while (i < steps + 1) {
            double x = (double)i * step + start;
            if (i == steps) {
                x = end;
            }
            tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y}));
            ++i;
        }
        List<LinkedHashMap<String, Double>> time = inters.getFeaturesInTime("Statistical Mean in [07-01-01 01:00] (3D) {World Ocean Atlas 09: Sea Water Temperature - annual: dods://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/temperature_annual_1deg_ENVIRONMENT_OCEANS_.nc}", tuples);
        int i2 = 0;
        for (LinkedHashMap<String, Double> timemap : time) {
            Iterator<Double> iterator = timemap.values().iterator();
            if (iterator.hasNext()) {
                Double val = iterator.next();
                System.out.println(((Tuple)tuples.get(i2)).getElements().get(0) + "=" + MathFunctions.roundDecimal((double)val, (int)2));
            }
            ++i2;
        }
    }
}

