/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.trendylyzeralgorithms;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.data.conversions.ImageTools;
import org.gcube.contentmanagement.graphtools.plotting.graphs.HistogramGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.trendylyzeralgorithms.TaxaEnum;
import org.jfree.chart.JFreeChart;
import org.jfree.data.category.DefaultCategoryDataset;
import org.jfree.data.general.Dataset;
import org.postgresql.Driver;

public class TaxaObservationsBarChartAlgorithm
extends StandardLocalExternalAlgorithm {
    static String databaseName = "DatabaseName";
    static String userParameterName = "DatabaseUserName";
    static String passwordParameterName = "DatabasePassword";
    static String urlParameterName = "DatabaseURL";
    private String yearStart = "Start Year :";
    private String yearEnd = "End Year :";
    private String taxa = "Level :";
    String tax;
    protected String fileName;
    BufferedWriter out;
    private String firstTaxaNumber = "TaxaNumber :";
    private int taxaNumber;
    LinkedHashMap<String, StatisticalType> map = new LinkedHashMap();
    private DefaultCategoryDataset dataset;

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization TaxaObservationsBarChartAlgorithm");
    }

    public String getDescription() {
        return "An algorithm producing a bar chart for the most observed taxa in a certain years range (with respect to the OBIS database)";
    }

    protected void process() throws Exception {
        this.dataset = new DefaultCategoryDataset();
        String driverName = "org.postgresql.Driver";
        String tmp = this.getInputParameter(this.firstTaxaNumber);
        this.taxaNumber = Integer.parseInt(tmp);
        Class<?> driverClass = Class.forName(driverName);
        Driver driver = (Driver)driverClass.newInstance();
        String databaseJdbc = this.getInputParameter(urlParameterName);
        String year_start = this.getInputParameter(this.yearStart);
        String year_end = this.getInputParameter(this.yearEnd);
        this.tax = this.getInputParameter(this.taxa);
        String databaseUser = this.getInputParameter(userParameterName);
        String databasePwd = this.getInputParameter(passwordParameterName);
        this.fileName = this.config.getPersistencePath() + "results.csv";
        this.out = new BufferedWriter(new FileWriter(this.fileName));
        Connection connection = null;
        connection = DriverManager.getConnection(databaseJdbc, databaseUser, databasePwd);
        String table = "genus_table_per_year";
        String column_name = "genus";
        if (this.tax.equals("LME")) {
            table = "genus_table_per_year";
            column_name = "genus";
        } else if (this.tax.equals("CLASS")) {
            table = "class_table_per_year";
            column_name = "class";
        } else if (this.tax.equals("FAMILY")) {
            table = "family_table_per_year";
            column_name = "family";
        } else if (this.tax.equals("ORDER")) {
            table = "order_table_per_year";
            column_name = "order";
        }
        Statement stmt = connection.createStatement();
        String query = "SELECT \"" + column_name + "\", sum(count)AS count FROM public." + table + " WHERE year::integer >= " + year_start + "AND year::integer <= " + year_end + " GROUP BY \"" + column_name + "\" ORDER BY count desc;";
        ResultSet rs = stmt.executeQuery(query);
        String s = column_name;
        for (int i = 0; rs.next() && i < this.taxaNumber; ++i) {
            String tname = rs.getString(column_name);
            String count = rs.getString("count");
            this.out.write(column_name + "," + count);
            this.out.newLine();
            if (i < 100) {
                PrimitiveType val = new PrimitiveType(String.class.getName(), (Object)count, PrimitiveTypes.STRING, tname, tname);
                this.map.put(tname, (StatisticalType)val);
            }
            int countOcc = Integer.parseInt(count);
            if (i >= 16) continue;
            this.dataset.addValue((double)countOcc, (Comparable)((Object)s), (Comparable)((Object)tname));
        }
        connection.close();
        this.out.close();
    }

    protected void setInputParameters() {
        this.addStringInput(this.firstTaxaNumber, "Number of taxa to report", "10");
        this.addEnumerateInput(TaxaEnum.values(), this.taxa, "Choose the taxonomy level", TaxaEnum.GENUS.name());
        this.addStringInput(this.yearStart, "Starting year of the analysis", "1800");
        this.addStringInput(this.yearEnd, "Ending year of the analysis", "2020");
        this.addRemoteDatabaseInput("Obis2Repository", urlParameterName, userParameterName, passwordParameterName, "driver", "dialect");
    }

    public void shutdown() {
    }

    public StatisticalType getOutput() {
        PrimitiveType p = new PrimitiveType(Map.class.getName(), (Object)PrimitiveType.stringMap2StatisticalMap((HashMap)this.outputParameters), PrimitiveTypes.MAP, "Discrepancy Analysis", "");
        AnalysisLogger.getLogger().debug((Object)"MapsComparator: Producing Gaussian Distribution for the errors");
        HashMap<String, Image> producedImages = new HashMap<String, Image>();
        JFreeChart chart = HistogramGraph.createStaticChart((Dataset)this.dataset);
        Image image = ImageTools.toImage((BufferedImage)chart.createBufferedImage(680, 420));
        producedImages.put("Taxonomy observations per year (" + this.tax + ")", image);
        PrimitiveType images = new PrimitiveType(HashMap.class.getName(), producedImages, PrimitiveTypes.IMAGES, "ErrorRepresentation", "Graphical representation of the error spread");
        AnalysisLogger.getLogger().debug((Object)"Line Charts Species Occurrences Produced");
        PrimitiveType f = new PrimitiveType(File.class.getName(), (Object)new File(this.fileName), PrimitiveTypes.FILE, "Species observations per area", "ObsFile");
        this.map.put("Output", (StatisticalType)f);
        this.map.put("Result", (StatisticalType)p);
        this.map.put("Images", (StatisticalType)images);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), this.map, PrimitiveTypes.MAP, "ResultsMap", "Results Map");
        return output;
    }
}

