/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.JobSMspd;

import java.util.ArrayList;
import java.util.Vector;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.data.spd.client.plugins.AbstractPlugin;
import org.gcube.data.spd.client.proxies.Manager;
import org.gcube.data.spd.model.products.TaxonomyItem;
import org.gcube.data.streams.Stream;

public class ThreadExtractionTaxaFromSPD
implements Runnable {
    private ArrayList<String> chunk;
    private ArrayList<ArrayList<String>> informations;
    private ArrayList<String> errors;
    private String dataProvider;
    private String dataProviderUnfold;
    private String dataProviderExpand;
    Vector<TaxonomyItem> taxaList = new Vector();
    String scope;

    public ThreadExtractionTaxaFromSPD(ArrayList<String> chunk, String dataProvider, String dataProviderExpand, String dataProviderUnfold, String scope) {
        this.chunk = chunk;
        for (String species : chunk) {
            System.out.println(species);
        }
        this.dataProvider = dataProvider;
        this.dataProviderExpand = dataProviderExpand;
        this.dataProviderUnfold = dataProviderUnfold;
        this.informations = new ArrayList();
        this.errors = new ArrayList();
        this.scope = scope;
    }

    @Override
    public void run() {
        AnalysisLogger.getLogger().debug((Object)("SCOPE *******: " + this.scope));
        ScopeProvider.instance.set(this.scope);
        Manager manager = null;
        try {
            manager = (Manager)AbstractPlugin.manager().build();
            for (String species : this.chunk) {
                if (species == null) continue;
                String query = new String();
                query = this.createQueryParameter(species);
                System.out.println("QUERY *******: " + query);
                AnalysisLogger.getLogger().debug((Object)("QUERY *******: " + query));
                try {
                    Stream stream = manager.search(query);
                    int i = 0;
                    while (stream.hasNext()) {
                        ++i;
                        TaxonomyItem ti = (TaxonomyItem)stream.next();
                        System.out.println("Inside whiele: " + ti.toString());
                        this.taxaList.add(ti);
                        this.informations.add(this.crateRowTable(ti));
                    }
                    if (i != 0) continue;
                    this.errors.add(String.valueOf(species) + " not found.");
                }
                catch (Exception e) {
                    this.errors.add("Exception on " + species + " :" + e.getMessage());
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)("An error occurred: " + e.getMessage()));
        }
    }

    private String createQueryParameter(String species) {
        String query = "SEARCH BY SN '" + species + "'";
        String where = new String();
        String expand = new String();
        String unfold = new String();
        where = this.dataProvider.equals("ALL") ? "" : " IN " + this.dataProvider;
        unfold = this.dataProviderUnfold.equals("NO OPTION") ? "" : " UNFOLD WITH " + this.dataProviderUnfold;
        query = String.valueOf(query) + unfold;
        expand = this.dataProviderExpand.equals("ALL") ? " EXPAND" : (this.dataProviderExpand.equals("NO OPTION") ? "" : " EXPAND WITH " + this.dataProviderExpand);
        query = String.valueOf(query) + expand;
        query = String.valueOf(query) + where;
        query = String.valueOf(query) + " RETURN TAXON";
        return query;
    }

    private ArrayList<String> crateRowTable(TaxonomyItem p) {
        ArrayList<String> infoOcc = new ArrayList<String>();
        infoOcc.add(p.getScientificName());
        infoOcc.add(p.getAuthor());
        infoOcc.add(p.getCitation());
        infoOcc.add(p.getCredits());
        infoOcc.add(p.getId());
        infoOcc.add(p.getLsid());
        infoOcc.add(p.getProvider());
        infoOcc.add(p.getRank());
        return infoOcc;
    }

    public ArrayList<ArrayList<String>> getInfo() {
        return this.informations;
    }

    public ArrayList<String> getErrors() {
        return this.errors;
    }

    public Vector<TaxonomyItem> getTaxaList() {
        return this.taxaList;
    }
}

