/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.etopenmanmonteithfao;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.SessionFactory;

public class EtoPenmanMonteithFao
extends StandardLocalExternalAlgorithm {
    String outputtablename;
    String outputtable;

    public String getDescription() {
        return "This is an algorithm that returns the calculation of The Penman-Monteith Evapotranspiration Estimation by FAO-56 Method. The input is a general tabular resource with nine columns (date, latitude, altitude, temperature, max temperature, min temperature relative humidity, wind speed, and radiation).";
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization");
    }

    protected void process() throws Exception {
        block23: {
            this.config.setParam("DatabaseDriver", "org.postgresql.Driver");
            SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            try {
                try {
                    String tablename = this.getInputParameter("MetTable");
                    String columnnames = this.getInputParameter("MetColumns");
                    this.outputtablename = this.getInputParameter("OutputTableName");
                    this.outputtable = this.getInputParameter("OutputTable");
                    String[] columnlist = columnnames.split(AlgorithmConfiguration.getListSeparator());
                    List dayList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[0] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List latitudeList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[1] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List altitudeList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[2] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List tempatureList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[3] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List maxTempatureList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[4] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List minTempatureList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[5] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List relativeHumidityList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[6] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List windSpeedList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[7] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    List radiationList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[8] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                    AnalysisLogger.getLogger().info((Object)("Creating output table [create table " + this.outputtable + " (day date, etopmf real)]"));
                    DatabaseFactory.executeSQLUpdate((String)("create table " + this.outputtable + " (day date, etopmf real)"), (SessionFactory)dbconnection);
                    Double z = Double.parseDouble(String.valueOf(altitudeList.get(0)));
                    Double lat = Double.parseDouble(String.valueOf(latitudeList.get(0)));
                    Double etopmf = 0.0;
                    Boolean isLineWithNullValues = false;
                    if (z == null) {
                        isLineWithNullValues = true;
                    }
                    if (lat == null) {
                        isLineWithNullValues = true;
                    }
                    if (!isLineWithNullValues.booleanValue()) {
                        Double patm = 101.3 * Math.pow((293.0 - 0.0065 * z) / 293.0, 5.26);
                        Double lambda = 0.665 * Math.pow(10.0, -3.0) * patm;
                        int i = 0;
                        while (i < dayList.size()) {
                            Double t = Double.parseDouble(String.valueOf(tempatureList.get(i)));
                            Double maxT = Double.parseDouble(String.valueOf(maxTempatureList.get(i)));
                            Double minT = Double.parseDouble(String.valueOf(minTempatureList.get(i)));
                            Double ru = Double.parseDouble(String.valueOf(relativeHumidityList.get(i)));
                            Double u2 = Double.parseDouble(String.valueOf(windSpeedList.get(i)));
                            Double rs = Double.parseDouble(String.valueOf(radiationList.get(i)));
                            Date day = EtoPenmanMonteithFao.anyStringToDate(String.valueOf(dayList.get(i)));
                            if (t == null) {
                                isLineWithNullValues = true;
                            }
                            if (maxT == null) {
                                isLineWithNullValues = true;
                            }
                            if (minT == null) {
                                isLineWithNullValues = true;
                            }
                            if (maxT < minT) {
                                isLineWithNullValues = true;
                            }
                            if (ru == null) {
                                isLineWithNullValues = true;
                            }
                            if (u2 == null) {
                                isLineWithNullValues = true;
                            }
                            if (day == null) {
                                isLineWithNullValues = true;
                            }
                            if (!isLineWithNullValues.booleanValue()) {
                                String dateStr;
                                SimpleDateFormat sdf;
                                if (i == 0) {
                                    etopmf = EtoPenmanMonteithFao.dailyEtoCalculation(day, lat, z, t, maxT, minT, ru, u2, rs, lambda);
                                    if (dayList.size() == 1) {
                                        sdf = new SimpleDateFormat("yyyy/MM");
                                        dateStr = sdf.format(EtoPenmanMonteithFao.anyStringToDate(String.valueOf(dayList.get(i))));
                                        AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (day, etopmf)  values (to_date('" + dateStr + "', 'yyyy/MM')," + etopmf + ")"));
                                        DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (day,etopmf) values (to_date('" + dateStr + "', 'yyyy/MM')," + etopmf + ")"), (SessionFactory)dbconnection);
                                        etopmf = new Double(0.0);
                                    }
                                }
                                if (i > 0) {
                                    Date currentDate = EtoPenmanMonteithFao.anyStringToDate(String.valueOf(dayList.get(i)));
                                    Date lastDate = EtoPenmanMonteithFao.anyStringToDate(String.valueOf(dayList.get(i - 1)));
                                    Calendar currentDateCal = Calendar.getInstance();
                                    currentDateCal.setTime(currentDate);
                                    int monthCurrentDate = currentDateCal.get(2);
                                    int yearCurrentDate = currentDateCal.get(1);
                                    Calendar lastDateCal = Calendar.getInstance();
                                    lastDateCal.setTime(lastDate);
                                    int monthLastDate = lastDateCal.get(2);
                                    int yearLastDate = lastDateCal.get(1);
                                    if (monthCurrentDate > monthLastDate || yearCurrentDate > yearLastDate) {
                                        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy/MM");
                                        String dateStr2 = sdf2.format(lastDate);
                                        AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (day, etopmf)  values (to_date('" + dateStr2 + "', 'yyyy/MM')," + etopmf + ")"));
                                        DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (day,etopmf) values (to_date('" + dateStr2 + "', 'yyyy/MM')," + etopmf + ")"), (SessionFactory)dbconnection);
                                        etopmf = new Double(0.0);
                                        etopmf = EtoPenmanMonteithFao.dailyEtoCalculation(day, lat, z, t, maxT, minT, ru, u2, rs, lambda);
                                    } else {
                                        etopmf = etopmf + EtoPenmanMonteithFao.dailyEtoCalculation(day, lat, z, t, maxT, minT, ru, u2, rs, lambda);
                                    }
                                }
                                if (i != 0 && i == dayList.size() - 1) {
                                    sdf = new SimpleDateFormat("yyyy/MM");
                                    dateStr = sdf.format(EtoPenmanMonteithFao.anyStringToDate(String.valueOf(dayList.get(i))));
                                    AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (day, etopmf)  values (to_date('" + dateStr + "', 'yyyy/MM')," + etopmf + ")"));
                                    DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (day,etopmf) values (to_date('" + dateStr + "', 'yyyy/MM')," + etopmf + ")"), (SessionFactory)dbconnection);
                                }
                            }
                            t = null;
                            ru = null;
                            rs = null;
                            isLineWithNullValues = false;
                            ++i;
                        }
                        break block23;
                    }
                    throw new Exception("No altitude or latitude value defined for this tabular resource.");
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().error((Object)e.getMessage());
                    throw e;
                }
            }
            finally {
                DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
            }
        }
    }

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, "MetTable", "Meteorological data tabular resource");
        ColumnTypesList columns = new ColumnTypesList("MetTable", "MetColumns", "Selected columns for date, latitude, altitude, temperature, max temperature, min temperature relative humidity, wind speed, and radiation", false);
        this.inputs.add(tinput);
        this.inputs.add(columns);
        ServiceType randomstring = new ServiceType(ServiceParameters.RANDOMSTRING, "OutputTable", "", "met");
        this.inputs.add(randomstring);
        DatabaseType.addDefaultDBPars((List)this.inputs);
        this.addStringInput("OutputTableName", "The name of the output table", "met_");
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> outtemplate = new ArrayList<TableTemplates>();
        outtemplate.add(TableTemplates.GENERIC);
        OutputTable out = new OutputTable(outtemplate, this.outputtablename, this.outputtable, "The output table containing all the matches");
        return out;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }

    public static Date anyStringToDate(String value) {
        Date date = null;
        try {
            SimpleDateFormat sdf;
            if (EtoPenmanMonteithFao.isValidFormat("yyyy-MM-dd", value)) {
                sdf = new SimpleDateFormat("yyyy-MM-dd");
                date = sdf.parse(value);
            }
            if (EtoPenmanMonteithFao.isValidFormat("yyyyMMdd", value)) {
                sdf = new SimpleDateFormat("yyyyMMdd");
                date = sdf.parse(value);
            }
            if (EtoPenmanMonteithFao.isValidFormat("dd/MM/yyyy", value)) {
                sdf = new SimpleDateFormat("dd/MM/yyyy");
                date = sdf.parse(value);
            }
            if (EtoPenmanMonteithFao.isValidFormat("dd-MM-yyyy", value)) {
                sdf = new SimpleDateFormat("dd-MM-yyyy");
                date = sdf.parse(value);
            }
        }
        catch (Exception e) {
            date = null;
        }
        return date;
    }

    public static boolean isValidFormat(String format, String value) {
        Date date = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(format);
            date = sdf.parse(value);
            if (!value.equals(sdf.format(date))) {
                date = null;
            }
        }
        catch (ParseException ex) {
            date = null;
        }
        return date != null;
    }

    public static Double dailyEtoCalculation(Date day, Double lat, Double z, Double t, Double maxT, Double minT, Double ru, Double u2, Double rs, Double lambda) {
        Double dailyetopmf = new Double(0.0);
        Double g = 0.0;
        Double delta = 4098.0 * (0.6018 * Math.exp(17.27 * t / (t + 273.3))) / Math.pow(t + 237.2, 2.0);
        Double es = 0.6108 * Math.exp(17.27 * t / (t + 237.3));
        Double ea = es * ru / 100.0;
        Double rn = 0.0;
        if (rs == null || rs == 0.0) {
            Double krs = 0.16;
            Calendar cal = null;
            cal = Calendar.getInstance();
            cal.setTime(day);
            Integer j = cal.get(6);
            Double phi = lat * Math.PI / 180.0;
            Double delta_lowercase = 0.409 * Math.sin(0.01721420632103996 * (double)j.intValue() - 1.39);
            Double x = 1.0 - Math.pow(Math.tan(phi), 2.0) * Math.pow(Math.tan(delta_lowercase), 2.0);
            if (x <= 0.0) {
                x = 1.0E-5;
            }
            Double omega_s = 1.5707963267948966 - Math.atan(-Math.tan(phi) * Math.tan(delta_lowercase) / Math.pow(x, 0.5));
            Double dr = 1.0 + 0.033 * Math.cos(0.01721420632103996 * (double)j.intValue());
            Double ra = 37.586031360582005 * dr * (omega_s * Math.sin(phi) * Math.sin(delta_lowercase) + Math.cos(phi) * Math.cos(delta_lowercase) * Math.sin(omega_s));
            rs = krs * ra * Math.sqrt(maxT - minT);
            Double rns = 0.77 * rs;
            Double rso = (0.75 + 2.0 * Math.pow(10.0, -5.0) * z) * ra;
            Double sigma = 4.903 * Math.pow(10.0, -9.0);
            Double rnl = sigma * ((Math.pow(maxT + 273.16, 4.0) + Math.pow(minT + 273.16, 4.0)) / 2.0) * (0.34 - 0.14 * Math.sqrt(ea)) * (1.35 * (rs / rso) - 0.35);
            rn = rns - rnl;
        } else {
            Double krs = 0.16;
            Calendar cal = null;
            cal = Calendar.getInstance();
            cal.setTime(day);
            Integer j = cal.get(6);
            Double phi = lat * Math.PI / 180.0;
            Double delta_lowercase = 0.409 * Math.sin(0.01721420632103996 * (double)j.intValue() - 1.39);
            Double x = 1.0 - Math.pow(Math.tan(phi), 2.0) * Math.pow(Math.tan(delta_lowercase), 2.0);
            if (x <= 0.0) {
                x = 1.0E-5;
            }
            Double omega_s = 1.5707963267948966 - Math.atan(-Math.tan(phi) * Math.tan(delta_lowercase) / Math.pow(x, 0.5));
            Double dr = 1.0 + 0.033 * Math.cos(0.01721420632103996 * (double)j.intValue());
            Double ra = 37.586031360582005 * dr * (omega_s * Math.sin(phi) * Math.sin(delta_lowercase) + Math.cos(phi) * Math.cos(delta_lowercase) * Math.sin(omega_s));
            Double rns = 0.77 * rs;
            Double rso = (0.75 + 2.0 * Math.pow(10.0, -5.0) * z) * ra;
            Double sigma = 4.903 * Math.pow(10.0, -9.0);
            Double rnl = sigma * ((Math.pow(maxT + 273.16, 4.0) + Math.pow(minT + 273.16, 4.0)) / 2.0) * (0.34 - 0.14 * Math.sqrt(ea)) * (1.35 * (rs / rso) - 0.35);
            rn = rns - rnl;
        }
        dailyetopmf = (0.408 * delta * (rn - g) + lambda * 900.0 * u2 * (es - ea) / (t + 273.0)) / (delta + lambda * (1.0 + 0.34 * u2));
        if (dailyetopmf == null || Double.isNaN(dailyetopmf)) {
            dailyetopmf = 0.0;
        }
        return dailyetopmf;
    }
}

