/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.averageannual;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalInfraAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.hibernate.SessionFactory;

public class AverageAnnualPrecipitation
extends StandardLocalInfraAlgorithm {
    String outputtablename;
    String outputtable;

    public String getDescription() {
        return "This is a simple algorithm that returns the average annual of precipitation. The input is a general tabular resource with two columns (date and precipitation).";
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Initialization");
    }

    protected void process() throws Exception {
        this.config.setParam("DatabaseDriver", "org.postgresql.Driver");
        SessionFactory dbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
        try {
            try {
                String tablename = this.getInputParameter("PrecTable");
                String columnnames = this.getInputParameter("PrecColumns");
                this.outputtablename = this.getInputParameter("OutputTableName");
                this.outputtable = this.getInputParameter("OutputTable");
                String[] columnlist = columnnames.split(AlgorithmConfiguration.getListSeparator());
                List dataList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[0] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                List precList = DatabaseFactory.executeSQLQuery((String)("select " + columnlist[1] + " from " + tablename + " order by " + columnlist[0] + " asc"), (SessionFactory)dbconnection);
                AnalysisLogger.getLogger().info((Object)("Creating output table [create table " + this.outputtable + " (year integer, value real)]"));
                DatabaseFactory.executeSQLUpdate((String)("create table " + this.outputtable + " (year integer, value real)"), (SessionFactory)dbconnection);
                ArrayList avaregePrecList = new ArrayList();
                Float averageValue = Float.valueOf(0.0f);
                int i = 0;
                while (i < dataList.size()) {
                    int yearCurrentDate;
                    Calendar currentDateCal;
                    Date currentDate;
                    if (i == 0) {
                        averageValue = Float.valueOf(averageValue.floatValue() + Float.parseFloat("" + precList.get(i)));
                        if (dataList.size() == 1) {
                            currentDate = (Date)dataList.get(i);
                            currentDateCal = Calendar.getInstance();
                            currentDateCal.setTime(currentDate);
                            yearCurrentDate = currentDateCal.get(1);
                            AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (year,value) values (" + yearCurrentDate + "," + averageValue + ")"));
                            DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (year,value) values (" + yearCurrentDate + "," + averageValue + ")"), (SessionFactory)dbconnection);
                            averageValue = Float.valueOf(0.0f);
                        }
                    }
                    if (i > 0) {
                        currentDate = (Date)dataList.get(i);
                        Date lastDate = (Date)dataList.get(i - 1);
                        Calendar currentDateCal2 = Calendar.getInstance();
                        currentDateCal2.setTime(currentDate);
                        int yearCurrentDate2 = currentDateCal2.get(1);
                        Calendar lastDateCal = Calendar.getInstance();
                        lastDateCal.setTime(lastDate);
                        int yearLastDate = lastDateCal.get(1);
                        if (yearCurrentDate2 > yearLastDate) {
                            AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (year,value) values (" + yearLastDate + "," + averageValue + ")"));
                            DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (year,value) values (" + yearLastDate + "," + averageValue + ")"), (SessionFactory)dbconnection);
                            averageValue = Float.valueOf(0.0f);
                            averageValue = Float.valueOf(Float.parseFloat("" + precList.get(i)));
                        } else {
                            averageValue = Float.valueOf(averageValue.floatValue() + Float.parseFloat("" + precList.get(i)));
                        }
                    }
                    if (i != 0 && i == dataList.size() - 1) {
                        currentDate = (Date)dataList.get(i);
                        currentDateCal = Calendar.getInstance();
                        currentDateCal.setTime(currentDate);
                        yearCurrentDate = currentDateCal.get(1);
                        AnalysisLogger.getLogger().info((Object)("Inserting into table insert into " + this.outputtable + " (year,value) values (" + yearCurrentDate + "," + averageValue + ")"));
                        DatabaseFactory.executeSQLUpdate((String)("insert into " + this.outputtable + " (year,value) values (" + yearCurrentDate + "," + averageValue + ")"), (SessionFactory)dbconnection);
                        averageValue = Float.valueOf(0.0f);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                AnalysisLogger.getLogger().error((Object)e.getMessage());
                throw e;
            }
        }
        finally {
            DatabaseUtils.closeDBConnection((SessionFactory)dbconnection);
        }
    }

    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, "PrecTable", "Precipitation tabular resource");
        ColumnTypesList columns = new ColumnTypesList("PrecTable", "PrecColumns", "Selected columns for date and precipitation", false);
        this.inputs.add(tinput);
        this.inputs.add(columns);
        ServiceType randomstring = new ServiceType(ServiceParameters.RANDOMSTRING, "OutputTable", "", "prec");
        this.inputs.add(randomstring);
        DatabaseType.addDefaultDBPars((List)this.inputs);
        this.addStringInput("OutputTableName", "The name of the output table", "prec_");
    }

    public StatisticalType getOutput() {
        ArrayList<TableTemplates> outtemplate = new ArrayList<TableTemplates>();
        outtemplate.add(TableTemplates.GENERIC);
        OutputTable out = new OutputTable(outtemplate, this.outputtablename, this.outputtable, "The output table containing all the matches");
        return out;
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"Shutdown");
    }
}

