/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.meta.features;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;
import java.util.ArrayList;
import java.util.List;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkPublisher;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.identification.Identification;

public class FeaturesManager {
    private String geonetworkUrl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
    private String geonetworkUser = "admin";
    private String geonetworkPwd = "admin";
    private String scope = "/gcube/devsec";

    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    private String searchInUrl(Metadata meta, String criterion) {
        String link = null;
        block0: for (DigitalTransferOptions option : meta.getDistributionInfo().getTransferOptions()) {
            for (OnlineResource resource : option.getOnLines()) {
                String tlink = resource.getLinkage().toString();
                if (!tlink.toLowerCase().contains(criterion.toLowerCase())) continue;
                link = tlink;
                continue block0;
            }
        }
        if (link == null) {
            System.out.println("NO ONLINE LINK WAS FOUND ACCORDING TO THE CRITERION :" + criterion);
        }
        return link;
    }

    public String getWFSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wfs");
    }

    public String getWMSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wms");
    }

    public String getWCSLink(Metadata meta) {
        return this.searchInUrl(meta, "service=wcs");
    }

    public String getOpenDapLink(Metadata meta) {
        return this.searchInUrl(meta, "/dodsC");
    }

    public String getThreddsLink(Metadata meta) {
        return this.searchInUrl(meta, "catalog.xml");
    }

    public String getLayerName(Metadata meta) {
        int idxfinder;
        String wmslink = this.getWMSLink(meta);
        String layer = null;
        String finder = "layers=";
        if (wmslink != null && (idxfinder = wmslink.indexOf(finder)) > 0) {
            int andIdx = (wmslink = wmslink.substring(idxfinder)).indexOf("&");
            if (andIdx < 0) {
                andIdx = wmslink.length();
            }
            layer = wmslink.substring(finder.length(), andIdx).trim();
        }
        return layer;
    }

    public boolean isThreddsFile(Metadata meta) {
        return this.getOpenDapLink(meta) != null;
    }

    public GeoNetworkReader initGeoNetworkReader() throws Exception {
        if (this.scope != null) {
            ScopeProvider.instance.set(this.scope);
        } else {
            ConfigurationManager.setConfiguration((Configuration)new Configuration(){

                public String getGeoNetworkUser() {
                    return FeaturesManager.this.geonetworkUser;
                }

                public String getGeoNetworkPassword() {
                    return FeaturesManager.this.geonetworkPwd;
                }

                public String getGeoNetworkEndpoint() {
                    return FeaturesManager.this.geonetworkUrl;
                }
            });
        }
        GeoNetworkPublisher gn = GeoNetwork.get();
        return gn;
    }

    public String getGeonetworkURLFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return gn.getConfiguration().getGeoNetworkEndpoint();
    }

    public String getGeonetworkUserFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return gn.getConfiguration().getGeoNetworkUser();
    }

    public String getGeonetworkPasswordFromScope() throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        return gn.getConfiguration().getGeoNetworkPassword();
    }

    public Metadata getGNInfobyTitle(String info) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login();
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    break;
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return meta;
    }

    public List<Metadata> getAllGNInfobyTitle(String info, String tolerance) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login();
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        req.addConfig(GNSearchRequest.Config.similarity, tolerance);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        ArrayList<Metadata> metadatalist = new ArrayList<Metadata>();
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    metadatalist.add(meta);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return metadatalist;
    }

    public List<Metadata> getFastGNInfobyTitle(String info, String completeTitle, String tolerance) throws Exception {
        GeoNetworkReader gn = this.initGeoNetworkReader();
        gn.login();
        GNSearchRequest req = new GNSearchRequest();
        req.addParam(GNSearchRequest.Param.title, info);
        req.addConfig(GNSearchRequest.Config.similarity, tolerance);
        GNSearchResponse resp = gn.query(req);
        Metadata meta = null;
        ArrayList<Metadata> metadatalist = new ArrayList<Metadata>();
        if (resp.getCount() != 0) {
            for (GNSearchResponse.GNMetadata metadata : resp) {
                try {
                    meta = gn.getById(metadata.getUUID());
                    Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                    String title = id.getCitation().getTitle().toString();
                    if (!title.equalsIgnoreCase(completeTitle)) continue;
                    metadatalist.add(meta);
                    break;
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)"Error retrieving information for some metadata");
                }
            }
        }
        return metadatalist;
    }

    public Metadata checkForMetadatabyTitle(String searchString, String completetitle) throws Exception {
        return this.checkForMetadatabyTitle(searchString, completetitle, "");
    }

    public Metadata checkForMetadatabyTitle(String searchString, String completetitle, String filename) throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Searching for: " + searchString));
        List<Metadata> mlist = this.getFastGNInfobyTitle(searchString, completetitle, "1");
        AnalysisLogger.getLogger().debug((Object)("Found:" + mlist.size() + " results"));
        Metadata mfound = null;
        for (Metadata m : mlist) {
            Identification id = (Identification)m.getIdentificationInfo().iterator().next();
            String title = id.getCitation().getTitle().toString();
            if (!completetitle.equalsIgnoreCase(title)) continue;
            mfound = m;
            break;
        }
        return mfound;
    }

    public String getGeonetworkUrl() {
        return this.geonetworkUrl;
    }

    public void setGeonetworkUrl(String geonetworkUrl) {
        this.geonetworkUrl = geonetworkUrl;
    }

    public String getGeonetworkUser() {
        return this.geonetworkUser;
    }

    public void setGeonetworkUser(String geonetworkUser) {
        this.geonetworkUser = geonetworkUser;
    }

    public String getGeonetworkPwd() {
        return this.geonetworkPwd;
    }

    public void setGeonetworkPwd(String geonetworkPwd) {
        this.geonetworkPwd = geonetworkPwd;
    }

    public static String treatTitleForGN(String layerTitle) {
        int idx = layerTitle.indexOf(" from ");
        String layerTitle2 = layerTitle;
        if (idx > 0) {
            layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
        } else {
            idx = layerTitle.indexOf(" in ");
            if (idx > 0) {
                layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
            } else {
                idx = layerTitle.indexOf("(");
                if (idx > 0) {
                    layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
                }
            }
        }
        layerTitle2 = layerTitle2.replaceAll("(\\(.*\\))", " ");
        layerTitle2 = layerTitle2.replace("_", " ").replace("-", " ").replace("(", " ").replace(")", " ");
        String punct = "[!\"#$%&'*+,./:;<=>?@\\^_`{|}~-]";
        layerTitle2 = layerTitle2.replaceAll("( |^)+[^A-Za-z]+(" + punct + ")*[^A-Za-z]*", " ").trim();
        return layerTitle2.replaceAll(punct, " ").replaceAll("( )+", " ");
    }

    public static void main1(String[] args) throws Exception {
        String title = "geopotential height";
        FeaturesManager fm = new FeaturesManager();
        Metadata meta = fm.getGNInfobyTitle(title);
        System.out.println("is file? " + fm.isThreddsFile(meta));
        System.out.println("opendap: " + fm.getOpenDapLink(meta));
        System.out.println("wcs:" + fm.getWCSLink(meta));
        System.out.println("wms:" + fm.getWMSLink(meta));
        System.out.println("thredds:" + fm.getThreddsLink(meta));
    }

    public static void main(String[] args) throws Exception {
        System.out.println(FeaturesManager.treatTitleForGN("sea/land/lake/ice field composite mask from"));
    }
}

