package org.gcube.dataanalysis.geo.meta.features;

import it.geosolutions.geonetwork.util.GNSearchRequest;
import it.geosolutions.geonetwork.util.GNSearchResponse;

import java.util.ArrayList;
import java.util.List;

import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.spatial.data.geonetwork.GeoNetwork;
import org.gcube.spatial.data.geonetwork.GeoNetworkReader;
import org.gcube.spatial.data.geonetwork.configuration.Configuration;
import org.gcube.spatial.data.geonetwork.configuration.ConfigurationManager;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.distribution.DigitalTransferOptions;
import org.opengis.metadata.identification.Identification;

public class FeaturesManager {
	private String geonetworkUrl = "http://geoserver-dev2.d4science-ii.research-infrastructures.eu/geonetwork/";
	private String geonetworkUser = "admin";
	private String geonetworkPwd = "admin";
	private String scope = "/gcube/devsec";

	public String getScope() {
		return scope;
	}

	public void setScope(String scope) {
		this.scope = scope;
	}

	private String searchInUrl(Metadata meta, String criterion) {
		String link = null;
		for (DigitalTransferOptions option : meta.getDistributionInfo().getTransferOptions()) {
			for (OnlineResource resource : option.getOnLines()) {
				String tlink = resource.getLinkage().toString();
				if (tlink.toLowerCase().contains(criterion.toLowerCase())) {
					link = tlink;
					break;
				}
			}

		}
		if (link == null)
			System.out.println("NO ONLINE LINK WAS FOUND ACCORDING TO THE CRITERION :" + criterion);
		return link;
	}

	public String getWFSLink(Metadata meta) {
		return searchInUrl(meta, "service=wfs");
	}

	// retrieves the wms link
	public String getWMSLink(Metadata meta) {
		return searchInUrl(meta, "service=wms");
	}

	public String getWCSLink(Metadata meta) {
		return searchInUrl(meta, "service=wcs");
	}

	public String getOpenDapLink(Metadata meta) {
		return searchInUrl(meta, "/dodsC");
	}

	public String getThreddsLink(Metadata meta) {
		return searchInUrl(meta, "catalog.xml");
	}

	public String getLayerName(Metadata meta) {
		String wmslink = getWMSLink(meta);
		String layer = null;
		String finder = "layers=";
		if (wmslink != null) {
			int idxfinder = wmslink.indexOf(finder);
			if (idxfinder > 0) {
				wmslink = wmslink.substring(idxfinder);
				int andIdx = wmslink.indexOf("&");
				if (andIdx < 0)
					andIdx = wmslink.length();

				layer = wmslink.substring(finder.length(), andIdx).trim();
			}
		}
		return layer;
	}

	public boolean isThreddsFile(Metadata meta) {
		return (getOpenDapLink(meta) != null);
	}

	public GeoNetworkReader initGeoNetworkReader() throws Exception {
		if (scope!=null)
			ScopeProvider.instance.set(scope);
		else{
			ConfigurationManager.setConfiguration(new Configuration() {
				@Override
				public String getGeoNetworkUser() {
					return geonetworkUser;
				}
				@Override
				public String getGeoNetworkPassword() {
					return geonetworkPwd;
				}
				@Override
				public String getGeoNetworkEndpoint() {
					return geonetworkUrl;
				}
		});
		}
		GeoNetworkReader gn = GeoNetwork.get();
		return gn;
	}

	public String getGeonetworkURLFromScope() throws Exception {
		GeoNetworkReader gn = initGeoNetworkReader();
		return gn.getConfiguration().getGeoNetworkEndpoint();
	}

	public String getGeonetworkUserFromScope() throws Exception {
		GeoNetworkReader gn = initGeoNetworkReader();
		return gn.getConfiguration().getGeoNetworkUser();
	}

	public String getGeonetworkPasswordFromScope() throws Exception {
		GeoNetworkReader gn = initGeoNetworkReader();
		return gn.getConfiguration().getGeoNetworkPassword();
	}

	public Metadata getGNInfobyTitle(String info) throws Exception {

		GeoNetworkReader gn = initGeoNetworkReader();
		// Form query object
		gn.login();
		GNSearchRequest req = new GNSearchRequest();
		req.addParam(GNSearchRequest.Param.title, info);
		// req.addConfig(GNSearchRequest.Config.similarity, "1");
		GNSearchResponse resp = gn.query(req);
		Metadata meta = null;
		if (resp.getCount() != 0)
			for (GNSearchResponse.GNMetadata metadata : resp) {
				try {
					meta = gn.getById(metadata.getUUID());
					break;
				} catch (Exception e) {
					AnalysisLogger.getLogger().debug("Error retrieving information for some metadata");
				}
			}

		return meta;
	}

	public List<Metadata> getAllGNInfobyTitle(String info, String tolerance) throws Exception {

		GeoNetworkReader gn = initGeoNetworkReader();
		// Form query object
		gn.login();
		GNSearchRequest req = new GNSearchRequest();
		req.addParam(GNSearchRequest.Param.title, info);
		req.addConfig(GNSearchRequest.Config.similarity, tolerance);
		GNSearchResponse resp = gn.query(req);
		Metadata meta = null;
		List<Metadata> metadatalist = new ArrayList<Metadata>();
		if (resp.getCount() != 0)
			for (GNSearchResponse.GNMetadata metadata : resp) {
				try {
					meta = gn.getById(metadata.getUUID());
					metadatalist.add(meta);
				} catch (Exception e) {
					AnalysisLogger.getLogger().debug("Error retrieving information for some metadata");
				}
			}

		return metadatalist;
	}
	
	
	public List<Metadata> getFastGNInfobyTitle(String info, String completeTitle, String tolerance) throws Exception {

		GeoNetworkReader gn = initGeoNetworkReader();
		// Form query object
		gn.login();
		GNSearchRequest req = new GNSearchRequest();
		req.addParam(GNSearchRequest.Param.title, info);
		req.addConfig(GNSearchRequest.Config.similarity, tolerance);
		GNSearchResponse resp = gn.query(req);
		Metadata meta = null;
		List<Metadata> metadatalist = new ArrayList<Metadata>();
		if (resp.getCount() != 0){
			for (GNSearchResponse.GNMetadata metadata : resp) {
				try {
						meta = gn.getById(metadata.getUUID());
						Identification id = meta.getIdentificationInfo().iterator().next();
						String title = id.getCitation().getTitle().toString();
						if (title.equalsIgnoreCase(completeTitle)){
							metadatalist.add(meta);
							break;
						}
				} catch (Exception e) {
					AnalysisLogger.getLogger().debug("Error retrieving information for some metadata");
				}
			}
		}
		return metadatalist;
	}
	
	
	public Metadata checkForMetadatabyTitle(String searchString, String completetitle) throws Exception {
		return checkForMetadatabyTitle(searchString, completetitle, "");
	}
	
	public Metadata checkForMetadatabyTitle(String searchString, String completetitle, String filename) throws Exception {
		AnalysisLogger.getLogger().debug("Searching for: "+searchString);
		List<Metadata> mlist = getFastGNInfobyTitle(searchString, completetitle,"1");
		AnalysisLogger.getLogger().debug("Found:"+mlist.size()+" results");
		Metadata mfound = null;
//		DefaultInternationalString intfilename = new DefaultInternationalString(filename);
		for (Metadata m : mlist) {
			Identification id = m.getIdentificationInfo().iterator().next();
			String title = id.getCitation().getTitle().toString();
			if (completetitle.equalsIgnoreCase(title)) {
			/*
				Iterator<? extends Keywords> it = id.getDescriptiveKeywords().iterator();
				while (it.hasNext()){
					Keywords keys = (Keywords)it.next();
					for (InternationalString is :keys.getKeywords()){
//						System.out.println(is);
						if (is.toString().equals(filename)){
							mfound = m;
							break;
						}
					}
					if (mfound!=null)
						break;
				} 
			}
			if (mfound!=null)
				break;
				*/
				mfound = m;
				break;
			}
		}

		return mfound;
	}

	public String getGeonetworkUrl() {
		return geonetworkUrl;
	}

	public void setGeonetworkUrl(String geonetworkUrl) {
		this.geonetworkUrl = geonetworkUrl;
	}

	public String getGeonetworkUser() {
		return geonetworkUser;
	}

	public void setGeonetworkUser(String geonetworkUser) {
		this.geonetworkUser = geonetworkUser;
	}

	public String getGeonetworkPwd() {
		return geonetworkPwd;
	}

	public void setGeonetworkPwd(String geonetworkPwd) {
		this.geonetworkPwd = geonetworkPwd;
	}

	public static String treatTitleForGN(String layerTitle) {
		int idx = layerTitle.indexOf(" from ");
		String layerTitle2 = layerTitle;
		if (idx>0)
			layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
		else {
		idx = layerTitle.indexOf(" in ");
		if (idx>0)
			layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
		else{
			idx = layerTitle.indexOf("(");
			if (idx>0)
				layerTitle2 = layerTitle.toLowerCase().substring(0, idx).trim();
			}
		}
		layerTitle2 = layerTitle2.replaceAll("(\\(.*\\))", " ");
		
		layerTitle2 = layerTitle2.replace("_", " ").replace("-", " ").replace("(", " ").replace(")", " ");
		String punct = "[!\"#$%&'*+,./:;<=>?@\\^_`{|}~-]";
		
		layerTitle2 = layerTitle2.replaceAll("( |^)+[^A-Za-z]+("+punct+")*[^A-Za-z]*", " ").trim();
		
		 return layerTitle2.replaceAll(punct, " ").replaceAll("( )+", " ");
	}

	public static void main1(String args[]) throws Exception {
		// String title = "temperature (04091217ruc.nc)";
		// String title = "Bathymetry";
		// String title = "FAO aquatic species distribution map of Melanogrammus aeglefinus";
		// String title = "geopotential height from [12/09/2004 19:00] to [12/09/2004 22:00] (04091217_ruc.nc)";
		String title = "geopotential height";
		FeaturesManager fm = new FeaturesManager();
		Metadata meta = fm.getGNInfobyTitle(title);
		System.out.println("is file? " + fm.isThreddsFile(meta));
		System.out.println("opendap: " + fm.getOpenDapLink(meta));
		System.out.println("wcs:" + fm.getWCSLink(meta));
		System.out.println("wms:" + fm.getWMSLink(meta));
		System.out.println("thredds:" + fm.getThreddsLink(meta));
	}
	
	public static void main(String args[]) throws Exception {
		System.out.println(treatTitleForGN("sea/land/lake/ice field composite mask from"));
	}
}
