package org.gcube.dataanalysis.geo.test;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.retrieval.GeoIntersector;

public class TestIntersectionNetCDF {

	static String cfg = "./cfg/";
	
	public static void main1(String args[] ) throws Exception{
		AnalysisLogger.setLogger(cfg+AlgorithmConfiguration.defaultLoggerFile);
		GeoIntersector inters = new GeoIntersector("/gcube/devsec",cfg);
		
		System.out.println(inters.getFeaturesInTime("temperature (04091217ruc.nc)", 0.1, 0.1));
	}
	
	public static void main2(String args[]) throws Exception {
		AnalysisLogger.setLogger(cfg+AlgorithmConfiguration.defaultLoggerFile);
		GeoIntersector inters = new GeoIntersector(null,cfg);
		System.out.println(inters.getFeaturesInTime("Statistical Mean in [07-01-01 01:00] (3D) {World Ocean Atlas 09: Sea Water Temperature - annual: dods://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/temperature_annual_1deg_ENVIRONMENT_OCEANS_.nc}", -70, 0.1, 3000));
	}
	
	public static void main(String args[]) throws Exception {
		AnalysisLogger.setLogger(cfg+AlgorithmConfiguration.defaultLoggerFile);
		GeoIntersector inters = new GeoIntersector(null,cfg);
		
//		List<Tuple<Double>> tuples = (List<Tuple<Double>>)Arrays.asList(
//				new Tuple<Double>(0.1,0.1),
//				new Tuple<Double>(10d,0.1),
//				new Tuple<Double>(100d,0.1),
//				new Tuple<Double>(180d,0.1),
//				new Tuple<Double>(270d,0.1)
//				);
		List<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
		double start = -180d;
		double end = 360d;
		int steps = 30;
		double step = (end-start)/steps;
		double y = 0;
		for (int i=0;i<steps+1;i++){
			double x = (i*step)+start;
			if (i==steps)
				x = end;
			tuples.add(new Tuple<Double>(x,y));
			
		}
		
		 List<LinkedHashMap<String, Double>> time = inters.getFeaturesInTime("Statistical Mean in [07-01-01 01:00] (3D) {World Ocean Atlas 09: Sea Water Temperature - annual: dods://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/temperature_annual_1deg_ENVIRONMENT_OCEANS_.nc}",tuples );
		 int i=0;
		 for (LinkedHashMap<String, Double> timemap : time){
			 for (Double val:timemap.values())
			 {
				 System.out.println(tuples.get(i).getElements().get(0)+"="+MathFunctions.roundDecimal(val,2));
				 break;
			 }
			 i++;
		 }
		 
	}
	
}
