/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.geo.insertion.RasterTable;
import org.gcube.dataanalysis.geo.retrieval.GeoIntersector;

public class TestRasterTable {
    static String cfg = "./cfg/";

    public static void main(String[] args) throws Exception {
        String layertitle = "FAO AQUATIC SPECIES DISTRIBUTION MAP OF MEGALASPIS CORDYLA";
        long t0 = System.currentTimeMillis();
        AnalysisLogger.setLogger((String)(cfg + AlgorithmConfiguration.defaultLoggerFile));
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath(cfg);
        config.setPersistencePath("./");
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://localhost/testdb");
        config.setParam("DatabaseDriver", "org.postgresql.Driver");
        GeoIntersector intersector = new GeoIntersector(null, cfg);
        int t = 0;
        double x1 = -180.0;
        double x2 = 180.0;
        double y1 = -90.0;
        double y2 = 90.0;
        double z = 0.0;
        double xResolution = 0.5;
        double yResolution = 0.5;
        double[][] slice = intersector.takeTimeSlice(layertitle, t, x1, x2, y1, y2, z, xResolution, yResolution);
        RasterTable raster = new RasterTable(x1, x2, y1, y2, z, xResolution, yResolution, slice, config);
        raster.dumpGeoTable();
        System.out.println("ELAPSED TIME: " + (System.currentTimeMillis() - t0));
    }
}

