/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.utils;

import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Formatter;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathFactory;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.utils.EnvDataExplorer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateAxis1DTime;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.PointDatasetImpl;
import ucar.nc2.ft.point.standard.StandardPointCollectionImpl;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class ThreddsDataExplorer {
    public static String timePrefix = "time:";

    public static List<String> getFiles(String catalogURL) throws Exception {
        String xml = HttpRequest.sendGetRequest((String)catalogURL, null);
        XPath xpath = XPathFactory.newInstance().newXPath();
        XPathExpression xPathExpression = xpath.compile("//child::*[local-name()='catalog']/child::*[local-name()='dataset']/child::*[local-name()='dataset']");
        InputSource inputSource = new InputSource(new ByteArrayInputStream(xml.getBytes("UTF-8")));
        NodeList nodes = (NodeList)xPathExpression.evaluate(inputSource, XPathConstants.NODESET);
        ArrayList<String> fileNames = new ArrayList<String>();
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            String name = node.getAttributes().getNamedItem("name").getNodeValue();
            if (name == null) continue;
            fileNames.add(name);
        }
        return fileNames;
    }

    public static LinkedHashMap<String, Double> retrieveDataFromNetCDF(String openDapLink, String layer, double x, double y, double z) {
        try {
            LinkedHashMap<String, Double> map = new LinkedHashMap<String, Double>();
            if (ThreddsDataExplorer.isGridDataset(openDapLink)) {
                AnalysisLogger.getLogger().debug((Object)"Managing Grid File");
                return ThreddsDataExplorer.manageGridDataset(layer, openDapLink, x, y, z);
            }
            AnalysisLogger.getLogger().debug((Object)"Warning: the NETCDF file is of an unknown type");
            return map;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("ERROR: " + e.getMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    public static List<Double> retrieveDataFromNetCDF(String openDapLink, String layer, int time, List<Tuple<Double>> triplets, double xL, double xR, double yL, double yR) {
        try {
            ArrayList<Double> values = new ArrayList<Double>();
            if (ThreddsDataExplorer.isGridDataset(openDapLink)) {
                AnalysisLogger.getLogger().debug((Object)"Managing Grid File");
                return ThreddsDataExplorer.manageGridDataset(layer, openDapLink, time, triplets, xL, xR, yL, yR);
            }
            AnalysisLogger.getLogger().debug((Object)"Warning: the NETCDF file is of an unknown type");
            return values;
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("ERROR: " + e.getMessage()));
            AnalysisLogger.getLogger().debug((Object)e);
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<Double> manageGridDataset(String layer, String filename, int time, List<Tuple<Double>> triplets, double xL, double xR, double yL, double yR) throws Exception {
        ArrayList<Double> values = new ArrayList<Double>();
        GridDataset gds = GridDataset.open((String)filename);
        List gridTypes = gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getFullName()));
            if (!layer.equalsIgnoreCase(gdt.getFullName())) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
            CoordinateAxis xAxis = gdt.getCoordinateSystem().getXHorizAxis();
            CoordinateAxis yAxis = gdt.getCoordinateSystem().getYHorizAxis();
            double resolutionZ = 0.0;
            try {
                resolutionZ = Math.abs((zAxis.getMaxValue() - zAxis.getMinValue()) / (double)zAxis.getShape()[0]);
                AnalysisLogger.getLogger().debug((Object)("Zmin:" + zAxis.getMinValue() + " Zmax:" + zAxis.getMaxValue()));
            }
            catch (Exception e) {
                // empty catch block
            }
            double resolutionX = Math.abs((xAxis.getMaxValue() - xAxis.getMinValue()) / (double)xAxis.getShape()[0]);
            double resolutionY = Math.abs((yAxis.getMaxValue() - yAxis.getMinValue()) / (double)yAxis.getShape()[0]);
            int tsize = triplets.size();
            long t01 = System.currentTimeMillis();
            LatLonRect llr = null;
            AnalysisLogger.getLogger().debug((Object)"Extracting subset...");
            GridDatatype gdtsub = grid.makeSubset(new Range(time, time), null, llr, 1, 1, 1);
            Array data = gdtsub.readVolumeData(time);
            int[] shapeD = data.getShape();
            int zD = 0;
            int xD = 0;
            int yD = 0;
            if (shapeD.length > 2) {
                zD = shapeD[0];
                yD = shapeD[1];
                xD = shapeD[2];
            } else if (shapeD.length > 1) {
                yD = shapeD[0];
                xD = shapeD[1];
            }
            AnalysisLogger.getLogger().debug((Object)("Shape: Z:" + zD + " X:" + xD + " Y:" + yD));
            AnalysisLogger.getLogger().debug((Object)("Layer Information Retrieval ELAPSED Time: " + (System.currentTimeMillis() - t01)));
            int rank = data.getRank();
            AnalysisLogger.getLogger().debug((Object)("Rank of the layer: " + rank));
            ArrayFloat.D3 data3Float = null;
            ArrayDouble.D3 data3Double = null;
            ArrayInt.D3 data3Int = null;
            ArrayLong.D3 data3Long = null;
            ArrayFloat.D2 data2Float = null;
            ArrayDouble.D2 data2Double = null;
            ArrayInt.D2 data2Int = null;
            ArrayLong.D2 data2Long = null;
            if (data.getRank() == 3) {
                if (data instanceof ArrayFloat.D3) {
                    data3Float = (ArrayFloat.D3)data;
                } else if (data instanceof ArrayInt.D3) {
                    data3Int = (ArrayInt.D3)data;
                } else if (data instanceof ArrayDouble.D3) {
                    data3Double = (ArrayDouble.D3)data;
                } else if (data instanceof ArrayDouble.D3) {
                    data3Double = (ArrayDouble.D3)data;
                } else if (data instanceof ArrayLong.D3) {
                    data3Long = (ArrayLong.D3)data;
                } else {
                    if (!(data instanceof ArrayByte.D3)) throw new Exception("Layer data format not supported");
                    data3Double = EnvDataExplorer.arrayByte3DArrayDouble((ArrayByte)data);
                }
            } else if (data instanceof ArrayFloat.D2) {
                data2Float = (ArrayFloat.D2)data;
            } else if (data instanceof ArrayInt.D2) {
                data2Int = (ArrayInt.D2)data;
            } else if (data instanceof ArrayDouble.D2) {
                data2Double = (ArrayDouble.D2)data;
            } else if (data instanceof ArrayLong.D2) {
                data2Long = (ArrayLong.D2)data;
            } else {
                if (!(data instanceof ArrayByte.D2)) throw new Exception("Layer data format not supported");
                data2Double = EnvDataExplorer.arrayByte2DArrayDouble((ArrayByte)data);
            }
            double xmin = xAxis.getMinValue();
            double xmax = xAxis.getMaxValue();
            if (xmax == 360.0 && xmin == 0.0 || xmax == 359.5 && xmin == 0.5) {
                xmax = 180.0;
                xmin = -180.0;
            }
            AnalysisLogger.getLogger().debug((Object)("X dimension: " + xD + " Xmin:" + xmax + " Xmax:" + xmin));
            for (int i = 0; i < tsize; ++i) {
                int zint = 0;
                int xint = 0;
                int yint = 0;
                Tuple<Double> triplet = triplets.get(i);
                double x = (Double)triplet.getElements().get(0);
                double y = (Double)triplet.getElements().get(1);
                if (x == 180.0) {
                    x = -180.0;
                }
                if (y == 90.0) {
                    y = -90.0;
                }
                double z = 0.0;
                if (triplet.getElements().size() > 1) {
                    z = (Double)triplet.getElements().get(2);
                }
                if (resolutionZ > 0.0 && zAxis.getMinValue() <= z && zAxis.getMaxValue() >= z) {
                    zint = Math.abs((int)Math.round((z - zAxis.getMinValue()) / resolutionZ));
                }
                if (xmin <= x && xmax >= x) {
                    xint = (int)Math.round((x - xmin) / resolutionX);
                }
                if (yAxis.getMinValue() <= y && yAxis.getMaxValue() >= y) {
                    yint = (int)Math.round((y - yAxis.getMinValue()) / resolutionY);
                }
                Double val = Double.NaN;
                if (xint > xD - 1) {
                    xint = xD - 1;
                }
                if (yint > yD - 1) {
                    yint = yD - 1;
                }
                if (zint > zD - 1) {
                    zint = zD - 1;
                }
                if (data3Float != null) {
                    val = data3Float.get(zint, yint, xint);
                } else if (data3Int != null) {
                    val = data3Int.get(zint, yint, xint);
                } else if (data3Double != null) {
                    val = data3Double.get(zint, yint, xint);
                } else if (data3Long != null) {
                    val = data3Long.get(zint, yint, xint);
                } else if (data2Float != null) {
                    val = data2Float.get(yint, xint);
                } else if (data2Int != null) {
                    val = data2Int.get(yint, xint);
                } else if (data2Double != null) {
                    val = data2Double.get(yint, xint);
                } else if (data2Long != null) {
                    val = data2Long.get(yint, xint);
                }
                values.add(val);
            }
        }
        return values;
    }

    public static LinkedHashMap<String, Double> manageGridDataset(String layer, String filename, double x, double y, double z) throws Exception {
        LinkedHashMap<String, Double> valuesMap = new LinkedHashMap<String, Double>();
        GridDataset gds = GridDataset.open((String)filename);
        List gridTypes = gds.getGrids();
        for (GridDatatype gdt : gridTypes) {
            AnalysisLogger.getLogger().debug((Object)("Inside File - layer name: " + gdt.getFullName()));
            if (!layer.equalsIgnoreCase(gdt.getFullName())) continue;
            AnalysisLogger.getLogger().debug((Object)("Found layer " + layer + " inside file"));
            GridDatatype grid = gds.findGridDatatype(gdt.getName());
            GridCoordSystem gcs = grid.getCoordinateSystem();
            long timeSteps = 0L;
            Date[] dates = null;
            if (gcs.hasTimeAxis1D()) {
                CoordinateAxis1DTime tAxis1D = gcs.getTimeAxis1D();
                dates = tAxis1D.getTimeDates();
                timeSteps = dates.length;
            } else if (gcs.hasTimeAxis()) {
                CoordinateAxis tAxis = gcs.getTimeAxis();
                timeSteps = tAxis.getSize();
            }
            CoordinateAxis1D zAxis = gdt.getCoordinateSystem().getVerticalAxis();
            double resolutionZ = Math.abs((zAxis.getMaxValue() - zAxis.getMinValue()) / (double)zAxis.getShape()[0]);
            int zint = 0;
            if (resolutionZ > 0.0 && zAxis.getMinValue() <= z && zAxis.getMaxValue() >= z) {
                zint = Math.abs((int)Math.round((z - zAxis.getMinValue()) / resolutionZ));
            }
            AnalysisLogger.getLogger().debug((Object)("Z index to take: " + zint));
            int[] xy = gcs.findXYindexFromLatLon(x, y, null);
            int j = 0;
            while ((long)j < timeSteps) {
                try {
                    Array data = grid.readDataSlice(j, zint, xy[1], xy[0]);
                    Double val = ThreddsDataExplorer.takeFirstDouble(data);
                    if (!val.isNaN()) {
                        String date = "" + j;
                        if (dates != null) {
                            date = dates[j].toString();
                        }
                        valuesMap.put(timePrefix + date, Double.parseDouble("" + val));
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("Error in getting grid values in (" + x + "," + y + "," + z + "= with zint: " + zint + " resolution: " + resolutionZ + " and shape: " + zAxis.getShape()[0]));
                }
                ++j;
            }
            break block2;
        }
        return valuesMap;
    }

    public static Double takeFirstDouble(Array data) {
        long datal = data.getSize();
        Double val = Double.NaN;
        try {
            int k = 0;
            while ((long)k < datal) {
                Double testVal = data.getDouble(k);
                if (!testVal.isNaN()) {
                    val = testVal;
                    break;
                }
                ++k;
            }
        }
        catch (Exception ee) {
            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> WARNING: Error in getting value: " + ee.getLocalizedMessage()));
        }
        return val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LinkedHashMap<String, String> managePointsDataset(String layer, String filename, double x, double y) throws Exception {
        LinkedHashMap<String, String> valuesMap = new LinkedHashMap<String, String>();
        float tolerance = 0.25f;
        Formatter errlog = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
        PointDatasetImpl ds = (PointDatasetImpl)fdataset;
        List lfc = ds.getPointFeatureCollectionList();
        Iterator i$ = lfc.iterator();
        if (i$.hasNext()) {
            LatLonRect rect;
            PointFeatureCollection coll;
            FeatureCollection fc = (FeatureCollection)i$.next();
            StandardPointCollectionImpl spf = (StandardPointCollectionImpl)fc;
            PointFeatureIterator iter = null;
            while (y - (double)tolerance > -90.0 && x - (double)tolerance > -180.0 && y + (double)tolerance < 90.0 && x + (double)tolerance < 180.0 && (iter = (coll = spf.subset(rect = new LatLonRect((LatLonPoint)new LatLonPointImpl(y - (double)tolerance, x - (double)tolerance), (LatLonPoint)new LatLonPointImpl(y + (double)tolerance, x + (double)tolerance)), null)).getPointFeatureIterator(100000)).getCount() == 0) {
                iter.finish();
                AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> tolerance = " + (tolerance += 0.25f)));
            }
            if (iter != null) {
                try {
                    while (iter.hasNext()) {
                        PointFeature pf = iter.next();
                        AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> EarthLoc: " + pf.getLocation()));
                        AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> EarthTime: " + pf.getObservationTime()));
                        StructureData sd = pf.getData();
                        List mems = sd.getMembers();
                        for (StructureMembers.Member m : mems) {
                            String unit = m.getUnitsString();
                            if (unit == null || unit.length() <= 0) continue;
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> description: " + m.getDescription()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> data param: " + m.getDataParam()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> name: " + m.getName()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> unit: " + m.getUnitsString()));
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> type: " + m.getDataType()));
                            Array arr = sd.getArray(m.getName());
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> is Time: " + m.getDataType()));
                            Double val = ThreddsDataExplorer.takeFirstDouble(arr);
                            AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> extracted value: " + val));
                        }
                        AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> EarthTime: ");
                    }
                }
                finally {
                    iter.finish();
                }
            }
        }
        return valuesMap;
    }

    public static boolean isGridDataset(String filename) {
        try {
            AnalysisLogger.getLogger().debug((Object)("Analyzing file " + filename));
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.GRID, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT GRID");
                return false;
            }
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    public static boolean isPointDataset(String filename) {
        try {
            Formatter errlog = new Formatter();
            FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)filename, null, (Formatter)errlog);
            if (fdataset == null) {
                AnalysisLogger.getLogger().debug((Object)"ThreddsDataExplorer-> NOT POINT");
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isDataset(String filename) throws Exception {
        boolean isdataset = false;
        try {
            Formatter errlog = new Formatter();
            FeatureType[] fts = FeatureType.values();
            for (int i = 0; i < fts.length; ++i) {
                FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)fts[i], (String)filename, null, (Formatter)errlog);
                if (fdataset == null) continue;
                AnalysisLogger.getLogger().debug((Object)("ThreddsDataExplorer-> " + fts[i] + " OK!"));
                isdataset = true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isdataset;
    }

    public static double adjX(double x) {
        return x;
    }

    public static double adjY(double y) {
        return y;
    }

    public static double getMinX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return ThreddsDataExplorer.adjX(xAxis.getMinValue());
    }

    public static double getMaxX(GridCoordSystem gcs) {
        CoordinateAxis xAxis = gcs.getXHorizAxis();
        return ThreddsDataExplorer.adjX(xAxis.getMaxValue());
    }

    public static double getMinY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return ThreddsDataExplorer.adjY(yAxis.getMinValue());
    }

    public static double getMaxY(GridCoordSystem gcs) {
        CoordinateAxis yAxis = gcs.getYHorizAxis();
        return ThreddsDataExplorer.adjY(yAxis.getMaxValue());
    }
}

