/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.connectors.asc;

import java.util.Arrays;

public class AscRaster {
    protected double[][] data;
    protected double xll;
    protected double yll;
    protected double cellsize;
    protected double dx = -1.0;
    protected double dy = -1.0;
    protected int cols;
    protected int rows;
    public static final String DEFAULT_NODATA = "-9999";
    protected String NDATA = "-9999";

    public void print() {
        System.out.println("Rows: " + this.rows + " cols: " + this.cols + " cellsize " + this.cellsize + " dx " + this.dx + " dy " + this.dy);
        double[][] dArray = this.data;
        int n = this.data.length;
        int n2 = 0;
        while (n2 < n) {
            double[] row;
            double[] dArray2 = row = dArray[n2];
            int n3 = row.length;
            int n4 = 0;
            while (n4 < n3) {
                double val = dArray2[n4];
                System.out.print(String.valueOf(val) + " ");
                ++n4;
            }
            System.out.println("");
            ++n2;
        }
    }

    public AscRaster() {
    }

    public AscRaster(double cellsize, double dx, double dy, double xll, double yll) {
        this();
        this.setCellsize(cellsize);
        this.setXll(xll);
        this.setYll(yll);
        this.setdx(dx);
        this.setdy(dy);
    }

    public AscRaster(double[][] data, double cellsize, double dx, double dy, double xll, double yll) {
        this(cellsize, dx, dy, xll, yll);
        this.setData(data);
    }

    public AscRaster(int[][] data, double cellsize, double dx, double dy, double xll, double yll) {
        this(cellsize, dx, dy, xll, yll);
        this.setData(data);
    }

    public static AscRaster getTempRaster(double[][] data, double xll, double yll, double size) {
        return AscRaster.getTempRaster(data, xll, yll, size, DEFAULT_NODATA);
    }

    public static AscRaster getTempRaster(double[][] data, double xll, double yll, double size, String ndata) {
        AscRaster a = new AscRaster();
        a.data = data;
        a.xll = xll;
        a.yll = yll;
        a.cellsize = size;
        a.NDATA = ndata;
        a.rows = data.length;
        a.cols = data[0].length;
        return a;
    }

    public void init(AscRaster other) {
        this.xll = other.xll;
        this.yll = other.yll;
        this.cellsize = other.cellsize;
        this.NDATA = other.NDATA;
        this.setSize(other.getRows(), other.getCols());
    }

    public void initData() {
        this.initData(Double.NaN);
    }

    public void initData(double value) {
        this.data = new double[this.rows][];
        int i = 0;
        while (i < this.rows) {
            this.data[i] = new double[this.cols];
            Arrays.fill(this.data[i], value);
            ++i;
        }
    }

    public double[][] getData() {
        return this.data;
    }

    public void setValue(int row, int column, double value) {
        if (row < this.rows && column < this.cols) {
            this.data[row][column] = value;
        }
    }

    public double getValue(int row, int column) {
        if (row < this.rows && column < this.cols) {
            return this.data[row][column];
        }
        return Double.NaN;
    }

    public void setData(double[][] data) {
        this.rows = data.length;
        this.cols = data[0].length;
        this.initData();
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.data[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public void setData(int[][] data) {
        this.rows = data.length;
        this.cols = data[0].length;
        this.initData();
        int i = 0;
        while (i < this.rows) {
            int j = 0;
            while (j < this.cols) {
                this.data[i][j] = data[i][j];
                ++j;
            }
            ++i;
        }
    }

    public double getXll() {
        return this.xll;
    }

    public void setXll(double xll) {
        this.xll = xll;
    }

    public double getYll() {
        return this.yll;
    }

    public void setYll(double yll) {
        this.yll = yll;
    }

    public double getCellsize() {
        return this.cellsize;
    }

    public void setCellsize(double cellsize) {
        this.cellsize = cellsize;
    }

    public double getdx() {
        return this.dx;
    }

    public void setdx(double dx) {
        this.dx = dx;
    }

    public double getdy() {
        return this.dy;
    }

    public void setdy(double dy) {
        this.dy = dy;
    }

    public int getCols() {
        return this.cols;
    }

    public int getRows() {
        return this.rows;
    }

    public void setSize(int nrows, int columns) {
        this.rows = nrows;
        this.cols = columns;
        this.initData();
    }

    public String getNDATA() {
        return this.NDATA;
    }

    public void setNDATA(String nDATA) {
        this.NDATA = nDATA;
    }
}

