/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.matrixmodel;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.asc.ASC;
import org.gcube.dataanalysis.geo.connectors.geotiff.GeoTiff;
import org.gcube.dataanalysis.geo.connectors.netcdf.NetCDF;
import org.gcube.dataanalysis.geo.connectors.table.Table;
import org.gcube.dataanalysis.geo.connectors.table.TableMatrixRepresentation;
import org.gcube.dataanalysis.geo.connectors.wcs.WCS;
import org.gcube.dataanalysis.geo.connectors.wfs.WFS;
import org.gcube.dataanalysis.geo.infrastructure.GeoNetworkInspector;
import org.gcube.dataanalysis.geo.interfaces.GISDataConnector;
import org.gcube.dataanalysis.geo.meta.GenericLayerMetadata;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.identification.Identification;

public class MatrixExtractor {
    private GeoNetworkInspector gnInspector = new GeoNetworkInspector();
    private AlgorithmConfiguration configuration;
    public static int maxSignalLength = 100000;
    public static int maxzLength = 100000;
    boolean log = true;
    protected double currentResolution = 0.5;
    public List<Double> currentTimeValues;
    public List<Tuple<Double>> currentTuples;
    public GISDataConnector currentconnector;
    public String layerName;
    public String layerURL;
    public GISDataConnector connector;
    public double zmin;
    public double zmax;

    public MatrixExtractor(AlgorithmConfiguration configuration) {
        this.gnInspector.setScope(configuration.getGcubeScope());
        this.configuration = configuration;
    }

    public GeoNetworkInspector getFeaturer() {
        return this.gnInspector;
    }

    public boolean isTable() {
        return this.configuration.getParam(TableMatrixRepresentation.tableNameParameter) != null;
    }

    protected List<Double> getRawValuesInTimeInstantAndBoundingBox(String layerTitle, int time, List<Tuple<Double>> coordinates3d, double xL, double xR, double yL, double yR, double resolution) throws Exception {
        return this.getRawValuesInTimeInstantAndBoundingBox(layerTitle, time, coordinates3d, xL, xR, yL, yR, resolution, false);
    }

    public GISDataConnector getConnector(String layerTitle, double resolution) throws Exception {
        Metadata meta = null;
        GISDataConnector connector = null;
        if (this.currentconnector != null) {
            connector = this.currentconnector;
        } else if (this.isTable()) {
            AnalysisLogger.getLogger().debug((Object)("Extracting grid from table " + this.configuration.getParam(TableMatrixRepresentation.tableNameParameter)));
            this.currentconnector = connector = new Table(this.configuration, resolution);
        } else {
            meta = this.gnInspector.getGNInfobyUUIDorName(layerTitle);
            if (meta == null) {
                String[] urls = new String[]{layerTitle};
                String[] protocols = new String[]{"HTTP"};
                meta = new GenericLayerMetadata().createBasicMeta(urls, protocols);
            }
            this.layerName = this.gnInspector.getLayerName(meta);
            if (this.layerName == null) {
                this.layerName = layerTitle;
            }
            this.layerURL = "";
            if (this.gnInspector.isNetCDFFile(meta)) {
                Identification id = (Identification)meta.getIdentificationInfo().iterator().next();
                String title = id.getCitation().getTitle().toString();
                AnalysisLogger.getLogger().debug((Object)("found a netCDF file with title " + title + " and layer name " + this.layerName));
                this.layerURL = this.gnInspector.getOpenDapLink(meta);
                connector = new NetCDF(this.layerURL, this.layerName);
            } else if (this.gnInspector.isAscFile(meta)) {
                AnalysisLogger.getLogger().debug((Object)"managing ASC File");
                this.layerURL = this.gnInspector.getHttpLink(meta);
                connector = new ASC();
            } else if (this.gnInspector.isWFS(meta)) {
                AnalysisLogger.getLogger().debug((Object)("found a Geo Layer with reference " + this.layerURL + " and layer name " + this.layerName));
                this.layerURL = this.gnInspector.getWFSLink(meta);
                connector = new WFS();
            } else if (this.gnInspector.isWCS(meta)) {
                AnalysisLogger.getLogger().debug((Object)("found a WCS Layer with reference " + this.layerURL + " and layer name " + this.layerName));
                this.layerURL = this.gnInspector.getWCSLink(meta);
                connector = new WCS(this.configuration, this.layerURL);
            } else if (this.gnInspector.isGeoTiff(meta)) {
                this.layerURL = this.gnInspector.getGeoTiffLink(meta);
                AnalysisLogger.getLogger().debug((Object)("found a GeoTiff with reference " + this.layerURL + " and layer name " + this.layerName));
                connector = new GeoTiff(this.configuration, this.layerURL);
            } else {
                this.layerURL = layerTitle;
                AnalysisLogger.getLogger().debug((Object)("guessing a GeoTiff with reference " + this.layerURL + " and layer name " + this.layerName));
                connector = new GeoTiff(this.configuration, this.layerURL);
            }
        }
        this.currentconnector = connector;
        return this.currentconnector;
    }

    public List<Double> getRawValuesInTimeInstantAndBoundingBox(String layerTitle, int time, List<Tuple<Double>> coordinates3d, double xL, double xR, double yL, double yR, double resolution, boolean saveLayer) throws Exception {
        this.connector = this.getConnector(layerTitle, resolution);
        if (this.connector != null) {
            return this.connector.getFeaturesInTimeInstantAndArea(this.layerURL, this.layerName, time, coordinates3d, xL, xR, yL, yR);
        }
        throw new Exception("ERROR: Connector not found for layer " + layerTitle + " - Cannot Rasterize!");
    }

    public GISDataConnector getCurrentConnector() {
        return this.connector;
    }

    public double correctZ(double zValue, String layerURL, double resolution) throws Exception {
        GISDataConnector connector = this.getConnector(layerURL, resolution);
        this.zmin = connector.getMinZ(layerURL, this.layerName);
        this.zmax = connector.getMaxZ(layerURL, this.layerName);
        if (zValue < this.zmin) {
            zValue = this.zmin;
        } else if (zValue > this.zmax) {
            zValue = this.zmax;
        }
        return zValue;
    }

    public double[][] extractXYGridWithFixedTZ(String layerTitle, int timeInstant, double x1, double x2, double y1, double y2, double z, double xResolution, double yResolution, boolean cachelayer) throws Exception {
        this.currentResolution = (xResolution + yResolution) / 2.0;
        boolean faolayer = false;
        if (layerTitle == null) {
            layerTitle = "";
        }
        if (layerTitle.toLowerCase().contains("MatrixExtractor->FAO aquatic species distribution map")) {
            AnalysisLogger.getLogger().debug((Object)"MatrixExtractor->FAO DISTRIBUTION LAYER ... TO APPY PATCH!");
            faolayer = true;
        }
        if (x2 < x1 || y2 < y1) {
            AnalysisLogger.getLogger().debug((Object)"MatrixExtractor->ERROR: BAD BOUNDING BOX!!!");
            return new double[0][0];
        }
        int ysteps = (int)((y2 - y1) / yResolution);
        int xsteps = (int)((x2 - x1) / xResolution);
        double[][] slice = new double[ysteps + 1][xsteps + 1];
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        if (this.log) {
            AnalysisLogger.getLogger().debug((Object)("MatrixExtractor->Building the points grid according to YRes:" + yResolution + " and XRes:" + xResolution));
            AnalysisLogger.getLogger().debug((Object)("MatrixExtractor->Points to reassign:" + ysteps * xsteps));
        }
        int i = 0;
        while (i < ysteps + 1) {
            double y = (double)i * yResolution + y1;
            if (i == ysteps) {
                y = y2;
            }
            int j = 0;
            while (j < xsteps + 1) {
                double x = (double)j * xResolution + x1;
                if (j == xsteps) {
                    x = x2;
                }
                tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{x, y, z}));
                ++j;
            }
            ++i;
        }
        if (this.log) {
            AnalysisLogger.getLogger().debug((Object)("Taking " + (ysteps + 1) + " values per " + (xsteps + 1) + "=" + (ysteps + 1 * xsteps + 1) + "..."));
        }
        if (x2 == x1) {
            x2 += xResolution / 2.0;
            x1 -= xResolution / 2.0;
        }
        if (y2 == y1) {
            y2 += yResolution / 2.0;
            y1 -= yResolution / 2.0;
        }
        if (this.log) {
            AnalysisLogger.getLogger().debug((Object)("Bounding box: (" + x1 + "," + x2 + ";" + y1 + "," + y2 + ")"));
        }
        this.currentTimeValues = this.getRawValuesInTimeInstantAndBoundingBox(layerTitle, timeInstant, tuples, x1, x2, y1, y2, this.currentResolution, cachelayer);
        this.currentTuples = tuples;
        if (this.log) {
            AnalysisLogger.getLogger().debug((Object)("Taken " + this.currentTimeValues.size() + " values"));
        }
        int k = 0;
        int g = 0;
        int ntriplets = this.currentTimeValues.size();
        int t = 0;
        while (t < ntriplets) {
            Double value = this.currentTimeValues.get(t);
            if (faolayer && value > 1.0) {
                AnalysisLogger.getLogger().debug((Object)"APPLYING FAO PATCH!");
                slice[k][g] = 0.5;
            } else {
                slice[k][g] = value;
            }
            if (g == xsteps) {
                g = 0;
                ++k;
            } else {
                ++g;
            }
            ++t;
        }
        if (this.log) {
            AnalysisLogger.getLogger().debug((Object)("Features map: rows " + slice.length + ", cols " + slice[0].length));
        }
        return slice;
    }
}

