/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import it.cnr.aquamaps.CSquare;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.geo.meta.PolyMapMetadata;
import org.gcube.spatial.data.gis.model.report.PublishResponse;
import org.hibernate.SessionFactory;
import scala.collection.Iterator;

public abstract class MapsCreator
extends StandardLocalExternalAlgorithm {
    static String databaseParameterName = "TimeSeriesDataStore";
    static String dbuserParameterName = "user";
    static String dbpasswordParameterName = "password";
    static String dburlParameterName = "STOREURL";
    static String inputTableParameter = "InputTable";
    static String outputTableParameter = "OutputTable";
    static String xParameter = "xDimension";
    static String yParameter = "yDimension";
    static String csquareParameter = "csquaresDimension";
    static String probabilityParameter = "Probability";
    static String infoParameter = "Info";
    static String resolutionParameter = "Resolution";
    static String layerNameParameter = "MapName";
    static int maxNPoints = 259000;
    SessionFactory gisdbconnection = null;
    SessionFactory smdbconnection = null;
    private static String createProbTable = "create table  %1$s (geomid serial, x real, y real, probability real);";
    private static String columnsProbNames = " geomid, x , y, probability, the_geom";
    private static String createInfoTable = "create table  %1$s (geomid serial, x real, y real, info character varying);";
    private static String columnsInfoNames = " geomid, x , y, info, the_geom";
    private static String addGeometryColumn = "Select AddGeometryColumn('%1$s','the_geom',4326,'POLYGON',2);";
    static String makeSquare = "ST_GeomFromText('POLYGON((%1$s ,%2$s, %3$s, %4$s, %1$s))',4326)";
    String datastore = "";
    String defaultStyle = "";
    String workspace = "";
    String username = "";
    String purpose = "";
    String credits = "";
    String keyword = "";

    public String getDescription() {
        return "A transducer algorithm to produce a GIS map from a probability distribution or from a set of points. A maximum of " + maxNPoints + " is allowed";
    }

    public abstract void init() throws Exception;

    protected void process() throws Exception {
        try {
            this.status = 0.0f;
            this.log("Beginning process");
            this.log("Set scope from outside:" + this.config.getGcubeScope());
            String scope = this.config.getGcubeScope();
            if (scope == null) {
                scope = ScopeProvider.instance.get();
            }
            this.log("Using scope:" + scope);
            String databaseJdbc = this.getInputParameter(dburlParameterName);
            String databaseUser = this.getInputParameter(dbuserParameterName);
            String databasePwd = this.getInputParameter(dbpasswordParameterName);
            this.log("GIS Database Parameters to use: " + databaseJdbc + " , " + databaseUser);
            String res$ = this.config.getParam(resolutionParameter);
            double resolution = res$ != null ? Double.parseDouble(res$) : 0.0;
            this.log("Connecting to gisDB...");
            AlgorithmConfiguration gisconfig = new AlgorithmConfiguration();
            gisconfig.setParam("DatabaseDriver", "org.postgresql.Driver");
            gisconfig.setParam("DatabaseURL", databaseJdbc);
            gisconfig.setParam("DatabaseUserName", databaseUser);
            gisconfig.setParam("DatabasePassword", databasePwd);
            gisconfig.setConfigPath(this.config.getConfigPath());
            this.gisdbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)gisconfig);
            this.log("Initialized gisDBConnection!");
            this.status = 10.0f;
            this.smdbconnection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
            this.log("Initialized SMDBConnection!");
            String infoPar = this.config.getParam(probabilityParameter);
            if (infoPar == null) {
                infoPar = this.config.getParam(infoParameter);
            }
            List<Object[]> points = null;
            this.log("Retrieving points..");
            if (this.config.getParam(xParameter) != null && this.config.getParam(yParameter) != null) {
                this.log("..from coordinates");
                points = DatabaseFactory.executeSQLQuery((String)("select " + this.config.getParam(xParameter) + "," + this.config.getParam(yParameter) + "," + infoPar + " from " + this.config.getParam(inputTableParameter) + " limit " + maxNPoints), (SessionFactory)this.smdbconnection);
            } else if (this.config.getParam(csquareParameter) != null) {
                this.log("..from csquares");
                String queryCsquare = "select " + this.config.getParam(csquareParameter) + "," + infoPar + " from " + this.config.getParam(inputTableParameter) + " limit " + maxNPoints;
                List csquares = DatabaseFactory.executeSQLQuery((String)queryCsquare, (SessionFactory)this.smdbconnection);
                points = new ArrayList();
                for (Object csquare : csquares) {
                    Object[] csquareandprob = (Object[])csquare;
                    CSquare c = CSquare.apply((String)("" + csquareandprob[0]));
                    if (resolution == 0.0) {
                        resolution = c.size();
                    }
                    Iterator iterator = c.center().valuesIterator();
                    String x = "" + iterator.next();
                    String y = "" + iterator.next();
                    String prob = "" + csquareandprob[1];
                    Object[] pair = new Object[]{x, y, prob};
                    points.add(pair);
                }
                this.log("Points built from csquares!");
            }
            this.log("Creating GIS table");
            String gisTableName = "stat" + UUID.randomUUID().toString().replace("-", "");
            this.status = 30.0f;
            String createTable$ = String.format(createProbTable, gisTableName);
            String columnNames$ = columnsProbNames;
            if (this.config.getParam(probabilityParameter) == null) {
                createTable$ = String.format(createInfoTable, gisTableName);
                columnNames$ = columnsInfoNames;
            }
            this.log(createTable$);
            try {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)gisTableName), (SessionFactory)this.gisdbconnection);
            }
            catch (Exception e) {
                this.log("Impossible to drop table:" + e.getLocalizedMessage());
            }
            DatabaseFactory.executeSQLUpdate((String)createTable$, (SessionFactory)this.gisdbconnection);
            DatabaseFactory.executeSQLQuery((String)String.format(addGeometryColumn, gisTableName), (SessionFactory)this.gisdbconnection);
            this.log("Fulfilling elements");
            this.log("Resolution:" + resolution);
            ArrayList<String[]> values = new ArrayList<String[]>();
            int i = 0;
            for (Object e : points) {
                Object[] elements = (Object[])e;
                double x = Double.parseDouble("" + elements[0]);
                double y = Double.parseDouble("" + elements[1]);
                String probS = "" + elements[2];
                double x1 = x - resolution;
                double x2 = x + resolution;
                double y1 = y - resolution;
                double y2 = y + resolution;
                String square = String.format(makeSquare, "" + x1 + " " + y1, x1 + " " + y2, x2 + " " + y2, x2 + " " + y1);
                String[] selements = new String[]{"" + i, "" + x, "" + y, probS, square};
                values.add(selements);
                ++i;
            }
            this.status = 50.0f;
            this.log("Writing chunks");
            MapsCreator.insertGeoChunksIntoTable(gisTableName, columnNames$, values, 5000, this.gisdbconnection);
            this.log("Publishing Table");
            String usernameP = this.config.getParam("ServiceUserName");
            if (usernameP != null) {
                this.username = usernameP;
            }
            String string = this.config.getParam(layerNameParameter);
            PublishResponse response = PolyMapMetadata.publishTable(scope, gisTableName, resolution, this.username, string, this.defaultStyle, this.workspace, this.datastore, this.purpose, this.credits, this.keyword);
            this.status = 80.0f;
            if (response == null) {
                this.log("Error in generating map - dropping gis table");
                try {
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)gisTableName), (SessionFactory)this.gisdbconnection);
                    this.log("gis table dropped");
                }
                catch (Exception e) {
                    this.log("Impossible to drop table:" + e.getLocalizedMessage());
                }
                throw new Exception("Impossible to publish on GeoNetwork or GeoServer: " + gisTableName);
            }
            this.addOutputString("GIS map title", string);
            this.addOutputString("GIS map UUID", "" + response.getPublishedMetadata().getFileIdentifier());
            this.addOutputString("Associated Geospatial Table", gisTableName);
            this.addOutputString("Generated by ", this.username);
            this.addOutputString("Resolution", "" + resolution);
            this.addOutputString("Style", "" + this.defaultStyle);
            this.addOutputString("Keyword", "" + this.keyword);
            this.log("Output:" + this.outputParameters);
            this.log("All Done!");
            this.status = 100.0f;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        finally {
            if (this.smdbconnection != null) {
                DatabaseUtils.closeDBConnection((SessionFactory)this.smdbconnection);
            }
            if (this.gisdbconnection != null) {
                DatabaseUtils.closeDBConnection((SessionFactory)this.gisdbconnection);
            }
        }
    }

    public static void insertGeoChunksIntoTable(String table, String columnsNames, List<String[]> values, int chunkSize, SessionFactory dbconnection) throws Exception {
        int valuesize = values.size();
        StringBuffer sb = new StringBuffer();
        int stopIndex = 0;
        for (int i = 0; i < valuesize; ++i) {
            String[] row = values.get(i);
            sb.append("(");
            for (int j = 0; j < row.length - 1; ++j) {
                String preprow = row[j].replaceAll("^'", "").replaceAll("'$", "");
                preprow = preprow.replace("'", "`");
                sb.append("'" + preprow + "'");
                sb.append(",");
            }
            sb.append(row[row.length - 1]);
            sb.append(")");
            if (stopIndex > 0 && stopIndex % chunkSize == 0) {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.insertFromBuffer((String)table, (String)columnsNames, (StringBuffer)sb), (SessionFactory)dbconnection);
                stopIndex = chunkSize;
                sb = new StringBuffer();
                continue;
            }
            if (i >= valuesize - 1) continue;
            sb.append(",");
        }
        if (stopIndex < valuesize - 1 && sb.length() > 0) {
            try {
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.insertFromBuffer((String)table, (String)columnsNames, (StringBuffer)sb), (SessionFactory)dbconnection);
            }
            catch (Exception e) {
                System.out.println("Query:" + sb);
                throw e;
            }
        }
    }

    public void shutdown() {
        this.log("shutdown invoked!");
    }

    protected abstract void setInputParameters();
}

