/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test;

import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.signals.SignalProcessing;
import org.gcube.dataanalysis.geo.matrixmodel.ZExtractor;

public class TestWaterColumnGeoTiff {
    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        String layertitle = "WorldClimBioGeoTiffTest2";
        AnalysisLogger.setLogger((String)(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile));
        config.setGcubeScope("/d4science.research-infrastructures.eu/gCubeApps/BiodiversityLab");
        ZExtractor extractor = new ZExtractor(config);
        long t0 = System.currentTimeMillis();
        double[] watercolumn = extractor.extractZ(layertitle, 18.620429, 20.836419, 0, 0.0);
        System.out.println("ELAPSED TIME: " + (System.currentTimeMillis() - t0));
        System.out.println("Signal: " + watercolumn.length);
        System.out.println("Signal first element: " + watercolumn[0]);
        SignalProcessing.displaySignalWithGenericTime((double[])watercolumn, (float)0.0f, (float)1.0f, (String)"signal");
    }
}

