/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.vti;

import java.awt.geom.Point2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.vti.GridCWP2Coordinates;
import org.gcube.dataanalysis.geo.vti.vesselsprocessing.Bathymetry;
import org.gcube.dataanalysis.geo.vti.vesselsprocessing.FishingHoursCalculator;
import org.gcube.dataanalysis.geo.vti.vesselsprocessing.VTIClassificator;
import org.hibernate.SessionFactory;

public class EstimateFishingActivity
extends GridCWP2Coordinates {
    static String VesselsIDColumn = "VesselsIDColumn";
    static String VesselsSpeedsColumn = "VesselsSpeedsColumn";
    static String VesselsTimestampsColumn = "VesselsTimestampsColumn";
    static String VesselsLatitudesColumn = "VesselsLatitudesColumn";
    static String VesselsLongitudesColumn = "VesselsLongitudesColumn";

    @Override
    protected void setInputParameters() {
        ArrayList<TableTemplates> templates = new ArrayList<TableTemplates>();
        templates.add(TableTemplates.GENERIC);
        InputTable tinput = new InputTable(templates, inputTableParameter, "The table to which the algorithm will add information");
        this.inputs.add(tinput);
        ColumnType Dimension1 = new ColumnType(inputTableParameter, VesselsIDColumn, "A column containing (anonymised) unique vessels identifiers", "vessel_id", false);
        ColumnType Dimension2 = new ColumnType(inputTableParameter, VesselsSpeedsColumn, "The column containing vessels speeds", "speed", false);
        ColumnType Dimension3 = new ColumnType(inputTableParameter, VesselsTimestampsColumn, "The column containing the time stamp of the vessels transmitted information (preferred in the following format: MM/dd/yyyy HH:mm:ss a)", "datetime", false);
        ColumnType Dimension4 = new ColumnType(inputTableParameter, VesselsLatitudesColumn, "The column containing vessels latitudes", "y", false);
        ColumnType Dimension5 = new ColumnType(inputTableParameter, VesselsLongitudesColumn, "The column containing vessels longitudes", "x", false);
        this.inputs.add(Dimension1);
        this.inputs.add(Dimension2);
        this.inputs.add(Dimension3);
        this.inputs.add(Dimension4);
        this.inputs.add(Dimension5);
        IOHelper.addStringInput((List)this.inputs, (String)outputTableParameter, (String)"The name of the output table", (String)"fish_");
        DatabaseType.addDefaultDBPars((List)this.inputs);
    }

    @Override
    public String getDescription() {
        return "An algorithm that estimates activity hours (fishing or other) from vessels trajectories, adds bathymetry information to the table and classifies (point-by-point) fishing activity of the involved vessels according to two algorithms: one based on speed (activity_class_speed output column) and the other based on speed and bathymetry (activity_class_speed_bath output column). The algorithm produces new columns containing this information. This algorithm is based on the paper 'Deriving Fishing Monthly Effort and Caught Species' (Coro et al. 2013, in proc. of OCEANS - Bergen, 2013 MTS/IEEE). Example of input table (NAFO anonymised data): http://goo.gl/3auJkM";
    }

    @Override
    protected void process() throws Exception {
        this.status = 0.0f;
        AnalysisLogger.setLogger((String)(String.valueOf(this.config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        long t0 = System.currentTimeMillis();
        String table = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)inputTableParameter);
        this.outTable = ("fish_" + UUID.randomUUID()).replace("-", "");
        this.outTableLabel = IOHelper.getInputParameter((AlgorithmConfiguration)this.config, (String)outputTableParameter);
        AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: received parameters: " + this.config.getGeneralProperties()));
        AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: input table: " + table + " outputTable: " + this.outTable + " outLabel: " + this.outTableLabel));
        this.status = 10.0f;
        try {
            try {
                this.addInformationColumsToTable(table);
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: finished in " + (System.currentTimeMillis() - t0) + " ms"));
            }
            catch (Throwable e) {
                throw new Exception(e.getMessage());
            }
        }
        finally {
            this.status = 100.0f;
        }
    }

    @Override
    public void addInformationColumsToTable(String table) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: initializing connection");
        long t0 = System.currentTimeMillis();
        try {
            try {
                this.connection = DatabaseUtils.initDBSession((AlgorithmConfiguration)this.config);
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: database: " + this.config.getDatabaseURL()));
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: dropping table " + this.outTable + " if exists"));
                try {
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: table " + this.outTable + " does not exist yet"));
                }
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: creating the new table " + this.outTable));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.createBlankTableFromAnotherStatement((String)table, (String)this.outTable), (SessionFactory)this.connection);
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: adding new columns to " + this.outTable));
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"activity_hours", (String)"real"), (SessionFactory)this.connection);
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"bathymetry", (String)"real"), (SessionFactory)this.connection);
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"activity_class_speed", (String)"character varying"), (SessionFactory)this.connection);
                DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.addColumnStatement((String)this.outTable, (String)"activity_class_speed_bath", (String)"character varying"), (SessionFactory)this.connection);
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: getting columns from " + this.outTable));
                List names = DatabaseFactory.executeSQLQuery((String)DatabaseUtils.getColumnsNamesStatement((String)this.outTable), (SessionFactory)this.connection);
                StringBuffer colnames = new StringBuffer();
                int nnames = names.size();
                int i = 0;
                while (i < nnames) {
                    colnames.append(names.get(i));
                    if (i < nnames - 1) {
                        colnames.append(",");
                    }
                    ++i;
                }
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: columns are: " + colnames.toString()));
                AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: taking chunks ... ");
                List vessels = DatabaseFactory.executeSQLQuery((String)("select distinct " + this.config.getParam(VesselsIDColumn) + " from " + table), (SessionFactory)this.connection);
                int nvessels = vessels.size();
                int k = 0;
                if (this.config.getParam(VesselsIDColumn) == null || this.config.getParam(VesselsSpeedsColumn) == null || this.config.getParam(VesselsTimestampsColumn) == null || this.config.getParam(VesselsLongitudesColumn) == null || this.config.getParam(VesselsLatitudesColumn) == null) {
                    throw new Exception("Error with input parameters, please check that all the required inputs have been provided.");
                }
                for (Object vesselrow : vessels) {
                    String vesselID = "" + vesselrow;
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: Analysing vessel " + vesselID + " " + (k + 1) + " of " + nvessels));
                    String selectTrajectory = "select *, \"" + this.config.getParam(VesselsIDColumn) + "\"" + " as fhv01," + "\"" + this.config.getParam(VesselsSpeedsColumn) + "\"" + " as fhv02," + "\"" + this.config.getParam(VesselsTimestampsColumn) + "\"" + " as fhv03," + "\"" + this.config.getParam(VesselsLongitudesColumn) + "\"" + " as fhv04," + "\"" + this.config.getParam(VesselsLatitudesColumn) + "\"" + " as fhv05 " + " from " + table + " where " + "CAST(\"" + this.config.getParam(VesselsIDColumn) + "\" as integer)" + " =" + vesselID + " order by CAST(" + "\"" + this.config.getParam(VesselsTimestampsColumn) + "\"" + " as timestamp)";
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: EstimateFishingActivity: Select trajectory: " + selectTrajectory));
                    List vesselTrajectory = DatabaseFactory.executeSQLQuery((String)selectTrajectory, (SessionFactory)this.connection);
                    int nvesselpoints = vesselTrajectory.size();
                    String[] vesselIDs = new String[nvesselpoints];
                    Date[] timeStamps = new Date[nvesselpoints];
                    Point2D.Double[] coordinates = new Point2D.Double[nvesselpoints];
                    Tuple[] bathspeedpairs = new Tuple[nvesselpoints];
                    String[] speeds = new String[nvesselpoints];
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: EstimateFishingActivity: building information: " + selectTrajectory));
                    int i2 = 0;
                    for (Object trajectorrow : vesselTrajectory) {
                        Object[] trajectvector = (Object[])trajectorrow;
                        int lenvector = trajectvector.length;
                        vesselIDs[i2] = "" + trajectvector[lenvector - 5];
                        speeds[i2] = "" + trajectvector[lenvector - 4];
                        timeStamps[i2] = DateGuesser.convertDate((String)("" + trajectvector[lenvector - 3])).getTime();
                        if (timeStamps[i2] == null) {
                            throw new Exception("Cannot parse time " + trajectvector[lenvector - 3] + " for vessel " + vesselIDs[i2] + ". please try specifying time as MM/dd/yy KK:mm:ss a");
                        }
                        if (i2 == 0) {
                            String pattern = DateGuesser.getPattern((String)("" + trajectvector[lenvector - 3]));
                            AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: sample time conversion: original " + trajectvector[lenvector - 3] + " guessed: " + timeStamps[i2] + " pattern: " + pattern));
                        }
                        try {
                            coordinates[i2] = new Point2D.Double(Double.parseDouble("" + trajectvector[lenvector - 2]), Double.parseDouble("" + trajectvector[lenvector - 1]));
                        }
                        catch (Exception e) {
                            AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: Warning - wrong coordinates: " + trajectvector[lenvector - 2] + "," + trajectvector[lenvector - 1]));
                            coordinates[i2] = new Point2D.Double(0.0, 0.0);
                        }
                        ++i2;
                    }
                    AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: estimating fishing hours");
                    double[] hours = FishingHoursCalculator.calculateFishingHours(vesselIDs, timeStamps);
                    AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: estimating bathymetry");
                    short[] bathymetry = null;
                    try {
                        String bathpath = new File(this.config.getConfigPath(), "gebco_08.nc").getAbsolutePath();
                        AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: searching bathymetry in " + bathpath));
                        Bathymetry bathymetryprocessor = new Bathymetry(bathpath);
                        bathymetry = bathymetryprocessor.compute(coordinates);
                    }
                    catch (Exception e) {
                        AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: Error - Bathymetry resource not available for the service " + e.getLocalizedMessage()));
                        throw new Exception("Error - Bathymetry resource not available for the service");
                    }
                    int g = 0;
                    while (g < nvesselpoints) {
                        bathspeedpairs[g] = new Tuple((Object[])new String[]{speeds[g], "" + bathymetry[g]});
                        ++g;
                    }
                    AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: classifying routes");
                    Tuple<Integer>[] classifications = VTIClassificator.classify(bathspeedpairs);
                    AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity:building rows for the final table");
                    ArrayList<String[]> stringrows = new ArrayList<String[]>();
                    i2 = 0;
                    for (Object trajectorrow : vesselTrajectory) {
                        Object[] trajectvector = (Object[])trajectorrow;
                        String[] extendedrow = new String[nnames];
                        int j = 0;
                        while (j < nnames - 4) {
                            extendedrow[j] = "" + trajectvector[j];
                            ++j;
                        }
                        extendedrow[nnames - 4] = "" + hours[i2];
                        extendedrow[nnames - 3] = "" + bathymetry[i2];
                        extendedrow[nnames - 2] = VTIClassificator.speedClassification((Integer)classifications[i2].getElements().get(0));
                        extendedrow[nnames - 1] = VTIClassificator.bathymetryClassification((Integer)classifications[i2].getElements().get(1));
                        stringrows.add(extendedrow);
                        ++i2;
                    }
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: inserting chunks into the table " + this.outTable));
                    DatabaseUtils.insertChunksIntoTable((String)this.outTable, (String)colnames.toString(), stringrows, (int)nvesselpoints, (SessionFactory)this.connection, (boolean)true);
                    AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: inserting chunks done!");
                    ++k;
                }
                AnalysisLogger.getLogger().debug((Object)"EstimateFishingActivity: finished");
            }
            catch (Throwable e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity : ERROR!: " + e.getLocalizedMessage()));
                try {
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: dropping " + this.outTable));
                    DatabaseFactory.executeSQLUpdate((String)DatabaseUtils.dropTableStatement((String)this.outTable), (SessionFactory)this.connection);
                }
                catch (Exception e1) {
                    AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity: could not drop " + this.outTable));
                }
                throw new Exception(e.getMessage());
            }
        }
        finally {
            this.shutdown();
            AnalysisLogger.getLogger().debug((Object)("EstimateFishingActivity finished in " + (System.currentTimeMillis() - t0) + " ms"));
        }
    }
}

