/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.algorithms;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.commons.io.FileDeleteStrategy;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveTypesList;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.gcube.dataanalysis.geo.utils.GeospatialDataPublicationLevel;
import org.gcube.dataanalysis.geo.utils.ThreddsPublisher;

public class RasterDataPublisher
extends StandardLocalExternalAlgorithm {
    private static String layerTitleParam = "DatasetTitle";
    private static String layerAbstractParam = "DatasetAbstract";
    private static String layerInnerNameParam = "InnerLayerName";
    private static String FileParam = "RasterFile";
    private static String TopicsParam = "Topics";
    private static String ResolutionParam = "SpatialResolution";
    private static String FileNameInfraParam = "FileNameOnInfra";

    public String getDescription() {
        return "This algorithm publishes a raster file as a maps or datasets in the e-Infrastructure. NetCDF-CF files are encouraged, as WMS and WCS maps will be produced using this format. For other types of files (GeoTiffs, ASC etc.) only the raw datasets will be published. The resulting map or dataset will be accessible via the VRE GeoExplorer by the VRE participants.";
    }

    public void init() throws Exception {
    }

    protected void process() throws Exception {
        this.status = 10.0f;
        String scope = this.config.getGcubeScope();
        String username = this.config.getParam("ServiceUserName");
        String fileAbsolutePath = this.config.getParam(FileParam);
        String fileName = this.config.getParam(FileNameInfraParam);
        String layerTitle = this.config.getParam(layerTitleParam);
        String layerName = this.config.getParam(layerInnerNameParam);
        String abstractField = this.config.getParam(layerAbstractParam);
        Object[] topics = this.config.getParam(TopicsParam).split(AlgorithmConfiguration.listSeparator);
        String publicationLevelValue = this.getInputParameter("PublicationLevel");
        this.log("Publication Level:" + publicationLevelValue);
        boolean isprivate = false;
        if (GeospatialDataPublicationLevel.valueOf(publicationLevelValue) == GeospatialDataPublicationLevel.PRIVATE) {
            isprivate = true;
        }
        AnalysisLogger.getLogger().debug((Object)("scope: " + scope));
        AnalysisLogger.getLogger().debug((Object)("username: " + username));
        AnalysisLogger.getLogger().debug((Object)("fileAbsolutePath: " + fileAbsolutePath));
        AnalysisLogger.getLogger().debug((Object)("layerTitle: " + layerTitle));
        AnalysisLogger.getLogger().debug((Object)("layerName: " + layerName));
        AnalysisLogger.getLogger().debug((Object)("abstractField: " + abstractField));
        AnalysisLogger.getLogger().debug((Object)("topics: " + topics));
        AnalysisLogger.getLogger().debug((Object)("filename: " + fileName));
        AnalysisLogger.getLogger().debug((Object)("is private: " + isprivate));
        if (scope == null || username == null) {
            throw new Exception("Service parameters are not set - please contact the Administrators");
        }
        if (fileAbsolutePath == null || fileAbsolutePath.trim().length() == 0) {
            throw new Exception("No file has been provided to the process");
        }
        if (layerTitle == null || layerTitle.trim().length() == 0) {
            throw new Exception("Please provide a valid dataset title");
        }
        if (abstractField == null || abstractField.trim().length() == 0) {
            throw new Exception("Please provide a valid abstract for the dataset");
        }
        if (topics == null || topics.length == 0 || topics[0].length() == 0) {
            throw new Exception("Please provide at least a valid topic for the dataset");
        }
        double resolution = Double.parseDouble(this.config.getParam(ResolutionParam));
        AnalysisLogger.getLogger().debug((Object)("resolution: " + resolution));
        if (!(fileName.endsWith(".nc") || fileName.endsWith(".tiff") || fileName.endsWith(".geotiff") || fileName.endsWith(".asc") || fileName.endsWith(".ncml"))) {
            throw new Exception("Wrong file name: allowed files extensions are .nc, .tiff, .geotiff, .asc, .ncml");
        }
        File f = new File(fileAbsolutePath);
        File newf = new File(f.getParent(), fileName);
        AnalysisLogger.getLogger().debug((Object)("renaming: " + fileAbsolutePath + " to " + newf.getAbsolutePath()));
        boolean renamed = f.renameTo(newf);
        if (!renamed) {
            throw new Exception("Impossible to use " + fileName + " as file name");
        }
        fileName = fileName.trim();
        layerTitle = layerTitle.trim();
        layerName = layerName.trim();
        abstractField = abstractField.trim();
        ArrayList<String> listTopics = new ArrayList<String>();
        listTopics.addAll(Arrays.asList(topics));
        listTopics.add(username);
        listTopics.add("D4Science");
        listTopics.add(scope);
        String[] topicsListArr = new String[listTopics.size()];
        topics = listTopics.toArray(topicsListArr);
        boolean result = ThreddsPublisher.publishOnThredds(scope, username, newf.getAbsolutePath(), layerTitle, layerName, abstractField, (String[])topics, resolution, isprivate);
        if (result) {
            this.addOutputString("Created map name", layerTitle);
            this.addOutputString("Map abstract", abstractField);
            this.addOutputString("Map Topics", Arrays.toString(topics));
            this.addOutputString("Inner layer name", layerName);
            this.addOutputString("File name created in the e-Infrastructure", fileName);
            this.addOutputString("Map creator", username);
        }
        AnalysisLogger.getLogger().debug((Object)("Deleting raster file " + newf.getAbsolutePath()));
        try {
            OSCommand.ExecuteGetLine((String)("rm " + newf.getAbsolutePath()), null);
        }
        catch (Exception e) {
            // empty catch block
        }
        FileDeleteStrategy.FORCE.deleteQuietly(newf);
        System.gc();
        this.status = 100.0f;
    }

    protected void setInputParameters() {
        try {
            PrimitiveType e = new PrimitiveType(Enum.class.getName(), (Object)GeospatialDataPublicationLevel.values(), PrimitiveTypes.ENUMERATED, "PublicationLevel", "The visibility level of the produced map", "" + (Object)((Object)GeospatialDataPublicationLevel.PRIVATE));
            this.inputs.add(e);
            this.addStringInput(layerTitleParam, "Title of the geospatial dataset to be shown on GeoExplorer", "Generic Raster Layer");
            this.addStringInput(layerAbstractParam, "Abstract defining the content, the references and usage policies", "Abstract");
            this.addStringInput(layerInnerNameParam, "Name of the inner layer or band to be published as a Map (ignored for non-NetCDF files)", "band_1");
            this.addStringInput(FileNameInfraParam, "Name of the file that will be created in the infrastructures", "raster-" + System.currentTimeMillis() + ".nc");
            this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, FileParam, "Raster dataset to process"));
            this.inputs.add(new PrimitiveTypesList(String.class.getName(), PrimitiveTypes.STRING, TopicsParam, "Topics to be attached to the published dataset. E.g. Biodiversity, D4Science, Environment, Weather", false));
            this.addDoubleInput(ResolutionParam, "The resolution of the layer. For NetCDF file this is automatically estimated by data (leave -1)", "-1d");
            this.inputs.add(new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"RasterFilePublisher - shutdown");
    }
}

