/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.geo.test;

import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.Tuple;
import org.gcube.dataanalysis.geo.connectors.asc.AscDataExplorer;
import org.gcube.dataanalysis.geo.connectors.asc.AscRaster;
import org.gcube.dataanalysis.geo.connectors.asc.AscRasterWriter;
import org.gcube.dataanalysis.geo.matrixmodel.XYExtractor;

public class TestPointslice {
    static String cfg = "./cfg/";

    public static void main1(String[] args) throws Exception {
        String layertitle = "Statistical Mean in [07-01-01 01:00] (3D) {World Ocean Atlas 09: Sea Water Temperature - annual: dods://thredds.research-infrastructures.eu/thredds/dodsC/public/netcdf/temperature_annual_1deg_ENVIRONMENT_OCEANS_.nc}";
        long t0 = System.currentTimeMillis();
        AnalysisLogger.setLogger((String)(String.valueOf(cfg) + AlgorithmConfiguration.defaultLoggerFile));
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setGcubeScope("/gcube");
        config.setConfigPath(cfg);
        XYExtractor intersector = new XYExtractor(config);
        double[][] output = intersector.extractXYGrid(layertitle, 0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.5, 0.5);
        System.out.println("ELAPSED TIME: " + (System.currentTimeMillis() - t0));
        System.out.println("Output: " + output[0][0]);
    }

    public static void main2(String[] args) throws Exception {
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        int j = 0;
        while (j < 100) {
            double randomx = 180.0 * Math.random() - 180.0;
            double randomy = 90.0 * Math.random() - 90.0;
            tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{randomx, randomy, 0.0}));
            ++j;
        }
        AscDataExplorer ade1 = new AscDataExplorer("./maxentfd4c59b3-2c65-4c4e-a235-84093d58230d/layer1.asc");
        List<Double> features = ade1.retrieveDataFromAsc(tuples, 0);
        AscDataExplorer ade2 = new AscDataExplorer("./maxentCompleteLayers/layer1.asc");
        List<Double> features2 = ade2.retrieveDataFromAsc(tuples, 0);
        int i = 0;
        while (i < features.size()) {
            if (features.get(i) - features2.get(i) != 0.0 && (features.get(i).isNaN() && !features2.get(i).isNaN() || !features.get(i).isNaN() && features2.get(i).isNaN())) {
                System.out.println(tuples.get(i) + ":" + features.get(i) + " vs " + features2.get(i) + " - " + (features.get(i) - features2.get(i)));
            }
            ++i;
        }
        System.out.println("Finished");
    }

    public static void main3(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setGcubeScope("/gcube/devsec/devVRE");
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        XYExtractor extractor = new XYExtractor(config);
        double x1 = -60.0;
        double x2 = 60.0;
        double y1 = -10.0;
        double y2 = 10.0;
        double[][] values = extractor.extractXYGrid("dfd1bad2-ab00-42ac-8bb2-46a17162f509", 0, x1, x2, y1, y2, 0.0, 0.08333333, 0.08333333);
        List currentTimeValues = extractor.currentTimeValues;
        AscRasterWriter writer = new AscRasterWriter();
        writer.writeRasterInvertYAxis("testwritten.asc", new AscRaster(values, 0.08333333, -1.0, -1.0, x1, y1));
        AscDataExplorer ade2 = new AscDataExplorer("./maxentCompleteLayers/layer1.asc");
        List<Double> features2 = ade2.retrieveDataFromAsc(extractor.currentTuples, 0);
        int g = 0;
        int k = 0;
        int i = 0;
        while (i < currentTimeValues.size()) {
            System.out.println("1-" + extractor.currentTuples.get(i) + ":" + currentTimeValues.get(i) + " vs " + features2.get(i) + " - " + ((Double)currentTimeValues.get(i) - features2.get(i)));
            System.out.println("2-" + extractor.currentTuples.get(i) + ":" + values[k][g] + " vs " + currentTimeValues.get(i) + " - " + (values[k][g] - (Double)currentTimeValues.get(i)));
            if (++g >= values[0].length) {
                g = 0;
                ++k;
            }
            ++i;
        }
        System.out.println("Finished");
    }

    public static void main4(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setGcubeScope("/gcube/devsec/devVRE");
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        XYExtractor extractor = new XYExtractor(config);
        double x1 = -60.0;
        double x2 = 60.0;
        double y1 = -10.0;
        double y2 = 10.0;
        double[][] values = extractor.extractXYGrid("dfd1bad2-ab00-42ac-8bb2-46a17162f509", 0, x1, x2, y1, y2, 0.0, 0.08333333, 0.08333333);
        List currentTimeValues = extractor.currentTimeValues;
        AscDataExplorer ade1 = new AscDataExplorer("./testwritten.asc");
        List<Double> features1 = ade1.retrieveDataFromAsc(extractor.currentTuples, 0);
        AscDataExplorer ade2 = new AscDataExplorer("./maxentCompleteLayers/layer1.asc");
        List<Double> features2 = ade2.retrieveDataFromAsc(extractor.currentTuples, 0);
        int i = 0;
        while (i < currentTimeValues.size()) {
            System.out.println("1-" + extractor.currentTuples.get(i) + ":" + features1.get(i) + " vs " + features2.get(i) + " - " + (features1.get(i) - features2.get(i)));
            ++i;
        }
        System.out.println("Finished");
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setConfigPath("./cfg/");
        config.setPersistencePath("./");
        config.setGcubeScope("/gcube/devsec/devVRE");
        AnalysisLogger.setLogger((String)(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile));
        double x1 = -60.0;
        double x2 = 60.0;
        double y1 = -10.0;
        double y2 = 10.0;
        ArrayList<Tuple<Double>> tuples = new ArrayList<Tuple<Double>>();
        int j = 0;
        while (j < 100) {
            double randomx = (x1 - x2) * Math.random() + x2;
            double randomy = (y1 - y2) * Math.random() + y2;
            tuples.add((Tuple<Double>)new Tuple((Object[])new Double[]{randomx, randomy, 0.0}));
            ++j;
        }
        AscDataExplorer ade1 = new AscDataExplorer("./maxent93db29d5-6a38-4598-9c66-5a814f4a9f36/layer1.asc");
        List<Double> features1 = ade1.retrieveDataFromAsc(tuples, 0);
        AscDataExplorer ade2 = new AscDataExplorer("./maxenttestfolder/nitrate.asc");
        List<Double> features2 = ade2.retrieveDataFromAsc(tuples, 0);
        int i = 0;
        while (i < tuples.size()) {
            System.out.println("1-" + tuples.get(i) + ":" + features1.get(i) + " vs " + features2.get(i) + " - " + (features1.get(i) - features2.get(i)));
            ++i;
        }
        System.out.println("Finished");
    }
}

