/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import org.apache.activemq.ActiveMQConnection;
import org.gcube.common.clients.Plugin;
import org.gcube.common.clients.ProxyBuilderImpl;
import org.gcube.common.clients.config.Property;
import org.gcube.common.resources.gcore.ServiceEndpoint;
import org.gcube.common.scope.api.ScopeProvider;
import org.gcube.contentmanagement.blobstorage.service.IClient;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanager.storageclient.wrapper.AccessType;
import org.gcube.contentmanager.storageclient.wrapper.MemoryType;
import org.gcube.contentmanager.storageclient.wrapper.StorageClient;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.job.management.QueueWorkerWatcher;
import org.gcube.dataanalysis.executor.job.management.WorkerWatcher;
import org.gcube.dataanalysis.executor.messagequeue.ATTRIBUTE;
import org.gcube.dataanalysis.executor.messagequeue.Consumer;
import org.gcube.dataanalysis.executor.messagequeue.Producer;
import org.gcube.dataanalysis.executor.messagequeue.QCONSTANTS;
import org.gcube.dataanalysis.executor.messagequeue.QueueManager;
import org.gcube.dataanalysis.executor.scripts.ScriptIOWorker;
import org.gcube.resources.discovery.client.api.DiscoveryClient;
import org.gcube.resources.discovery.client.queries.api.Query;
import org.gcube.resources.discovery.client.queries.impl.XQuery;
import org.gcube.resources.discovery.icclient.ICFactory;
import org.gcube.vremanagement.executor.api.types.LaunchParameter;
import org.gcube.vremanagement.executor.client.plugins.ExecutorPlugin;
import org.gcube.vremanagement.executor.client.plugins.query.SmartExecutorPluginQuery;
import org.gcube.vremanagement.executor.client.plugins.query.filter.EndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.ListEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.plugins.query.filter.SpecificEndpointDiscoveryFilter;
import org.gcube.vremanagement.executor.client.proxies.SmartExecutorProxy;
import org.gcube.vremanagement.executor.client.util.Tuple;

public class QueueJobManager {
    public static int broadcastTimePeriod = 120000;
    public static int maxSilenceTimeBeforeComputationStop = 10800000;
    public static int maxNumberOfComputationRetries = 1;
    public static int computationWatcherTimerPeriod = 120000;
    public static int maxNumberOfStages = Integer.MAX_VALUE;
    public static int queueWatcherMaxwaitingTime = QCONSTANTS.refreshStatusTime;
    protected int maxFailureTries;
    private static String pluginName = "SmartGenericWorker";
    protected String scope;
    protected String session;
    protected boolean yetstopped;
    protected boolean messagesresent;
    protected float status;
    protected boolean abort;
    protected boolean shutdown;
    protected List<String> eprs;
    protected int activeNodes;
    protected int computingNodes;
    protected int numberOfMessages;
    protected int totalNumberOfMessages;
    protected int actualNumberOfNodes;
    protected int totalNumberOfStages;
    public int currentNumberOfStages;
    protected List<String> filenames;
    protected List<String> fileurls;
    protected String queueName;
    protected String queueResponse;
    protected String queueURL;
    protected String queueUSER;
    protected String queuePWD;
    protected Consumer consumer;
    protected Producer producer;
    Timer broadcastTimer;
    Timer computationWatcherTimer;
    ComputationTimerWatcher computationWatcher;
    String serviceClass;
    String serviceName;
    String owner;
    String localDir;
    String remoteDir;
    String outputDir;
    String script;
    List<String> arguments;
    String configuration;
    boolean deletefiles;
    StatusListener statuslistener;
    private int totalmessages = 0;
    boolean[] activeMessages;
    public int[] resentMessages;

    private void resetAllVars() {
        this.scope = null;
        this.yetstopped = false;
        this.messagesresent = false;
        this.status = 0.0f;
        this.abort = false;
        this.shutdown = false;
        this.eprs = null;
        this.activeNodes = 0;
        this.computingNodes = 0;
        this.numberOfMessages = 0;
        this.actualNumberOfNodes = 0;
        this.filenames = null;
        this.fileurls = null;
        this.queueName = null;
        this.queueResponse = null;
        this.queueURL = null;
        this.queueUSER = null;
        this.queuePWD = null;
        this.consumer = null;
        this.producer = null;
        this.broadcastTimer = null;
        this.computationWatcherTimer = null;
        this.computationWatcher = null;
        this.serviceClass = null;
        this.serviceName = null;
        this.owner = null;
        this.localDir = null;
        this.remoteDir = null;
        this.outputDir = null;
        this.script = null;
        this.arguments = null;
        this.configuration = null;
        this.deletefiles = false;
        this.statuslistener = null;
    }

    public int getActiveNodes() {
        return this.computingNodes;
    }

    public float getStatus() {
        float innerStatus = 0.0f;
        if (this.totalNumberOfMessages != 0) {
            innerStatus = 1.0f - (float)this.numberOfMessages / (float)this.totalNumberOfMessages;
        }
        if (this.totalNumberOfStages == 0) {
            return innerStatus;
        }
        float offset = (float)Math.max(this.currentNumberOfStages - 1, 0) / (float)this.totalNumberOfStages;
        float status = offset + innerStatus / (float)this.totalNumberOfStages;
        return status;
    }

    public int getNumberOfNodes() {
        if (this.eprs.size() > 0) {
            return 1;
        }
        return 0;
    }

    public void setNumberOfNodes(int newNumberOfNodes) {
    }

    private void init(String scope, int numberOfNodes) throws Exception {
        this.resetAllVars();
        this.scope = scope;
        this.shutdown = false;
        this.yetstopped = false;
        this.messagesresent = false;
        this.abort = false;
        this.findNodes(scope);
    }

    public QueueJobManager(String scope, int numberOfNodes) throws Exception {
        this.init(scope, numberOfNodes);
    }

    public QueueJobManager(String scope, int numberOfNodes, List<String> eprs) throws Exception {
        this.init(scope, numberOfNodes);
        this.eprs = eprs;
    }

    private void setGlobalVars(String serviceClass, String serviceName, String owner, String localDir, String remoteDir, String outputDir, String script, List<String> arguments, String configuration, boolean deletefiles) {
        this.serviceClass = serviceClass;
        this.serviceName = serviceName;
        this.owner = owner;
        this.localDir = localDir;
        this.remoteDir = remoteDir;
        this.outputDir = outputDir;
        this.script = script;
        this.arguments = arguments;
        this.configuration = configuration;
        this.deletefiles = deletefiles;
    }

    public boolean uploadAndExecuteChunkized(String serviceClass, String serviceName, String owner, String localDir, String remoteDir, String outputDir, String script, List<String> arguments, String configuration, boolean deletefiles, boolean forceUpload) throws Exception {
        int allchunks;
        long t0 = System.currentTimeMillis();
        int elements = arguments.size();
        this.session = (String.valueOf(("" + UUID.randomUUID()).replace("-", "")) + Math.random()).replace(".", "");
        int[] chunkSizes = null;
        chunkSizes = elements > maxNumberOfStages ? Operations.takeChunks((int)elements, (int)maxNumberOfStages) : new int[]{elements};
        this.totalNumberOfStages = allchunks = chunkSizes.length;
        this.currentNumberOfStages = 0;
        int start = 0;
        this.totalmessages = 0;
        AnalysisLogger.getLogger().info((Object)("Starting the computation in  " + allchunks + " stages"));
        int i = 0;
        while (i < allchunks) {
            this.totalNumberOfMessages = 0;
            this.numberOfMessages = 0;
            ++this.currentNumberOfStages;
            int end = Math.min(elements, start + chunkSizes[i]);
            AnalysisLogger.getLogger().info((Object)("Computing the chunk number " + (i + 1) + " of " + allchunks + " between " + start + " and " + (end - 1)));
            ArrayList<String> sublist = new ArrayList<String>();
            int j = start;
            while (j < end) {
                sublist.add(arguments.get(j));
                ++j;
            }
            AnalysisLogger.getLogger().info((Object)("size sub:" + sublist.size()));
            this.uploadAndExecute(serviceClass, serviceName, owner, localDir, remoteDir, outputDir, script, sublist, configuration, deletefiles, forceUpload);
            if (this.abort) break;
            start = end;
            AnalysisLogger.getLogger().info((Object)("Processed chunk number " + (i + 1)));
            ++i;
        }
        this.currentNumberOfStages = this.totalNumberOfStages;
        AnalysisLogger.getLogger().info((Object)("Finished computation on all chunks and messages " + this.totalmessages));
        AnalysisLogger.getLogger().info((Object)("Whole Procedure done in " + (System.currentTimeMillis() - t0) + " ms"));
        return !this.abort;
    }

    private boolean uploadAndExecute(String serviceClass, String serviceName, String owner, String localDir, String remoteDir, String outputDir, String script, List<String> arguments, String configuration, boolean deletefiles, boolean forceUpload) throws Exception {
        int numberOfRetries = maxNumberOfComputationRetries;
        boolean recompute = true;
        while (numberOfRetries > 0 && recompute) {
            long t0 = System.currentTimeMillis();
            this.init(this.scope, 1);
            AnalysisLogger.getLogger().info((Object)("Computation Try number " + (maxNumberOfComputationRetries + 1 - numberOfRetries)));
            AnalysisLogger.getLogger().info((Object)("Contacting " + this.actualNumberOfNodes + " Nodes"));
            this.setGlobalVars(serviceClass, serviceName, owner, localDir, remoteDir, outputDir, script, arguments, configuration, deletefiles);
            this.setQueueVariables();
            this.uploadFilesOnStorage(forceUpload);
            this.createClientProducer();
            this.broadcastListenCommandToExecutorNodes();
            this.maxFailureTries = this.activeNodes * 1;
            this.broadcastTimer = new Timer();
            this.broadcastTimer.schedule((TimerTask)new Broadcaster(), broadcastTimePeriod, (long)broadcastTimePeriod);
            this.computationWatcherTimer = new Timer();
            this.computationWatcher = new ComputationTimerWatcher(maxSilenceTimeBeforeComputationStop);
            this.computationWatcherTimer.schedule((TimerTask)this.computationWatcher, computationWatcherTimerPeriod, (long)computationWatcherTimerPeriod);
            this.sendMessages();
            this.createClientConsumer();
            this.waitForMessages();
            AnalysisLogger.getLogger().info((Object)"Wait for message finished - checking result");
            if (this.numberOfMessages == 0) {
                AnalysisLogger.getLogger().info((Object)"All tasks have correctly finished!");
            }
            AnalysisLogger.getLogger().info((Object)"-SUMMARY-");
            int i = 0;
            while (i < this.totalNumberOfMessages) {
                if (this.activeMessages[i]) {
                    AnalysisLogger.getLogger().info((Object)("Error : the Message Number " + i + " Was Never Processed!"));
                }
                if (this.resentMessages[i] > 0) {
                    this.messagesresent = true;
                    AnalysisLogger.getLogger().info((Object)("Warning : the Message Number " + i + " Was resent " + this.resentMessages[i] + " Times"));
                }
                ++i;
            }
            AnalysisLogger.getLogger().info((Object)"-SUMMARY END-");
            this.stop();
            AnalysisLogger.getLogger().info((Object)"Stopped");
            AnalysisLogger.getLogger().info((Object)("Single Step Procedure done in " + (System.currentTimeMillis() - t0) + " ms"));
            this.activeNodes = 0;
            --numberOfRetries;
            if (this.abort) {
                recompute = true;
                if (numberOfRetries <= 0) continue;
                Thread.sleep(10000L);
                continue;
            }
            recompute = false;
        }
        return !this.abort;
    }

    public boolean hasResentMessages() {
        return this.messagesresent;
    }

    public void waitForMessages() throws Exception {
        AnalysisLogger.getLogger().info((Object)"Waiting...");
        while (this.numberOfMessages > 0 && !this.abort) {
            Thread.sleep(2000L);
        }
        AnalysisLogger.getLogger().info((Object)("...Stop - Abort?" + this.abort));
    }

    public boolean wasAborted() {
        return this.abort;
    }

    public void purgeQueues() throws Exception {
        AnalysisLogger.getLogger().info((Object)"Purging Queue");
        ArrayList<WorkerWatcher> tasksProxies = new ArrayList<WorkerWatcher>();
        int j = 0;
        while (j < this.actualNumberOfNodes) {
            try {
                this.contactNodes(tasksProxies, j, this.queueName, this.queueUSER, this.queuePWD, this.queueURL, this.queueResponse, this.session, "true");
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)("Error in purgin queue on node " + j));
            }
            ++j;
        }
        AnalysisLogger.getLogger().info((Object)"Queue Purged");
    }

    public void stop() {
        block9: {
            try {
                if (this.yetstopped) break block9;
                if (this.broadcastTimer != null) {
                    AnalysisLogger.getLogger().info((Object)"Stopping Broadcaster");
                    this.broadcastTimer.cancel();
                    this.broadcastTimer.purge();
                }
                if (this.computationWatcherTimer != null) {
                    AnalysisLogger.getLogger().info((Object)"Stopping Watcher");
                    this.computationWatcherTimer.cancel();
                    this.computationWatcherTimer.purge();
                }
                AnalysisLogger.getLogger().info((Object)"Purging Status Listener");
                if (this.statuslistener != null) {
                    this.statuslistener.destroyAllWatchers();
                }
                AnalysisLogger.getLogger().info((Object)"Stopping Producer and Consumer");
                try {
                    this.producer.stop();
                    this.producer.closeSession();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.consumer.stop();
                    this.consumer.closeSession();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                AnalysisLogger.getLogger().info((Object)"Purging Remote Queues");
                this.purgeQueues();
                this.yetstopped = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)"Not completely stopped");
            }
        }
    }

    private void contactNodes(List<WorkerWatcher> tasksProxies, int order, String queueName, String queueUSER, String queuePWD, String queueURL, String queueResponse, String session, String purgeQueue) throws Exception {
        Map<String, Object> inputs = this.generateWorkerInput(queueName, queueUSER, queuePWD, queueURL, queueResponse, session, purgeQueue);
        AnalysisLogger.getLogger().info((Object)("Inputs " + inputs));
        String selectedEPR = this.eprs.get(order);
        AnalysisLogger.getLogger().info((Object)("Broadcasting to node " + (order + 1) + " on " + selectedEPR));
        ScopeProvider.instance.set(this.scope);
        ExecutorPlugin runExecutorPlugin = new ExecutorPlugin();
        SmartExecutorPluginQuery runQuery = new SmartExecutorPluginQuery((Plugin)runExecutorPlugin);
        runQuery.addConditions(pluginName, new Tuple[0]);
        SpecificEndpointDiscoveryFilter sedf = new SpecificEndpointDiscoveryFilter(selectedEPR);
        runQuery.setEndpointDiscoveryFilter((EndpointDiscoveryFilter)sedf);
        SmartExecutorProxy proxy = (SmartExecutorProxy)new ProxyBuilderImpl((Plugin)runExecutorPlugin, (org.gcube.common.clients.queries.Query)runQuery, new Property[0]).build();
        AnalysisLogger.getLogger().debug((Object)("Launching Smart Executor in namely Scope: " + this.scope + " real scope " + ScopeProvider.instance.get()));
        LaunchParameter launchParameter = new LaunchParameter(pluginName, inputs);
        String excecutionIdentifier = proxy.launch(launchParameter);
        tasksProxies.add(new WorkerWatcher(proxy, excecutionIdentifier, AnalysisLogger.getLogger()));
        AnalysisLogger.getLogger().info((Object)("Contacting node " + (order + 1) + " OK on " + selectedEPR));
    }

    private List<String> getFilteredEndpoints(String scopeString) {
        ScopeProvider.instance.set(scopeString);
        ExecutorPlugin executorPlugin = new ExecutorPlugin();
        SmartExecutorPluginQuery query = new SmartExecutorPluginQuery((Plugin)executorPlugin);
        query.addConditions(pluginName, new Tuple[0]);
        query.setServiceEndpointQueryFilter(null);
        List nodes = query.discoverEndpoints((EndpointDiscoveryFilter)new ListEndpointDiscoveryFilter());
        AnalysisLogger.getLogger().debug((Object)("Found the following nodes: " + nodes + " in scope " + scopeString));
        return nodes;
    }

    private int findNodes(String scopeString) throws Exception {
        this.eprs = this.getFilteredEndpoints(scopeString);
        this.actualNumberOfNodes = this.eprs.size();
        return this.actualNumberOfNodes;
    }

    public String getQueueURL(String scope) throws Exception {
        ScopeProvider.instance.set(scope);
        XQuery query = ICFactory.queryFor(ServiceEndpoint.class);
        query.addCondition("$resource/Profile/Category/text() eq 'Service' and $resource/Profile/Name eq 'MessageBroker' ");
        DiscoveryClient client = ICFactory.clientFor(ServiceEndpoint.class);
        List resources = client.submit((Query)query);
        if (resources == null || resources.size() == 0) {
            throw new Exception("No Message-Queue available in scope " + scope);
        }
        ServiceEndpoint.AccessPoint ap = (ServiceEndpoint.AccessPoint)((ServiceEndpoint)resources.get(0)).profile().accessPoints().iterator().next();
        String queue = ap.address();
        AnalysisLogger.getLogger().debug((Object)("Found AMQ Url : " + queue));
        return queue;
    }

    private void setQueueVariables() throws Exception {
        this.queueName = "D4ScienceJob";
        this.queueResponse = String.valueOf(this.queueName) + "Response" + this.session;
        this.queueURL = this.getQueueURL(this.scope);
        AnalysisLogger.getLogger().info((Object)("Queue for the scope: " + this.queueURL));
        if (this.queueURL == null) {
            this.queueURL = this.scope.startsWith("/gcube") ? "tcp://ui.grid.research-infrastructures.eu:6166" : "tcp://message-broker.d4science.research-infrastructures.eu:6166";
        }
        this.queueUSER = ActiveMQConnection.DEFAULT_USER;
        this.queuePWD = ActiveMQConnection.DEFAULT_PASSWORD;
    }

    public void deleteRemoteFolder() throws Exception {
        ScopeProvider.instance.set(this.scope);
        IClient client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED, MemoryType.VOLATILE).getClient();
        AnalysisLogger.getLogger().info((Object)("Removing Remote Dir " + this.remoteDir));
        client.removeDir().RDir(this.remoteDir);
        AnalysisLogger.getLogger().info((Object)"Removed");
    }

    private void uploadFilesOnStorage(boolean forceupload) throws Exception {
        List remoteObjects;
        ScopeProvider.instance.set(this.scope);
        IClient client = new StorageClient(this.serviceClass, this.serviceName, this.owner, AccessType.SHARED, MemoryType.VOLATILE).getClient();
        File dir = new File(this.localDir);
        File[] files = dir.listFiles();
        AnalysisLogger.getLogger().info((Object)"Start uploading");
        this.filenames = new ArrayList<String>();
        this.fileurls = new ArrayList<String>();
        boolean uploadFiles = forceupload;
        if (!uploadFiles && (remoteObjects = client.showDir().RDir(this.remoteDir)).size() == 0) {
            uploadFiles = true;
        }
        if (!uploadFiles) {
            AnalysisLogger.getLogger().info((Object)"Unnecessary to Uploading Files");
        }
        AnalysisLogger.getLogger().info((Object)"Loading files");
        String tempdir = UUID.randomUUID() + "/";
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File sfile = fileArray[n2];
            if (!sfile.getName().startsWith(".")) {
                String localf = sfile.getAbsolutePath();
                String filename = sfile.getName();
                String remotef = String.valueOf(this.remoteDir) + tempdir + sfile.getName();
                if (uploadFiles) {
                    client.put(true).LFile(localf).RFile(remotef);
                    AnalysisLogger.getLogger().info((Object)("Uploading File " + localf + " as remote file " + remotef));
                }
                String url = client.getUrl().RFile(remotef);
                this.filenames.add(filename);
                this.fileurls.add(url);
            }
            ++n2;
        }
        AnalysisLogger.getLogger().info((Object)"Loading finished");
    }

    private void broadcastListenCommandToExecutorNodes() throws Exception {
        AnalysisLogger.getLogger().info((Object)("Submitting script to Remote Queue " + this.queueName));
        ArrayList<WorkerWatcher> tasksProxies = new ArrayList<WorkerWatcher>();
        try {
            this.findNodes(this.scope);
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().info((Object)"Error in Finding nodes - using previous value");
        }
        this.activeNodes = this.actualNumberOfNodes;
        int i = 0;
        while (i < this.actualNumberOfNodes) {
            try {
                this.contactNodes(tasksProxies, i, this.queueName, this.queueUSER, this.queuePWD, this.queueURL, this.queueResponse, this.session, "false");
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)"Error in Contacting nodes");
            }
            ++i;
        }
    }

    private void createClientProducer() throws Exception {
        AnalysisLogger.getLogger().info((Object)"Creating Message Queue and Producer");
        QueueManager qm = new QueueManager();
        qm.createAndConnect(this.queueUSER, this.queuePWD, this.queueURL, this.queueName);
        this.producer = new Producer(qm, this.queueName);
        AnalysisLogger.getLogger().info((Object)"Producer OK");
    }

    private void createClientConsumer() throws Exception {
        AnalysisLogger.getLogger().info((Object)"Creating Response Message Queue and Consumer");
        this.statuslistener = new StatusListener();
        QueueManager qm1 = new QueueManager();
        qm1.createAndConnect(this.queueUSER, this.queuePWD, this.queueURL, this.queueResponse);
        this.consumer = new Consumer(qm1, this.statuslistener, this.statuslistener, this.queueResponse);
        AnalysisLogger.getLogger().info((Object)"Consumers OK");
    }

    private void sendMessages() throws Exception {
        int i = 0;
        this.totalNumberOfMessages = this.numberOfMessages = this.arguments.size();
        AnalysisLogger.getLogger().info((Object)("Messages To Send " + this.numberOfMessages));
        this.activeMessages = new boolean[this.numberOfMessages];
        this.resentMessages = new int[this.numberOfMessages];
        for (String argum : this.arguments) {
            Map<String, Object> inputs = this.generateInputMessage(this.filenames, this.fileurls, this.outputDir, this.script, argum, i, this.scope, this.serviceClass, this.serviceName, this.owner, this.remoteDir, this.session, this.configuration, this.deletefiles, false);
            this.producer.sendMessage(inputs, 0L);
            AnalysisLogger.getLogger().info((Object)("Send " + i));
            this.activeMessages[i] = true;
            ++i;
        }
        AnalysisLogger.getLogger().info((Object)("Messages Sent " + this.numberOfMessages));
    }

    private Map<String, Object> generateInputMessage(Object filenames, Object fileurls, String outputDir, String script, String argum, int i, String scope, String serviceClass, String serviceName, String owner, String remoteDir, String session, String configuration, boolean deletefiles, boolean duplicateMessage) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(ATTRIBUTE.FILE_NAMES.name(), filenames);
        inputs.put(ATTRIBUTE.FILE_URLS.name(), fileurls);
        inputs.put(ATTRIBUTE.OUTPUTDIR.name(), outputDir);
        inputs.put(ATTRIBUTE.SCRIPT.name(), script);
        inputs.put(ATTRIBUTE.ARGUMENTS.name(), String.valueOf(argum) + " " + duplicateMessage);
        inputs.put(ATTRIBUTE.ORDER.name(), "" + i);
        inputs.put(ATTRIBUTE.SCOPE.name(), scope);
        inputs.put(ATTRIBUTE.SERVICE_CLASS.name(), serviceClass);
        inputs.put(ATTRIBUTE.SERVICE_NAME.name(), serviceName);
        inputs.put(ATTRIBUTE.OWNER.name(), owner);
        inputs.put(ATTRIBUTE.REMOTEDIR.name(), remoteDir);
        inputs.put(ATTRIBUTE.CLEAN_CACHE.name(), "" + deletefiles);
        inputs.put(ATTRIBUTE.QSESSION.name(), session);
        inputs.put(ATTRIBUTE.CONFIGURATION.name(), configuration);
        inputs.put(ATTRIBUTE.TOPIC_RESPONSE_NAME.name(), this.queueResponse);
        inputs.put(ATTRIBUTE.QUEUE_USER.name(), this.queueUSER);
        inputs.put(ATTRIBUTE.QUEUE_PASSWORD.name(), this.queuePWD);
        inputs.put(ATTRIBUTE.QUEUE_URL.name(), this.queueURL);
        return inputs;
    }

    private Map<String, Object> generateWorkerInput(String queueName, String queueUser, String queuePassword, String queueURL, String queueResponse, String session, String purge) {
        HashMap<String, Object> inputs = new HashMap<String, Object>();
        inputs.put(ATTRIBUTE.TOPIC_NAME.name(), ScriptIOWorker.toInputString(queueName));
        inputs.put(ATTRIBUTE.QUEUE_USER.name(), ScriptIOWorker.toInputString(queueUser));
        inputs.put(ATTRIBUTE.QUEUE_PASSWORD.name(), ScriptIOWorker.toInputString(queuePassword));
        inputs.put(ATTRIBUTE.QUEUE_URL.name(), ScriptIOWorker.toInputString(queueURL));
        inputs.put(ATTRIBUTE.TOPIC_RESPONSE_NAME.name(), ScriptIOWorker.toInputString(queueResponse));
        inputs.put(ATTRIBUTE.QSESSION.name(), session);
        inputs.put(ATTRIBUTE.ERASE.name(), purge);
        return inputs;
    }

    public synchronized void abort() {
        AnalysisLogger.getLogger().info((Object)"Computation Aborted");
        this.abort = true;
    }

    public class Broadcaster
    extends TimerTask {
        @Override
        public void run() {
            try {
                AnalysisLogger.getLogger().info((Object)"(((((((((((((((((((((((((((------Broadcasting Information To Watchers------)))))))))))))))))))))))))))");
                QueueJobManager.this.broadcastListenCommandToExecutorNodes();
                AnalysisLogger.getLogger().info((Object)"(((((((((((((((((((((((((((------END Broadcasting Information To Watchers------)))))))))))))))))))))))))))");
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)"--------------------------------Broadcaster: Error Sending Listen Message to Executors------)))))))))))))))))))))))))))");
            }
        }
    }

    public class ComputationTimerWatcher
    extends TimerTask {
        long maxTime;
        long lastTimeClock;

        public ComputationTimerWatcher(long maxtime) {
            this.maxTime = maxtime;
            this.lastTimeClock = System.currentTimeMillis();
        }

        public void reset() {
            this.lastTimeClock = System.currentTimeMillis();
        }

        public void setmaxTime(long maxTime) {
            this.maxTime = maxTime;
        }

        @Override
        public void run() {
            try {
                long t0 = System.currentTimeMillis();
                AnalysisLogger.getLogger().info((Object)("Computation Watcher Timing Is " + (t0 - this.lastTimeClock) + " max computation time is " + this.maxTime));
                if (t0 - this.lastTimeClock > this.maxTime) {
                    AnalysisLogger.getLogger().info((Object)"Computation Watcher - Computation Timeout:  Closing Queue Job Manager!!!");
                    QueueJobManager.this.abort();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                AnalysisLogger.getLogger().info((Object)"Error Taking clock");
            }
        }
    }

    public class StatusListener
    implements MessageListener,
    ExceptionListener {
        private QueueWorkerWatcher[] watchers;

        public synchronized void onException(JMSException ex) {
            QueueJobManager.this.abort();
            AnalysisLogger.getLogger().info((Object)"JMS Exception occured.  Shutting down client.");
        }

        private synchronized void addWatcher(int order) {
            QueueWorkerWatcher watcher;
            if (this.watchers == null) {
                this.watchers = new QueueWorkerWatcher[QueueJobManager.this.totalNumberOfMessages];
            }
            if ((watcher = this.watchers[order]) != null) {
                this.destroyWatcher(order);
            }
            Map message = QueueJobManager.this.generateInputMessage(QueueJobManager.this.filenames, QueueJobManager.this.fileurls, QueueJobManager.this.outputDir, QueueJobManager.this.script, QueueJobManager.this.arguments.get(order), order, QueueJobManager.this.scope, QueueJobManager.this.serviceClass, QueueJobManager.this.serviceName, QueueJobManager.this.owner, QueueJobManager.this.remoteDir, QueueJobManager.this.session, QueueJobManager.this.configuration, QueueJobManager.this.deletefiles, true);
            this.watchers[order] = new QueueWorkerWatcher(QueueJobManager.this.producer, message, order);
        }

        private synchronized void resetWatcher(int order) {
            if (this.watchers == null) {
                this.watchers = new QueueWorkerWatcher[QueueJobManager.this.totalNumberOfMessages];
            } else if (this.watchers[order] != null) {
                this.watchers[order].resetTime();
            }
        }

        private synchronized void destroyWatcher(int order) {
            if (this.watchers != null && this.watchers[order] != null) {
                if (this.watchers[order].hasResent()) {
                    QueueJobManager.this.resentMessages[order] = QueueJobManager.this.resentMessages[order] + 1;
                }
                this.watchers[order].destroy();
                this.watchers[order] = null;
                AnalysisLogger.getLogger().info((Object)("Destroyed Watcher number " + order));
            }
        }

        public synchronized void destroyAllWatchers() {
            if (this.watchers != null) {
                int i = 0;
                while (i < this.watchers.length) {
                    this.destroyWatcher(i);
                    ++i;
                }
            }
        }

        public void onMessage(Message message) {
            block18: {
                try {
                    HashMap details = (HashMap)message.getObjectProperty(ATTRIBUTE.CONTENT.name());
                    String status = (String)details.get(ATTRIBUTE.STATUS.name());
                    String order = "" + details.get(ATTRIBUTE.ORDER.name());
                    String nodeaddress = (String)details.get(ATTRIBUTE.NODE.name());
                    String msession = (String)details.get(ATTRIBUTE.QSESSION.name());
                    Object error = details.get(ATTRIBUTE.ERROR.name());
                    AnalysisLogger.getLogger().info((Object)("Current session " + QueueJobManager.this.session));
                    if (msession != null && msession.equals(QueueJobManager.this.session)) {
                        AnalysisLogger.getLogger().info((Object)("Session " + QueueJobManager.this.session + " is right - acknowledge"));
                        message.acknowledge();
                        AnalysisLogger.getLogger().info((Object)("Session " + QueueJobManager.this.session + " acknowledged"));
                        int orderInt = -1;
                        try {
                            orderInt = Integer.parseInt(order);
                        }
                        catch (Exception e3) {
                            e3.printStackTrace();
                        }
                        if (orderInt > -1) {
                            if (QueueJobManager.this.computationWatcher != null) {
                                QueueJobManager.this.computationWatcher.reset();
                            }
                            AnalysisLogger.getLogger().info((Object)("Task number " + order + " is " + status + " on node " + nodeaddress + " and session " + QueueJobManager.this.session));
                            if (status.equals(ATTRIBUTE.STARTED.name())) {
                                ++QueueJobManager.this.computingNodes;
                                this.addWatcher(orderInt);
                            }
                            if (status.equals(ATTRIBUTE.PROCESSING.name())) {
                                this.resetWatcher(orderInt);
                            } else if (status.equals(ATTRIBUTE.FINISHED.name())) {
                                QueueJobManager queueJobManager = QueueJobManager.this;
                                queueJobManager.totalmessages = queueJobManager.totalmessages + 1;
                                --QueueJobManager.this.computingNodes;
                                this.destroyWatcher(orderInt);
                                if (QueueJobManager.this.numberOfMessages > 0) {
                                    --QueueJobManager.this.numberOfMessages;
                                }
                                AnalysisLogger.getLogger().info((Object)("Remaining " + QueueJobManager.this.numberOfMessages + " messages to manage"));
                                QueueJobManager.this.activeMessages[orderInt] = false;
                            } else if (status.equals(ATTRIBUTE.FATAL_ERROR.name())) {
                                if (error != null) {
                                    AnalysisLogger.getLogger().info((Object)("REPORTED FATAL_ERROR on " + nodeaddress + " : "));
                                }
                                AnalysisLogger.getLogger().info(error);
                                --QueueJobManager.this.computingNodes;
                                if (QueueJobManager.this.maxFailureTries <= 0) {
                                    AnalysisLogger.getLogger().info((Object)"Too much Failures - Aborting");
                                    this.destroyAllWatchers();
                                    QueueJobManager.this.abort();
                                } else {
                                    AnalysisLogger.getLogger().info((Object)("Failure Occurred - Now Resending Message " + orderInt));
                                    QueueJobManager.this.resentMessages[orderInt] = QueueJobManager.this.resentMessages[orderInt] + 1;
                                    --QueueJobManager.this.maxFailureTries;
                                    Map retrymessage = QueueJobManager.this.generateInputMessage(QueueJobManager.this.filenames, QueueJobManager.this.fileurls, QueueJobManager.this.outputDir, QueueJobManager.this.script, QueueJobManager.this.arguments.get(orderInt), orderInt, QueueJobManager.this.scope, QueueJobManager.this.serviceClass, QueueJobManager.this.serviceName, QueueJobManager.this.owner, QueueJobManager.this.remoteDir, QueueJobManager.this.session, QueueJobManager.this.configuration, QueueJobManager.this.deletefiles, true);
                                    QueueJobManager.this.producer.sendMessage(retrymessage, QCONSTANTS.timeToLive);
                                    AnalysisLogger.getLogger().info((Object)("Failure Occurred - Resent Message " + orderInt));
                                }
                            }
                        } else {
                            AnalysisLogger.getLogger().info((Object)("Ignoring message " + order + " with status " + status));
                        }
                        break block18;
                    }
                    AnalysisLogger.getLogger().info((Object)("wrong session " + msession + " ignoring message"));
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().info((Object)"Error reading details ", (Throwable)e);
                    AnalysisLogger.getLogger().info((Object)"...Aborting Job...");
                    QueueJobManager.this.abort();
                }
            }
        }
    }
}

