/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.gcube.dataanalysis.executor.util.RScriptsManager;
import org.gcube.dataanalysis.executor.util.StorageUtils;

public class CMSY
extends ActorNode {
    public int count;
    public float status = 0.0f;
    static String idsFile = "IDsFile";
    static String stocksFile = "StocksFile";
    static String stock = "SelectedStock";
    static String processOutput = "ProcessOutput";
    static String scriptName = "CMSY_22_noplot.R";
    String outputFileName;
    AlgorithmConfiguration config;
    boolean haspostprocessed = false;

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "CMSY";
    }

    public String getDescription() {
        return "An algorithm to estimate the Maximum Sustainable Yield from a catch statistic. If also a Biomass trend is provided, MSY estimation is provided also with higher precision. The method has been developed by R. Froese, G. Coro, N. Demirel and K. Kleisner.";
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        IOHelper.addStringInput(parameters, (String)idsFile, (String)"Http link to a file containing prior information about the stocks, in WKLife IV format. Example: http://goo.gl/9rg3qK", (String)"");
        IOHelper.addStringInput(parameters, (String)stocksFile, (String)"Http link to a file containing catch and biomass (or CPUE) trends , in WKLife IV format. Example: http://goo.gl/Mp2ZLY", (String)"");
        IOHelper.addStringInput(parameters, (String)stock, (String)"The stock on which the procedure has to focus e.g. HLH_M07", (String)"");
        return parameters;
    }

    public StatisticalType getOutput() {
        File outfile = new File(this.config.getPersistencePath(), this.config.getParam(processOutput));
        PrimitiveType o = new PrimitiveType(File.class.getName(), (Object)outfile, PrimitiveTypes.FILE, "OutputFile", "Output file");
        return o;
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        try {
            this.status = 0.0f;
            this.config = Transformations.restoreConfig((String)nodeConfigurationFileObject);
            String outputFile = this.config.getParam(processOutput);
            AnalysisLogger.getLogger().info((Object)("CMSY expected output " + outputFile));
            String fileid = new File(sandboxFolder, "WKLIFE4ID.csv").getAbsolutePath();
            String filestock = new File(sandboxFolder, "WKLIFE4Stocks.csv").getAbsolutePath();
            StorageUtils.downloadInputFile(this.config.getParam(idsFile), fileid);
            StorageUtils.downloadInputFile(this.config.getParam(stocksFile), filestock);
            AnalysisLogger.getLogger().debug((Object)("Check fileID: " + fileid + " " + new File(fileid).exists()));
            AnalysisLogger.getLogger().debug((Object)("Check fileStocks: " + filestock + " " + new File(filestock).exists()));
            RScriptsManager scriptmanager = new RScriptsManager();
            HashMap<String, String> codeinj = new HashMap<String, String>();
            codeinj.put("HLH_M07", this.config.getParam(stock));
            this.config.setConfigPath("./");
            scriptmanager.executeRScript(this.config, scriptName, "", new HashMap<String, String>(), "", "outputfile.txt", codeinj, true, false, false, sandboxFolder);
            this.outputFileName = scriptmanager.getCurrentOutputFileName();
            String outputFilePath = new File(sandboxFolder, outputFile).getAbsolutePath();
            AnalysisLogger.getLogger().info((Object)("CMSY writing output file in path " + outputFilePath));
            OSCommand.FileCopy(this.outputFileName, outputFilePath);
            AnalysisLogger.getLogger().info((Object)("CMSY uploading output file " + outputFile));
            StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), sandboxFolder, outputFile);
            AnalysisLogger.getLogger().info((Object)"CMSY Finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.config = config;
        AnalysisLogger.getLogger().info((Object)"CMSY process is initialized");
        config.setParam(processOutput, "CMSY_output_" + (UUID.randomUUID() + ".txt").replace("-", ""));
    }

    public int getNumberOfRightElements() {
        return 1;
    }

    public int getNumberOfLeftElements() {
        return 1;
    }

    public void stop() {
        AnalysisLogger.getLogger().info((Object)"CMSY process stopped");
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        try {
            String filename = this.config.getParam(processOutput);
            StorageUtils.downloadFilefromStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), this.config.getPersistencePath(), filename);
            AnalysisLogger.getLogger().debug((Object)("CMSY - Got file from Storage: " + filename));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

