/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.io.FileUtils;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.ZipTools;
import org.gcube.dataanalysis.executor.util.DataTransferer;
import org.gcube.dataanalysis.executor.util.InfraRetrieval;

public class WebApplicationPublisher
extends StandardLocalExternalAlgorithm {
    private static String FileParam = "ZipFile";
    private String transferServiceAddress = "";
    private int transferServicePort = 0;

    public String getDescription() {
        return "This algorithm publishes a zip file containing a Web site, based on html and javascript in the e-Infrastructure. It generates a public URL to the application that can be shared.";
    }

    public void init() throws Exception {
    }

    protected void process() throws Exception {
        String uuid = "webpub_" + UUID.randomUUID();
        File folder = new File(this.config.getConfigPath(), uuid);
        try {
            this.status = 10.0f;
            String scope = this.config.getGcubeScope();
            String username = this.config.getParam("ServiceUserName");
            String fileAbsolutePath = this.config.getParam(FileParam);
            AnalysisLogger.getLogger().debug((Object)("scope: " + scope));
            AnalysisLogger.getLogger().debug((Object)("username: " + username));
            AnalysisLogger.getLogger().debug((Object)("fileAbsolutePath: " + fileAbsolutePath));
            if (scope == null || username == null) {
                throw new Exception("Service parameters are not set - please contact the Administrators");
            }
            if (fileAbsolutePath == null || fileAbsolutePath.trim().length() == 0) {
                throw new Exception("No file has been provided to the process");
            }
            File f = new File(fileAbsolutePath);
            String fileName = f.getName();
            AnalysisLogger.getLogger().debug((Object)("Package is in file " + fileName));
            boolean mkdir = folder.mkdir();
            AnalysisLogger.getLogger().debug((Object)("Sandbox " + folder.getAbsolutePath() + " generated: " + mkdir));
            AnalysisLogger.getLogger().debug((Object)("Unzipping package into " + folder.getAbsolutePath()));
            ZipTools.unZip((String)f.getAbsolutePath(), (String)folder.getAbsolutePath());
            AnalysisLogger.getLogger().debug((Object)"Package unzipped and original file deleted");
            File[] webappfiles = folder.listFiles();
            String prefix = "/" + folder.getName() + "/";
            Map<String, String> allfiles = this.getFilesPaths(webappfiles, prefix);
            this.getTransferInfo(this.config.getGcubeScope());
            String remoteFolder = "/var/www/html";
            int nfiles = allfiles.size();
            float step = 80.0f / (float)nfiles;
            float initialStatus = this.status;
            int i = 0;
            for (String key : allfiles.keySet()) {
                this.status = (float)MathFunctions.roundDecimal((double)(initialStatus + (float)i * step), (int)2);
                String subpath = allfiles.get(key);
                subpath = subpath.substring(0, subpath.lastIndexOf("/"));
                String remotePath = remoteFolder + subpath + "/";
                AnalysisLogger.getLogger().debug((Object)("Uploading " + key + " -> " + remotePath));
                boolean transferout = DataTransferer.transferFileToService(scope, username, this.transferServiceAddress, this.transferServicePort, key, remotePath);
                if (!transferout) {
                    throw new Exception("Error transferring files to the infrastructure ");
                }
                ++i;
            }
            String producedPage = "http://" + this.transferServiceAddress + "/" + uuid + "/";
            if (webappfiles.length == 1 && webappfiles[0].isDirectory()) {
                producedPage = producedPage + webappfiles[0].getName() + "/";
            }
            AnalysisLogger.getLogger().debug((Object)("Entry point of the page " + producedPage));
            this.addOutputString("Generated Website - Main URL", producedPage);
        }
        catch (Exception e) {
            e.printStackTrace();
            AnalysisLogger.getLogger().debug((Object)e);
            AnalysisLogger.getLogger().debug((Object)"An error occurred!");
            throw e;
        }
        finally {
            if (folder.exists()) {
                AnalysisLogger.getLogger().debug((Object)("Cleaning folder " + folder));
                FileUtils.cleanDirectory((File)folder);
                FileUtils.deleteDirectory((File)folder);
            }
        }
        AnalysisLogger.getLogger().debug((Object)"Process finished");
        this.status = 100.0f;
    }

    private Map<String, String> getFilesPaths(File[] toexplore, String prefix) {
        HashMap<String, String> toreturn = new HashMap<String, String>();
        for (File toex : toexplore) {
            if (toex.isDirectory()) {
                toreturn.putAll(this.getFilesPaths(toex.listFiles(), prefix + toex.getName() + "/"));
                continue;
            }
            toreturn.put(toex.getAbsolutePath(), prefix + toex.getName());
        }
        return toreturn;
    }

    protected void setInputParameters() {
        this.inputs.add(new PrimitiveType(File.class.getName(), null, PrimitiveTypes.FILE, FileParam, "Zip file containing the Web site"));
        this.inputs.add(new ServiceType(ServiceParameters.USERNAME, "ServiceUserName", "The final user Name"));
    }

    public void shutdown() {
        AnalysisLogger.getLogger().debug((Object)"WebApplicationPublisher - shutdown");
    }

    public void getTransferInfo(String scope) throws Exception {
        List<String> apacheAddress = InfraRetrieval.retrieveServiceAddress("Application", "Apache Server", scope, "Transect");
        if (apacheAddress.size() == 0) {
            throw new Exception("Apache Server resource is not available in scope " + scope);
        }
        String apacheServiceAddress = apacheAddress.get(0);
        apacheServiceAddress = apacheServiceAddress.substring(apacheServiceAddress.indexOf("http://") + 7);
        AnalysisLogger.getLogger().debug((Object)("Found " + apacheAddress.size() + " services"));
        AnalysisLogger.getLogger().debug((Object)("Apache address: " + apacheServiceAddress));
        List<String> dataTransferAddress = InfraRetrieval.retrieveService("agent-service", scope);
        if (dataTransferAddress.size() == 0) {
            throw new Exception("Data Transfer services are not available in scope " + scope);
        }
        AnalysisLogger.getLogger().debug((Object)("Found " + dataTransferAddress.size() + " transfer services"));
        int apacheDTPort = 9090;
        boolean found = false;
        for (String datatransferservice : dataTransferAddress) {
            AnalysisLogger.getLogger().debug((Object)"Transfer service found");
            datatransferservice = datatransferservice.substring(datatransferservice.indexOf("http://") + 7);
            String servicehost = datatransferservice.substring(0, datatransferservice.indexOf(":"));
            String serviceport = datatransferservice.substring(datatransferservice.indexOf(":") + 1, datatransferservice.indexOf("/"));
            AnalysisLogger.getLogger().debug((Object)("Transfer service: " + servicehost + ":" + serviceport));
            if (!apacheServiceAddress.equals(servicehost)) continue;
            apacheDTPort = Integer.parseInt(serviceport);
            found = true;
            break;
        }
        if (!found) {
            throw new Exception("Apache data transfer has not been found in the same scope of the catalog: " + scope);
        }
        AnalysisLogger.getLogger().debug((Object)("Transfer service found at address " + apacheServiceAddress + ":" + apacheDTPort));
        this.transferServiceAddress = apacheServiceAddress;
        this.transferServicePort = apacheDTPort;
    }
}

