/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherInput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.abstracts.MatcherOutput;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.interfaces.Matcher;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.interfaces.Parser;
import org.gcube.dataanalysis.executor.nodes.transducers.bionym.interfaces.PostProcessor;

public abstract class GenericWorkflow {
    protected HashMap<String, String> globalparameters;
    protected String sandboxFolder;
    protected Parser parser;
    protected List<Matcher> matchersList;
    protected PostProcessor postprocessor;

    public List<Matcher> getMatchersList() {
        return this.matchersList;
    }

    public void init(HashMap<String, String> globalparameters) {
        this.globalparameters = globalparameters;
    }

    public GenericWorkflow(String sandboxFolder, HashMap<String, String> globalparameters) {
        this.globalparameters = globalparameters;
        this.sandboxFolder = sandboxFolder;
        this.matchersList = new ArrayList<Matcher>();
        this.init(globalparameters);
    }

    protected abstract MatcherOutput mergeOutputs(List<MatcherOutput> var1);

    public MatcherOutput executeChainedWorkflow(List<String> rawentries) throws Exception {
        long t0 = System.currentTimeMillis();
        this.parser.init(this.sandboxFolder, this.globalparameters);
        System.out.println("Parsing..");
        MatcherInput currentInput = this.parser.parse(rawentries);
        System.out.println("Parsed - Time: " + (System.currentTimeMillis() - t0));
        ArrayList<MatcherOutput> outputs = new ArrayList<MatcherOutput>();
        System.out.println("Matching..");
        for (Matcher matcher : this.matchersList) {
            MatcherOutput currentoutput = new MatcherOutput();
            if (currentoutput == null) continue;
            long t1 = System.currentTimeMillis();
            System.out.println("Matching with .." + matcher);
            currentoutput = matcher.match(currentInput);
            outputs.add(currentoutput);
            System.out.println("Matched - Time: " + (System.currentTimeMillis() - t1));
        }
        System.out.println("Merging..");
        long t2 = System.currentTimeMillis();
        MatcherOutput finaloutput = this.mergeOutputs(outputs);
        System.out.println("Merged - Time: " + (System.currentTimeMillis() - t2));
        if (this.postprocessor != null) {
            long t3 = System.currentTimeMillis();
            System.out.println("Postprocessing..");
            finaloutput = this.postprocessor.postprocessMatches(finaloutput);
            System.out.println("Postprocessed - Time: " + (System.currentTimeMillis() - t3));
        }
        System.out.println("END.");
        return finaloutput;
    }

    public void resetMatchers(List<Matcher> newmatchers) {
        this.matchersList = null;
        this.matchersList = newmatchers;
    }
}

