/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.nodes.algorithms;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.interfaces.ActorNode;
import org.gcube.dataanalysis.ecoengine.utils.IOHelper;
import org.gcube.dataanalysis.ecoengine.utils.Transformations;
import org.gcube.dataanalysis.ecoengine.utils.ZipTools;
import org.gcube.dataanalysis.executor.scripts.OSCommand;
import org.gcube.dataanalysis.executor.util.RScriptsManager;
import org.gcube.dataanalysis.executor.util.StorageUtils;

public class ICCATVPA
extends ActorNode {
    protected static String YearStartInp = "StartYear";
    protected static String YearEndInp = "EndYear";
    protected static String CAAInp = "CAAFile";
    protected static String PCAAInp = "PCAAFile";
    protected static String CPUEInp = "CPUEFile";
    protected static String PwaaInp = "PwaaFile";
    protected static String waaInp = "waaFile";
    protected String CAAInpURL;
    protected String PCAAInpURL;
    protected String CPUEInpURL;
    protected String PwaaInpURL;
    protected String waaInpURL;
    protected static String effectInp = "shortComment";
    protected static String nCPUEInp = "nCPUE";
    protected static String CPUEcutInp = "CPUE_cut";
    protected static String nRemoveYearInp = "n_remove_year";
    protected static String agePlusGroupInp = "age_plus_group";
    protected static String scriptName = "run_vpa.R";
    protected static String packageURL = "http://goo.gl/EqFjNZ";
    protected static String processOutputParam = "ProcessOutputParam";
    protected String processOutput = "ProcessOutput";
    protected AlgorithmConfiguration config;
    public float status = 0.0f;
    int nExperiments = 1;
    boolean haspostprocessed = false;

    public ALG_PROPS[] getProperties() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public String getName() {
        return "ICCAT_VPA";
    }

    public String getDescription() {
        return "An algorithm for stock assessment of catch statistics published by the International Commission for the Conservation of Atlantic Tunas (ICCAT).  Produces summary statistics about a stock, involving assessment of fishing mortality, abundance, catch trend,  fecundity and recruitment. Developed by IFREMER and IRD. Contact persons: Sylvain Bonhommeau sylvain.bonhommeau@ifremer.fr,  Julien Barde julien.barde@ird.fr.";
    }

    public List<StatisticalType> getInputParameters() {
        ArrayList<StatisticalType> parameters = new ArrayList<StatisticalType>();
        IOHelper.addIntegerInput(parameters, (String)YearStartInp, (String)"First year of the dataset temporal extent", (String)"1950");
        IOHelper.addIntegerInput(parameters, (String)YearEndInp, (String)"Last year of the dataset temporal extent", (String)"2013");
        IOHelper.addFileInput(parameters, (String)CAAInp, (String)"Catch at Age Matrix (Number of Fish caught by year and for each age)", (String)"CAA_Age1_25.csv");
        IOHelper.addFileInput(parameters, (String)PCAAInp, (String)"Partial Catch at Age Matrix (Number of Fish caught by gear and year and for each age)", (String)"PCAA_Age1_25.csv");
        IOHelper.addFileInput(parameters, (String)CPUEInp, (String)"Table of Catch Per Unit of Effort used in the stock assessment", (String)"CPUE.csv");
        IOHelper.addFileInput(parameters, (String)PwaaInp, (String)"Partial weight at age (Weight of Fish caught by gear and year and for each age)", (String)"waa.csv");
        IOHelper.addFileInput(parameters, (String)waaInp, (String)"Fecundity at age (Fecundity of Fish caught by year and for each age)", (String)"fecaa.csv");
        IOHelper.addStringInput(parameters, (String)effectInp, (String)"Free text for users to describe the current simulation", (String)" ");
        IOHelper.addIntegerInput(parameters, (String)nCPUEInp, (String)"Number of Catch Per Unit of Effort Time series to use", (String)"7");
        IOHelper.addIntegerInput(parameters, (String)CPUEcutInp, (String)"Identifier of the Catch Per Unit of Effort Time Serie to be shrunk", (String)"1");
        IOHelper.addIntegerInput(parameters, (String)nRemoveYearInp, (String)"Number of the (last) years to be removed", (String)"1");
        IOHelper.addIntegerInput(parameters, (String)agePlusGroupInp, (String)"Maximal age class of catches to be taken into account", (String)"10");
        return parameters;
    }

    public void setup(AlgorithmConfiguration config) throws Exception {
        this.config = config;
        AnalysisLogger.getLogger().info((Object)("ICCAT-VPA process is initialized in scope " + config.getGcubeScope() + " for user " + config.getParam("ServiceUserName")));
        String uuid = ("" + UUID.randomUUID()).replace("-", "");
        this.processOutput = "ICCAT-VPA_output_" + uuid + ".zip";
        config.setParam(processOutputParam, this.processOutput);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA Uploading input files (http): " + config.getGeneralProperties()));
        this.CAAInpURL = StorageUtils.uploadFilesOnStorage(config.getGcubeScope(), config.getParam("ServiceUserName"), new File(config.getParam(CAAInp)).getParent(), "/", new File(config.getParam(CAAInp)).getName(), true);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA: CAA DONE! " + this.CAAInpURL));
        this.PCAAInpURL = StorageUtils.uploadFilesOnStorage(config.getGcubeScope(), config.getParam("ServiceUserName"), new File(config.getParam(PCAAInp)).getParent(), "/", new File(config.getParam(PCAAInp)).getName(), true);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA: PCAA DONE! " + this.PCAAInpURL));
        this.CPUEInpURL = StorageUtils.uploadFilesOnStorage(config.getGcubeScope(), config.getParam("ServiceUserName"), new File(config.getParam(CPUEInp)).getParent(), "/", new File(config.getParam(CPUEInp)).getName(), true);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA: CPUE DONE! " + this.CPUEInpURL));
        this.PwaaInpURL = StorageUtils.uploadFilesOnStorage(config.getGcubeScope(), config.getParam("ServiceUserName"), new File(config.getParam(PwaaInp)).getParent(), "/", new File(config.getParam(PwaaInp)).getName(), true);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA: Pwaa DONE! " + this.PwaaInpURL));
        this.waaInpURL = StorageUtils.uploadFilesOnStorage(config.getGcubeScope(), config.getParam("ServiceUserName"), new File(config.getParam(waaInp)).getParent(), "/", new File(config.getParam(waaInp)).getName(), true);
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA: waa DONE! " + this.waaInpURL));
        AnalysisLogger.getLogger().debug((Object)"ICCAT-VPA Input files uploaded!");
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA Setting input URLs: " + config.getGeneralProperties()));
        config.setParam(CAAInp, this.CAAInpURL);
        config.setParam(PCAAInp, this.PCAAInpURL);
        config.setParam(CPUEInp, this.CPUEInpURL);
        config.setParam(PwaaInp, this.PwaaInpURL);
        config.setParam(waaInp, this.waaInpURL);
    }

    public StatisticalType getOutput() {
        File outfile = new File(this.processOutput);
        LinkedHashMap<String, PrimitiveType> outputmap = new LinkedHashMap<String, PrimitiveType>();
        AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA Output: " + outfile.getAbsolutePath() + " : " + outfile.exists()));
        if (!outfile.exists()) {
            AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA Output file " + this.processOutput + " does not exist - returning null "));
            return null;
        }
        PrimitiveType o = new PrimitiveType(File.class.getName(), (Object)outfile, PrimitiveTypes.FILE, "ProcessSummary", "Output file containing the process summary");
        outputmap.put("Zip file containing the process output", o);
        PrimitiveType output = new PrimitiveType(HashMap.class.getName(), outputmap, PrimitiveTypes.MAP, "Results File", "Results File");
        AnalysisLogger.getLogger().debug((Object)"ICCAT-VPA Output Managed");
        return output;
    }

    public void initSingleNode(AlgorithmConfiguration config) {
    }

    public float getInternalStatus() {
        return this.status;
    }

    public int executeNode(int leftStartIndex, int numberOfLeftElementsToProcess, int rightStartIndex, int numberOfRightElementsToProcess, boolean duplicate, String sandboxFolder, String nodeConfigurationFileObject, String logfileNameToProduce) {
        try {
            this.status = 0.0f;
            this.config = Transformations.restoreConfig((String)nodeConfigurationFileObject);
            String outputFile = this.config.getParam(processOutputParam);
            String localzipFile = "iccat_zip.zip";
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA ranges:  Li:" + leftStartIndex + " NLi:" + leftStartIndex + " Ri:" + rightStartIndex + " NRi:" + numberOfRightElementsToProcess));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA expected output " + outputFile));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : downloading package URL: " + packageURL));
            StorageUtils.downloadInputFile(packageURL, localzipFile, true);
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : Unzipping file: " + localzipFile + " having size " + new File(localzipFile).length()));
            ZipTools.unZip((String)localzipFile, (String)sandboxFolder);
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : Downloading remote input files " + this.config.getGeneralProperties()));
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Downloading  CAA");
            StorageUtils.downloadInputFile(this.config.getParam(CAAInp), "CAA_Age1_25.csv", true);
            StorageUtils.downloadInputFile(this.config.getParam(PCAAInp), "PCAA_Age1_25_Run3.csv", true);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Downloading  PCAA");
            StorageUtils.downloadInputFile(this.config.getParam(CPUEInp), "CPUE_Run3.csv", true);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Downloading  CPUE");
            StorageUtils.downloadInputFile(this.config.getParam(PwaaInp), "waa.csv", true);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Downloading  Pwaa");
            StorageUtils.downloadInputFile(this.config.getParam(waaInp), "fecaa.csv", true);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Downloading  waa");
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : all files downloaded: ");
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : CCA size: " + new File("CAA_Age1_25.csv")));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : PCAA size: " + new File("PCAA_Age1_25_Run3.csv")));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : CPUE size: " + new File("CPUE_Run3.csv")));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : Pwaa size: " + new File("waa.csv")));
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : waa size: " + new File("fecaa.csv")));
            String run = "Run_" + rightStartIndex;
            String header = "Run,Year,CAA,PCAA,CPUE,Pwaa,waa,compare to,effect,nCPUE,CPUE_cut,n_remove_year,age_plus_group";
            String input = String.valueOf(run) + "," + this.config.getParam(YearStartInp) + "-" + this.config.getParam(YearEndInp) + "," + "CAA_Age1_25.csv" + "," + "PCAA_Age1_25_Run3.csv" + "," + "CPUE_Run3.csv" + "," + "waa.csv" + "," + "fecaa.csv" + ",," + this.config.getParam(effectInp) + "," + this.config.getParam(nCPUEInp) + "," + this.config.getParam(CPUEcutInp) + "," + this.config.getParam(nRemoveYearInp) + "," + this.config.getParam(agePlusGroupInp);
            FileWriter fw = new FileWriter(new File(sandboxFolder, "run_spec.csv"));
            fw.write(String.valueOf(header) + "\n");
            fw.write(String.valueOf(input) + "\n");
            fw.close();
            HashMap<String, String> codeinj = new HashMap<String, String>();
            codeinj.put("Run_0", run);
            String pathSand = new File(sandboxFolder).getAbsolutePath();
            if (!pathSand.endsWith("/")) {
                pathSand = String.valueOf(pathSand) + "/";
            }
            AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA : substituting path to sandbox folder " + pathSand));
            codeinj.put("/home/gcube/irdstockassessment/allinone/", pathSand);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : changing rights to the fortran file");
            OSCommand.ExecuteGetLine("chmod 777 vpa-2box.out", null);
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : running the script: " + scriptName));
            RScriptsManager scriptmanager = new RScriptsManager();
            scriptmanager.executeRScript(this.config, scriptName, "", new HashMap<String, String>(), "", "output.csv", codeinj, false, false, false, sandboxFolder);
            File outputFolder = new File(sandboxFolder, run);
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : checking the output folder: " + outputFolder.getAbsolutePath() + " exists: " + outputFolder.exists()));
            if (!outputFolder.exists()) {
                throw new Exception("ICCAT-VPA: output was not produced!");
            }
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : producing zip output: " + outputFile));
            ZipTools.zipFolder((String)new File(sandboxFolder, run).getAbsolutePath(), (String)outputFile);
            AnalysisLogger.getLogger().info((Object)("ICCAT-VPA : zip output exists: " + new File(outputFile).exists()));
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : uploading on storage");
            StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), sandboxFolder, outputFile);
            AnalysisLogger.getLogger().info((Object)"ICCAT-VPA : Finished");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int getNumberOfRightElements() {
        return 1;
    }

    public int getNumberOfLeftElements() {
        return 1;
    }

    public void stop() {
        AnalysisLogger.getLogger().info((Object)"ICCAT-VPA process stopped");
    }

    public void postProcess(boolean manageDuplicates, boolean manageFault) {
        try {
            AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA - Downloading file " + this.processOutput));
            StorageUtils.downloadFilefromStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), this.config.getPersistencePath(), this.processOutput);
            File of = new File(this.config.getPersistencePath(), this.processOutput);
            int i = 0;
            while (i < 3) {
                if (of.exists()) break;
                Thread.sleep(1000L);
                ++i;
            }
            if (of.exists()) {
                AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA - Postprocess complete: output ready in " + of.getAbsolutePath()));
                this.processOutput = of.getAbsolutePath();
            } else {
                AnalysisLogger.getLogger().debug((Object)("ICCAT-VPA - Warning Postprocess error - output does not exist ! " + of.getAbsolutePath()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

