/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.rscripts.generic;

import java.io.File;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.UUID;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.StandardLocalExternalAlgorithm;
import org.gcube.dataanalysis.ecoengine.utils.ZipTools;
import org.gcube.dataanalysis.executor.rscripts.generic.FileUtils;
import org.gcube.dataanalysis.executor.util.LocalRScriptsManager;
import org.gcube.dataanalysis.executor.util.StorageUtils;

public abstract class GenericRScript
extends StandardLocalExternalAlgorithm {
    protected HashMap<String, String> outputValues = new HashMap();
    protected LinkedHashMap<String, StatisticalType> output = new LinkedHashMap();
    LocalRScriptsManager scriptmanager;
    protected String mainScriptName = "";
    protected String packageURL = "";
    protected List<String> environmentalvariables = new ArrayList<String>();
    protected List<String> inputvariables = new ArrayList<String>();
    protected List<String> outputvariables = new ArrayList<String>();

    public void shutdown() {
        if (this.scriptmanager != null) {
            this.scriptmanager.stop();
        }
        System.gc();
    }

    public void init() throws Exception {
        AnalysisLogger.getLogger().debug((Object)("Initializing " + ((Object)((Object)this)).getClass().getCanonicalName()));
        this.initVariables();
    }

    protected void process() throws Exception {
        boolean deletefiles = true;
        String Rlog = null;
        this.status = 0.0f;
        try {
            try {
                this.scriptmanager = new LocalRScriptsManager();
                AnalysisLogger.getLogger().debug((Object)"Starting script");
                File localPackage = new File(this.config.getConfigPath(), "package" + UUID.randomUUID() + ".zip");
                AnalysisLogger.getLogger().debug((Object)("Downloading package " + this.packageURL + "as: " + localPackage.getAbsolutePath()));
                StorageUtils.downloadInputFile(this.packageURL, localPackage.getAbsolutePath(), true);
                AnalysisLogger.getLogger().debug((Object)"Generating sandbox folder");
                File folder = new File(this.config.getConfigPath(), "rscr_" + UUID.randomUUID());
                boolean mkdir = folder.mkdir();
                AnalysisLogger.getLogger().debug((Object)("Sandbox " + folder.getAbsolutePath() + " generated: " + mkdir));
                AnalysisLogger.getLogger().debug((Object)("Unzipping package into " + folder.getAbsolutePath()));
                ZipTools.unZip((String)localPackage.getAbsolutePath(), (String)folder.getAbsolutePath());
                localPackage.delete();
                AnalysisLogger.getLogger().debug((Object)"Analysing inputs");
                LinkedHashMap<String, String> inputParameters = new LinkedHashMap<String, String>();
                int i = 0;
                List inputs = this.getInputParameters();
                for (String input : this.inputvariables) {
                    String value = this.config.getParam(input);
                    String defaultValue = ((StatisticalType)inputs.get(i)).getDefaultValue();
                    defaultValue = defaultValue.replace("(", "\\(").replace(")", "\\)").replace("[", "\\[").replace("]", "\\]").replace("|", "\\|").replace(".", "\\.").replace("?", "\\?").replace("*", "\\*").replace("+", "\\+").replace("{", "\\{").replace("}", "\\}");
                    String punct = "[ \t\";]*";
                    String regexp = String.valueOf(punct) + input + punct + "(<-|=)" + punct + defaultValue + punct + ".*";
                    boolean string = true;
                    try {
                        Double.parseDouble(value);
                        string = false;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String line = String.valueOf(input) + "=" + (String)value;
                    if (!(!string || value.equals("T") || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("false") || value.equalsIgnoreCase("F"))) {
                        line = String.valueOf(input) + "=\"" + (String)value + "\"";
                    }
                    inputParameters.put(regexp, line);
                    ++i;
                }
                AnalysisLogger.getLogger().debug((Object)("Inputs: " + inputParameters.toString()));
                AnalysisLogger.getLogger().debug((Object)"Analysing environmental variables");
                LinkedHashMap<String, String> environmentalParameters = new LinkedHashMap<String, String>();
                for (String environment : this.environmentalvariables) {
                    String value = this.config.getParam(environment);
                    environmentalParameters.put(environment, value);
                }
                AnalysisLogger.getLogger().debug((Object)("Environmental: " + environmentalParameters.toString()));
                AnalysisLogger.getLogger().debug((Object)"Analysing output variables");
                LinkedHashMap<String, String> outputParameters = new LinkedHashMap<String, String>();
                for (String output : this.outputvariables) {
                    outputParameters.put(output, "");
                }
                AnalysisLogger.getLogger().debug((Object)("Output: " + outputParameters.toString()));
                AnalysisLogger.getLogger().debug((Object)("Main script: " + this.mainScriptName));
                AnalysisLogger.getLogger().debug((Object)"Processing main script name");
                String scriptName = this.mainScriptName;
                String scriptSubfolder = "";
                int lioSlash = scriptName.lastIndexOf("/");
                if (lioSlash > -1) {
                    scriptSubfolder = scriptName.substring(0, lioSlash);
                    scriptName = scriptName.substring(lioSlash + 1);
                }
                scriptSubfolder = new File(folder.getAbsoluteFile(), scriptSubfolder).getAbsolutePath();
                AnalysisLogger.getLogger().debug((Object)("Main script name: " + scriptName));
                AnalysisLogger.getLogger().debug((Object)("Main script folder: " + scriptSubfolder));
                boolean scriptMustReturnAFile = false;
                boolean uploadScriptOnTheInfrastructureWorkspace = false;
                this.status = 10.0f;
                AnalysisLogger.getLogger().debug((Object)"Executing the script...");
                Rlog = this.scriptmanager.executeRScript(this.config, scriptName, null, environmentalParameters, outputParameters, null, null, inputParameters, scriptMustReturnAFile, uploadScriptOnTheInfrastructureWorkspace, deletefiles, scriptSubfolder);
                AnalysisLogger.getLogger().debug((Object)"..execution finished!");
                AnalysisLogger.getLogger().debug((Object)"Getting output");
                for (String output : this.outputvariables) {
                    File outPath = new File(scriptSubfolder, output);
                    AnalysisLogger.getLogger().debug((Object)("Output " + output + " - loading respective file from " + outPath.getAbsolutePath()));
                    AnalysisLogger.getLogger().debug((Object)("File exists? " + outPath.exists()));
                    String fileContent = FileTools.loadString((String)outPath.getAbsolutePath(), (String)"UTF-8");
                    fileContent = this.analyseContent(fileContent, scriptSubfolder);
                    AnalysisLogger.getLogger().debug((Object)("Retrieved output content: " + output + ": " + fileContent));
                    this.outputValues.put(output, fileContent);
                }
                try {
                    if (deletefiles) {
                        AnalysisLogger.getLogger().debug((Object)"Deleting sandbox folder");
                        org.apache.commons.io.FileUtils.cleanDirectory((File)folder);
                        org.apache.commons.io.FileUtils.deleteDirectory((File)folder);
                        AnalysisLogger.getLogger().debug((Object)("Folder " + folder.getAbsolutePath() + " deleted"));
                    }
                }
                catch (Exception e) {
                    AnalysisLogger.getLogger().debug((Object)e);
                    AnalysisLogger.getLogger().debug((Object)("Could not delete sandbox folder " + folder.getAbsolutePath()));
                }
            }
            catch (Exception e) {
                if (Rlog != null) {
                    String httpurl = this.generateRemoteLogFile(Rlog);
                    String message = "Logs of the script can be found at " + httpurl;
                    e = new Exception(message);
                }
                throw e;
            }
        }
        finally {
            AnalysisLogger.getLogger().debug((Object)"Computation finished.");
            this.status = 100.0f;
        }
    }

    protected String generateRemoteLogFile(String Rlog) throws Exception {
        String uuid = "" + UUID.randomUUID();
        AnalysisLogger.getLogger().debug((Object)"Writing the logs of the execution");
        File logfile = new File(this.config.getPersistencePath(), "RLOG" + uuid + ".txt");
        FileWriter fw = new FileWriter(logfile);
        fw.write(Rlog);
        fw.close();
        AnalysisLogger.getLogger().debug((Object)("Written in " + logfile));
        String httpurl = StorageUtils.uploadFilesOnStorage(this.config.getGcubeScope(), this.config.getParam("ServiceUserName"), logfile.getParent(), "/ScriptLogs/" + uuid + "/", logfile.getName(), true);
        AnalysisLogger.getLogger().debug((Object)("Uploaded on storage: " + httpurl));
        AnalysisLogger.getLogger().debug((Object)("Deleting log file and returning " + httpurl));
        logfile.delete();
        return httpurl;
    }

    protected String analyseContent(String filecontent, String scriptfolder) throws Exception {
        AnalysisLogger.getLogger().debug((Object)"Analysing file content");
        String[] rows = filecontent.split(System.lineSeparator());
        ArrayList<String> files = new ArrayList<String>();
        String[] stringArray = rows;
        int n = rows.length;
        int n2 = 0;
        while (n2 < n) {
            String row = stringArray[n2];
            AnalysisLogger.getLogger().debug((Object)("Analysing -> " + row));
            if (row != null) {
                row = row.replace("\"", "");
                File rowFile = new File(row.trim());
                AnalysisLogger.getLogger().debug((Object)("Checking row file-> " + rowFile.getAbsolutePath()));
                if (!rowFile.exists()) {
                    rowFile = new File(scriptfolder, row.trim());
                    AnalysisLogger.getLogger().debug((Object)("File does not exist - checking complete row file-> " + rowFile.getAbsolutePath()));
                }
                if (rowFile.exists()) {
                    String preparedFile = new File(this.config.getConfigPath(), rowFile.getName()).getAbsolutePath();
                    AnalysisLogger.getLogger().debug((Object)("Copying " + rowFile.getAbsolutePath() + " to " + preparedFile));
                    try {
                        FileUtils.moveFileToDirectory(rowFile, new File(this.config.getConfigPath()), false);
                        files.add(preparedFile);
                        break;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        AnalysisLogger.getLogger().debug((Object)("error in moving file " + rowFile.getAbsolutePath() + " to " + preparedFile));
                        AnalysisLogger.getLogger().debug((Object)e);
                        throw e;
                    }
                }
                AnalysisLogger.getLogger().debug((Object)"Checking row file does not exist - treating as a String");
            }
            ++n2;
        }
        if (files.size() > 0) {
            AnalysisLogger.getLogger().debug((Object)"A File was recognized as output");
            return (String)files.get(0);
        }
        AnalysisLogger.getLogger().debug((Object)"A String was recognized as output");
        return filecontent;
    }

    protected void initVariables() {
    }

    protected void setInputParameters() {
    }

    public StatisticalType getOutput() {
        return null;
    }
}

