/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.executor.job.management;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.gcube.contentmanagement.graphtools.utils.HttpRequest;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.ResourceLoad;
import org.gcube.dataanalysis.ecoengine.connectors.livemonitor.Resources;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.gcube.dataanalysis.executor.job.management.WPSJobManager;

public class DistributedProcessingAgentWPS {
    protected WPSJobManager jobManager;
    protected boolean deletefiles = true;
    protected String mainclass;
    public int maxElementsAllowedPerJob = 20;
    protected boolean forceUpload = true;
    protected boolean stop = false;
    protected String gscope;
    protected String userName;
    protected String pathToLib;
    protected String modelName;
    protected String containerFolder;
    protected AlgorithmConfiguration configuration;
    protected int rightSetNumberOfElements;
    protected int leftSetNumberOfElements;
    protected List<String> endpoints;
    protected int subdivisiondiv;
    protected String sessionID;
    protected static String defaultJobOutput = "execution.output";
    protected static String defaultScriptFile = "script";
    protected Logger logger;
    private long lastTime;
    private int lastProcessed;

    public DistributedProcessingAgentWPS(AlgorithmConfiguration configuration, String gCubeScope, String computationOwner, String mainClass, String pathToLibFolder, String modelName, String containerFolder, int maxElementsPerJob, boolean forceReUploadofLibs, int leftSetNumberOfElements, int rightSetNumberOfElements, String sessionID) {
        this.gscope = gCubeScope;
        this.mainclass = mainClass;
        this.maxElementsAllowedPerJob = maxElementsPerJob;
        this.forceUpload = forceReUploadofLibs;
        this.configuration = configuration;
        this.rightSetNumberOfElements = rightSetNumberOfElements;
        this.leftSetNumberOfElements = leftSetNumberOfElements;
        this.userName = computationOwner;
        this.pathToLib = pathToLibFolder;
        this.modelName = modelName;
        this.containerFolder = containerFolder;
        this.sessionID = sessionID;
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public boolean hasResentMessages() {
        return this.jobManager.hasResentMessages();
    }

    public void compute() throws Exception {
        try {
            int nservices;
            if (this.logger == null) {
                this.logger = AnalysisLogger.getLogger();
            }
            if (this.gscope == null) {
                throw new Exception("Null Scope");
            }
            AnalysisLogger.getLogger().debug((Object)("SCOPE: " + this.gscope));
            this.jobManager = new WPSJobManager();
            this.subdivisiondiv = nservices = this.jobManager.estimateNumberOfServices(this.configuration.getGcubeScope());
            AnalysisLogger.getLogger().debug((Object)("Subdivision for the job " + this.subdivisiondiv));
            if (this.subdivisiondiv == 0) {
                this.subdivisiondiv = 1;
            }
            this.executeWork(this.leftSetNumberOfElements, this.rightSetNumberOfElements, 0, this.subdivisiondiv, this.deletefiles, this.forceUpload);
            AnalysisLogger.getLogger().debug((Object)"The WPS job has been completely executed");
            if (this.jobManager.wasAborted()) {
                this.logger.debug((Object)"Warning: Job was aborted");
                throw new Exception("Job System Error");
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)("The WPS job got an error " + e.getLocalizedMessage()));
            e.printStackTrace();
            throw e;
        }
        finally {
            this.shutdown();
        }
    }

    private void executeWork(int leftNum, int rightNum, int offset, int numberOfResources, boolean deletefiles, boolean forceUpload) throws Exception {
        int[] chunkSizes = Operations.takeChunks((int)rightNum, (int)numberOfResources);
        ArrayList<String> arguments = new ArrayList<String>();
        for (int i = 0; i < chunkSizes.length; ++i) {
            String argumentString = "0 " + leftNum + " " + offset + " " + chunkSizes[i];
            arguments.add(argumentString);
            offset += chunkSizes[i];
            this.logger.debug((Object)("Generator-> Argument " + i + ": " + argumentString));
        }
        this.jobManager.uploadAndExecuteChunkized(this.configuration, this.mainclass, arguments, this.sessionID);
    }

    public String getResources() {
        Resources res = new Resources();
        try {
            int activeNodes = this.jobManager.getActiveNodes();
            for (int i = 0; i < activeNodes; ++i) {
                try {
                    res.addResource("Worker_" + (i + 1), 100.0);
                    continue;
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        catch (Exception e) {
            AnalysisLogger.getLogger().debug((Object)"D4ScienceGenerator->active nodes not ready");
        }
        if (res != null && res.list != null) {
            return HttpRequest.toJSon((Object)res.list).replace("resId", "resID");
        }
        return "";
    }

    public float getStatus() {
        try {
            if (this.stop) {
                return 100.0f;
            }
            if (this.jobManager != null) {
                return Math.max(0.5f, this.jobManager.getStatus() * 100.0f);
            }
            return 0.0f;
        }
        catch (Exception e) {
            return 0.0f;
        }
    }

    public ALG_PROPS[] getSupportedAlgorithms() {
        ALG_PROPS[] p = new ALG_PROPS[]{ALG_PROPS.PHENOMENON_VS_PARALLEL_PHENOMENON};
        return p;
    }

    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.D4SCIENCE;
    }

    public void shutdown() {
        try {
            this.jobManager.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.stop = true;
    }

    public String getLoad() {
        long tk = System.currentTimeMillis();
        ResourceLoad rs = null;
        rs = this.jobManager != null ? new ResourceLoad(tk, (double)(1 * this.subdivisiondiv)) : new ResourceLoad(tk, 0.0);
        return rs.toString();
    }

    public String getResourceLoad() {
        long thisTime = System.currentTimeMillis();
        int processedRecords = 0;
        if (this.jobManager != null && this.subdivisiondiv > 0) {
            processedRecords = 1 * this.subdivisiondiv;
        }
        int estimatedProcessedRecords = 0;
        estimatedProcessedRecords = processedRecords == this.lastProcessed ? Math.round((float)thisTime * (float)this.lastProcessed / (float)this.lastTime) : (this.lastProcessed = processedRecords);
        this.lastTime = thisTime;
        ResourceLoad rs = new ResourceLoad(thisTime, (double)estimatedProcessedRecords);
        return rs.toString();
    }
}

