/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.evaluation.bioclimate;

import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.MathFunctions;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.DataTypeRecognizer;
import org.gcube.contentmanagement.lexicalmatcher.analysis.core.LexicalEngineConfiguration;
import org.gcube.contentmanagement.lexicalmatcher.utils.FileTools;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.Operations;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InterpolateTables {
    private static Logger logger = LoggerFactory.getLogger(InterpolateTables.class);
    protected String temporaryDirectory;
    public static String selectElementsQuery = "select %1$s from %2$s order by %3$s";
    public static String selectDestElementsQuery = "select %1$s from %2$s where %3$s";
    public float status;
    private String[] interpolatedTables;
    private LexicalEngineConfiguration config;
    protected SessionFactory referencedbConnection;
    private String configPath;
    private File[] producedfiles;

    public String[] getInterpolatedTables() {
        return this.interpolatedTables;
    }

    public InterpolateTables(String configPath, String persistencePath, String databaseURL, String databaseUserName, String databasePassword) throws Exception {
        this.configPath = configPath;
        this.temporaryDirectory = persistencePath;
        if (!configPath.endsWith("/")) {
            configPath = configPath + "/";
        }
        if (!persistencePath.endsWith("/")) {
            this.temporaryDirectory = this.temporaryDirectory + "/";
        }
        logger.debug("Initialization complete: persistence path " + persistencePath);
        this.config = new LexicalEngineConfiguration();
        this.config.setDatabaseURL(databaseURL);
        this.config.setDatabaseUserName(databaseUserName);
        this.config.setDatabasePassword(databasePassword);
    }

    public void interpolate(String table1, String table2, int intervals, INTERPOLATIONFUNCTIONS function, int startYear, int endYear) throws Exception {
        block20: {
            try {
                int i;
                if (intervals == 1) {
                    this.interpolatedTables = new String[2];
                    this.interpolatedTables[0] = table1;
                    this.interpolatedTables[1] = table2;
                    logger.debug("NO TABLES TO PRODUCE");
                    break block20;
                }
                this.referencedbConnection = DatabaseFactory.initDBConnection(this.configPath + AlgorithmConfiguration.defaultConnectionFile, this.config);
                logger.debug("ReferenceDB initialized");
                this.status = 0.0f;
                logger.debug("Interpolating from " + table1 + " to " + table2);
                DatabaseUtils utils = new DatabaseUtils(this.referencedbConnection);
                String createTableStatement = utils.buildCreateStatement(table1, "%1$s");
                logger.debug("Create Statement for table " + table1 + ": " + createTableStatement);
                int numberOfColumns = utils.getColumnDecriptions().size();
                ArrayList<List<StringBuffer>> outputFiles = new ArrayList<List<StringBuffer>>();
                for (int g = 0; g < intervals - 2; ++g) {
                    outputFiles.add(new ArrayList());
                }
                float statusstep = 60.0f / (float)numberOfColumns;
                for (int j = 0; j < numberOfColumns; ++j) {
                    String gotColumn = utils.getColumnName(j);
                    String gotColumnType = utils.getColumnType(j);
                    String javatype = DataTypeRecognizer.transformTypeFromDB(gotColumnType);
                    String takeF = DatabaseUtils.getOrderedElements(table1, utils.getPrimaryKey(), gotColumn);
                    String takeS = DatabaseUtils.getOrderedElements(table2, utils.getPrimaryKey(), gotColumn);
                    logger.debug("Taking First column->" + takeF);
                    logger.debug("Taking Second column->" + takeS);
                    List<Object> takeFirstColumn = DatabaseFactory.executeSQLQuery(takeF, this.referencedbConnection);
                    List<Object> takeSecondColumn = DatabaseFactory.executeSQLQuery(takeS, this.referencedbConnection);
                    logger.debug("First column elements size->" + takeFirstColumn.size());
                    logger.debug("Second column elements size->" + takeSecondColumn.size());
                    if (javatype.equals(BigDecimal.class.getName())) {
                        logger.debug("interpolating -> " + gotColumn);
                        List<List<Object>> interpolations = this.interpolateColumns(takeFirstColumn, takeSecondColumn, intervals, gotColumnType, function);
                        for (int i2 = 1; i2 < intervals - 1; ++i2) {
                            String tableInterp = table1 + "_" + i2;
                            List<Object> columnToSub = interpolations.get(i2);
                            if (columnToSub.size() > 0) {
                                logger.debug("UPDATE TABLE " + tableInterp + " ON COLUMN " + gotColumn);
                                this.addColumnToTable((List)outputFiles.get(i2 - 1), columnToSub, true);
                                continue;
                            }
                            logger.debug("DOESN'T CHANGE TABLE " + tableInterp + " COLUMN " + gotColumn);
                            this.addColumnToTable((List)outputFiles.get(i2 - 1), takeFirstColumn, true);
                        }
                    } else {
                        for (int i3 = 0; i3 < intervals - 2; ++i3) {
                            this.addColumnToTable((List)outputFiles.get(i3), takeFirstColumn, false);
                        }
                    }
                    this.status += statusstep;
                }
                this.status = 60.0f;
                logger.debug("WRITING ALL THE BUFFERS");
                this.writeAllStringBuffersToFiles(table1, outputFiles, function, startYear, endYear);
                statusstep = 40.0f / (float)this.producedfiles.length;
                this.interpolatedTables = new String[this.producedfiles.length + 2];
                this.interpolatedTables[0] = table1;
                for (i = 0; i < this.producedfiles.length; ++i) {
                    String filename = this.producedfiles[i].getName();
                    this.interpolatedTables[i + 1] = filename = filename.substring(0, filename.lastIndexOf(".")).replace(" ", "");
                    logger.debug("CREATING TABLE->" + filename);
                    DatabaseFactory.executeSQLUpdate(String.format(createTableStatement, filename), this.referencedbConnection);
                    logger.debug("COPYING TABLE->" + filename);
                    DatabaseUtils.createRemoteTableFromFile(this.producedfiles[i].getAbsolutePath(), filename, ";", false, this.config.getDatabaseUserName(), this.config.getDatabasePassword(), this.config.getDatabaseURL());
                    this.status = Math.min(this.status + statusstep, 99.0f);
                }
                logger.debug("DELETING ALL TEMPORARY FILES");
                for (i = 0; i < this.producedfiles.length; ++i) {
                    this.producedfiles[i].delete();
                }
                this.interpolatedTables[this.interpolatedTables.length - 1] = table2;
                logger.debug("ALL TABLES HAVE BEEN PRODUCED");
            }
            catch (Exception e) {
                e.printStackTrace();
                throw e;
            }
            finally {
                if (this.referencedbConnection != null) {
                    try {
                        this.referencedbConnection.close();
                    }
                    catch (Exception exception) {}
                }
                this.status = 100.0f;
            }
        }
    }

    public float getStatus() {
        return this.status;
    }

    private void addColumnToTable(List<StringBuffer> rows, List<Object> elements, boolean isNumber) {
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            Object[] couple = (Object[])elements.get(i);
            String value = "" + couple[1];
            StringBuffer buffer = null;
            if (i >= rows.size()) {
                buffer = new StringBuffer();
                if (isNumber && value == null || value.length() == 0) {
                    buffer.append("0");
                } else {
                    buffer.append(value);
                }
                rows.add(buffer);
                continue;
            }
            buffer = rows.get(i);
            buffer.append(";" + value);
        }
    }

    private void writeAllStringBuffersToFiles(String initialFile, List<List<StringBuffer>> outputFiles, INTERPOLATIONFUNCTIONS function, int startYear, int endYear) throws Exception {
        int numOfFiles = outputFiles.size();
        int yearStep = (int)((float)(endYear - startYear) / (float)(numOfFiles + 1));
        this.producedfiles = new File[numOfFiles];
        for (int i = 0; i < numOfFiles; ++i) {
            List<StringBuffer> rows = outputFiles.get(i);
            StringBuffer completeFile = new StringBuffer();
            int nrows = rows.size();
            for (int k = 0; k < nrows; ++k) {
                completeFile.append(rows.get(k) + "\n");
            }
            int yearCals = startYear + (i + 1) * yearStep;
            if (yearCals == endYear) {
                yearCals = endYear - 1;
            }
            String filename = this.temporaryDirectory + "interp_" + yearCals + "_" + function.name() + "_" + i + System.currentTimeMillis() + ".csv";
            FileTools.saveString(filename, completeFile.toString(), true, "UTF-8");
            this.producedfiles[i] = new File(filename);
            System.out.println("PRODUCED FILE TO COPY " + this.producedfiles[i]);
        }
    }

    private List<List<Object>> interpolateColumns(List<Object> col1, List<Object> col2, int intervals, String type, INTERPOLATIONFUNCTIONS function) {
        int elements = col1.size();
        ArrayList<List<Object>> columns = new ArrayList<List<Object>>();
        for (int i = 0; i < intervals; ++i) {
            columns.add(new ArrayList());
        }
        boolean interping = true;
        for (int i = 0; i < elements; ++i) {
            Object[] row1 = (Object[])col1.get(i);
            Object[] row2 = (Object[])col2.get(i);
            double firstNum = row1[1] != null ? Double.parseDouble("" + row1[1]) : 0.0;
            double secondNum = row2[1] != null ? Double.parseDouble("" + row2[1]) : 0.0;
            Object key = row1[0];
            double[] interpolation = null;
            if (firstNum != secondNum) {
                if (interping) {
                    logger.debug("Interpolating ... ");
                    interping = false;
                }
                if (function == INTERPOLATIONFUNCTIONS.LINEAR) {
                    interpolation = Operations.linearInterpolation(firstNum, secondNum, intervals);
                } else if (function == INTERPOLATIONFUNCTIONS.PARABOLIC) {
                    interpolation = Operations.parabolicInterpolation(firstNum, secondNum, intervals);
                }
            }
            for (int j = 0; j < intervals; ++j) {
                Object[] couple = new Object[2];
                couple[0] = key;
                double interp = firstNum;
                if (interpolation != null) {
                    interp = interpolation[j];
                }
                if (type.equals("integer")) {
                    couple[1] = Math.round(interp);
                } else {
                    interp = MathFunctions.roundDecimal(interp, 2);
                    couple[1] = interp;
                }
                columns.get(j).add(couple);
            }
        }
        return columns;
    }

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        String persistencePath = "/win/";
        String databaseUrl = "jdbc:postgresql://dbtest.research-infrastructures.eu/aquamapsorgupdated";
        String databaseUser = "utente";
        String databasePassword = "d4science";
        InterpolateTables interp = new InterpolateTables(configPath, persistencePath, databaseUrl, databaseUser, databasePassword);
        interp.interpolate("hcaf_d", "hcaf_d_2050", 7, INTERPOLATIONFUNCTIONS.LINEAR, 2012, 2050);
    }

    public static enum INTERPOLATIONFUNCTIONS {
        LINEAR,
        PARABOLIC;

    }
}

