/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.math.BigInteger;
import java.util.List;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;
import org.hibernate.SessionFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HspecDiscrepanciesCalculator {
    private static Logger logger = LoggerFactory.getLogger(HspecDiscrepanciesCalculator.class);
    private BigInteger numOfElements;
    private int errorCounter;
    protected String LogFile = "ALog.properties";
    int chunkSize = 7000;
    static double Threshold = 0.01;
    public String referenceTable = "speciesrichness";
    public String analyzedTable = "crossspecies_nonreviewed";
    public String referenceCriteria = "csquarecode,speccount";
    public String destinationCriteria = "csquarecode,maxspeciescountinacell";
    public String referenceSelectedColumns = "csquarecode,speccount";
    public String destinationSelectedColumns = "csquarecode,maxspeciescountinacell";
    public static String selectElementsQuery = "select %1$s from %2$s order by %3$s";
    public static String selectDestElementsQuery = "select %1$s from %2$s where %3$s";
    protected SessionFactory referencedbConnection;
    protected SessionFactory destinationdbConnection;

    public HspecDiscrepanciesCalculator(AlgorithmConfiguration config) throws Exception {
        this.referencedbConnection = DatabaseFactory.initDBConnection(config.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile, config);
        logger.debug("ReferenceDB initialized");
        this.destinationdbConnection = DatabaseFactory.initDBConnection(config.getConfigPath() + AlgorithmConfiguration.defaultConnectionFile, config);
        logger.debug("OriginalDB initialized");
    }

    public BigInteger countElements(String tablename, SessionFactory session) {
        BigInteger count = BigInteger.ZERO;
        String countingQuery = "select count(*) from " + tablename;
        logger.debug("Getting DB elements by this query: " + countingQuery);
        List<Object> result = DatabaseFactory.executeSQLQuery(countingQuery, session);
        count = (BigInteger)result.get(0);
        return count;
    }

    public List<Object> takeChunkOfDestElements(String tablename, String selectedColumns, String criteria, SessionFactory session, String whereclause) {
        String query = String.format(selectDestElementsQuery, selectedColumns, tablename, whereclause);
        List<Object> results = DatabaseFactory.executeSQLQuery(query, session);
        return results;
    }

    public List<Object> takeChunkOfElements(String tablename, String selectedColumns, String criteria, int limit, int offset, SessionFactory session) {
        String query = String.format(selectElementsQuery, selectedColumns, tablename, criteria) + " limit " + limit + " offset " + offset;
        logger.debug("takeChunkOfElements-> executing query on DB: " + query);
        List<Object> results = DatabaseFactory.executeSQLQuery(query, session);
        return results;
    }

    public double isNumber(String element) {
        try {
            double d = Double.parseDouble(element);
            return d;
        }
        catch (Exception e) {
            return -1.7976931348623157E308;
        }
    }

    public static void main(String[] args) throws Exception {
        String configPath = "./cfg/";
        AlgorithmConfiguration config = new AlgorithmConfiguration();
        config.setParam("DistributionTable", "hspec_suitable_automatic_local");
        config.setParam("ConfigPath", "./cfg/");
        config.setParam("CsquarecodesTable", "hcaf_d");
        config.setParam("EnvelopeTable", "hspen_micro");
        config.setParam("CreateTable", "true");
        config.setNumberOfResources(2);
        config.setParam("DatabaseUserName", "gcube");
        config.setParam("DatabasePassword", "d4science2");
        config.setParam("DatabaseURL", "jdbc:postgresql://localhost/testdb");
        HspecDiscrepanciesCalculator ec = new HspecDiscrepanciesCalculator(config);
        long t0 = System.currentTimeMillis();
        ec.runTest();
        long t1 = System.currentTimeMillis();
        float difference = t1 - t0;
        System.out.println("Elapsed time : " + (difference /= 60000.0f) + " min");
    }

    public boolean runTest() {
        long t0 = System.currentTimeMillis();
        this.numOfElements = this.countElements(this.analyzedTable, this.destinationdbConnection);
        logger.debug("Remote DB contains " + this.numOfElements + " elements.");
        int maxNumber = this.numOfElements.intValue();
        int numOfChunks = maxNumber / this.chunkSize;
        if (maxNumber % this.chunkSize > 0) {
            ++numOfChunks;
        }
        int startIndex = 0;
        this.errorCounter = 0;
        boolean equal = true;
        boolean error = false;
        for (int i = startIndex; i < numOfChunks; ++i) {
            int offset = i * this.chunkSize;
            List<Object> referencechunk = this.takeChunkOfElements(this.referenceTable, this.referenceSelectedColumns, this.referenceCriteria, this.chunkSize, offset, this.referencedbConnection);
            int m = referencechunk.size();
            for (int j = 0; j < m; ++j) {
                int k;
                Object[] refrow = (Object[])referencechunk.get(j);
                String whereclause = "";
                String[] refcolumns = this.referenceCriteria.split(",");
                for (int k2 = 0; k2 < refcolumns.length; ++k2) {
                    whereclause = whereclause + refcolumns[k2].trim() + "='" + refrow[k2] + "'";
                    if (k2 >= refcolumns.length - 1) continue;
                    whereclause = whereclause + " and ";
                }
                List<Object> destinationchunk = this.takeChunkOfDestElements(this.analyzedTable, this.destinationSelectedColumns, this.destinationCriteria, this.destinationdbConnection, whereclause);
                Object[] destrow = null;
                int columns = 0;
                if (destinationchunk == null || destinationchunk.size() <= 0) {
                    logger.debug("ERROR - COULD NOT FIND " + refrow + " ON DESTINATION TABLE");
                    for (k = 0; k < refcolumns.length; ++k) {
                        logger.debug("-" + refrow[k]);
                    }
                    error = true;
                    break;
                }
                destrow = (Object[])destinationchunk.get(0);
                columns = destrow.length;
                for (k = 0; k < columns; ++k) {
                    String refelem = "" + refrow[k];
                    String destelem = "" + destrow[k];
                    double d = this.isNumber(refelem);
                    if (d != -1.7976931348623157E308) {
                        if (Math.abs(d - this.isNumber(destelem)) > Threshold) {
                            ++this.errorCounter;
                            equal = false;
                            logger.debug("ERROR - DISCREPANCY AT NUMBERS COMPARISON: " + refelem + " vs " + destelem);
                        }
                    } else if (!refelem.equals(destelem)) {
                        ++this.errorCounter;
                        equal = false;
                        logger.debug("ERROR - DISCREPANCY AT STRING COMPARISON: " + refelem + " vs " + destelem);
                    }
                    if (!equal) break;
                }
                if (!equal) break;
            }
            if (error || !equal) break;
            logger.debug("CHUNK NUMBER " + i + " of " + numOfChunks + " OK!");
        }
        long t1 = System.currentTimeMillis();
        logger.debug("ELAPSED TIME: " + (t1 - t0) + " ms");
        this.referencedbConnection.close();
        this.destinationdbConnection.close();
        return equal;
    }
}

