/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.utils;

import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Sha1 {
    static String fixedCachePrefix = "cache_";

    private static String convertToHex(byte[] data) {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < data.length; ++i) {
            int halfbyte = data[i] >>> 4 & 0xF;
            int two_halfs = 0;
            do {
                if (0 <= halfbyte && halfbyte <= 9) {
                    buf.append((char)(48 + halfbyte));
                } else {
                    buf.append((char)(97 + (halfbyte - 10)));
                }
                halfbyte = data[i] & 0xF;
            } while (two_halfs++ < 1);
        }
        return buf.toString();
    }

    public static String SHA1(String text) throws NoSuchAlgorithmException, UnsupportedEncodingException {
        MessageDigest md = MessageDigest.getInstance("SHA-1");
        byte[] sha1hash = new byte[40];
        md.update(text.getBytes("iso-8859-1"), 0, text.length());
        sha1hash = md.digest();
        return Sha1.convertToHex(sha1hash);
    }

    public static String calcFilePrefix(String filestring) {
        try {
            int len = filestring.length();
            int counter = 0;
            String cacheDir = "";
            Pattern p = Pattern.compile("[a-z]");
            for (int i = 0; i < len; ++i) {
                String chars = "" + filestring.charAt(i);
                Matcher m = p.matcher(chars);
                boolean optioned = m.matches();
                if (optioned) {
                    ++counter;
                    cacheDir = cacheDir + chars;
                }
                if (counter > 2) break;
            }
            return cacheDir + "/";
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String calculateDigestMD5(String plainText) {
        String hashText = "";
        try {
            MessageDigest m = MessageDigest.getInstance("MD5");
            m.reset();
            m.update(plainText.getBytes("UTF-8"));
            byte[] digestBytes = m.digest();
            BigInteger digestValue = new BigInteger(1, digestBytes);
            hashText = digestValue.toString(16);
            int remain = 32 - hashText.length();
            for (int i = 0; i < remain; ++i) {
                hashText = "0" + hashText;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return hashText;
    }
}

