/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import java.awt.Color;
import java.awt.Paint;
import java.sql.Date;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.general.Dataset;
import org.jfree.data.time.Day;
import org.jfree.data.time.Minute;
import org.jfree.data.time.RegularTimePeriod;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleInsets;

public class TimeSeriesGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;
    private static final String formatYear = "yyyy";
    private static final String formatMonth = "MM-yyyy";
    private static final String formatDay = "MM-dd-yyyy";
    private String timeseriesformat;

    public TimeSeriesGraph(String title) {
        super(title);
    }

    @Override
    protected Dataset generateDataset() {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        TimeSeries s1 = new TimeSeries((Comparable)((Object)"Series 1"));
        s1.add((RegularTimePeriod)new Minute(0, 0, 7, 12, 2003), 1.2);
        s1.add((RegularTimePeriod)new Minute(30, 12, 7, 12, 2003), 3.0);
        s1.add((RegularTimePeriod)new Minute(15, 14, 7, 12, 2003), 8.0);
        TimeSeries s2 = new TimeSeries((Comparable)((Object)"Series 2"));
        s2.add((RegularTimePeriod)new Minute(0, 3, 7, 12, 2003), 0.0);
        s2.add((RegularTimePeriod)new Minute(30, 9, 7, 12, 2003), 0.0);
        s2.add((RegularTimePeriod)new Minute(15, 10, 7, 12, 2003), 0.0);
        dataset.addSeries(s1);
        dataset.addSeries(s2);
        return dataset;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        JFreeChart chart = ChartFactory.createTimeSeriesChart((String)"Time Series", (String)"", (String)"", (XYDataset)((XYDataset)dataset), (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        XYPlot plot = (XYPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.lightGray);
        plot.setDomainGridlinePaint((Paint)Color.white);
        plot.setRangeGridlinePaint((Paint)Color.white);
        plot.setAxisOffset(new RectangleInsets(5.0, 5.0, 5.0, 5.0));
        plot.setDomainCrosshairVisible(true);
        plot.setRangeCrosshairVisible(true);
        XYItemRenderer r = plot.getRenderer();
        if (r instanceof XYLineAndShapeRenderer) {
            XYLineAndShapeRenderer renderer = (XYLineAndShapeRenderer)r;
            renderer.setBaseShapesVisible(true);
            renderer.setBaseShapesFilled(true);
            renderer.setDrawSeriesLineAsPath(true);
        }
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride((DateFormat)new SimpleDateFormat(this.timeseriesformat));
        return chart;
    }

    @Override
    protected Dataset convert2Dataset(GraphData st) {
        List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
        int numbOfRows = pointslist.size();
        TimeSeriesCollection timeseriescollection = new TimeSeriesCollection();
        if (numbOfRows > 0) {
            int numbOfCols = pointslist.get(0).getEntries().size();
            for (int x = 0; x < numbOfRows; ++x) {
                String serieslabel = pointslist.get(x).getLabel();
                TimeSeries xyseries = new TimeSeries((Comparable)((Object)serieslabel));
                for (int y = 0; y < numbOfCols; ++y) {
                    String xlabel = pointslist.get(x).getEntries().get(y).getLabel();
                    double value = pointslist.get(x).getEntries().get(y).getValue().doubleValue();
                    Calendar cal = DateGuesser.convertDate(xlabel);
                    String granularity = DateGuesser.granularity(xlabel);
                    if (granularity.equals("YEAR")) {
                        this.timeseriesformat = formatYear;
                    } else if (granularity.equals("MONTH")) {
                        this.timeseriesformat = formatMonth;
                    } else if (granularity.equals("DAY")) {
                        this.timeseriesformat = formatDay;
                    }
                    AnalysisLogger.getLogger().debug((Object)("TimeSeriesGraph-> granularity " + granularity + " format " + this.timeseriesformat));
                    xyseries.add((RegularTimePeriod)new Day((java.util.Date)new Date(cal.getTimeInMillis())), value);
                }
                timeseriescollection.addSeries(xyseries);
            }
        }
        return timeseriescollection;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        TimeSeriesGraph tsg = new TimeSeriesGraph(title);
        tsg.timeseriesformat = this.timeseriesformat;
        return tsg;
    }
}

