/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.transducers;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.gcube.contentmanagement.graphtools.utils.DateGuesser;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.contentmanagement.lexicalmatcher.utils.DatabaseFactory;
import org.gcube.contentmanagement.lexicalmatcher.utils.DistanceCalculator;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.configuration.INFRASTRUCTURE;
import org.gcube.dataanalysis.ecoengine.datatypes.ColumnType;
import org.gcube.dataanalysis.ecoengine.datatypes.DatabaseType;
import org.gcube.dataanalysis.ecoengine.datatypes.InputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.OutputTable;
import org.gcube.dataanalysis.ecoengine.datatypes.PrimitiveType;
import org.gcube.dataanalysis.ecoengine.datatypes.ServiceType;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.PrimitiveTypes;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.ServiceParameters;
import org.gcube.dataanalysis.ecoengine.datatypes.enumtypes.TableTemplates;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.test.regression.Regressor;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseUtils;
import org.gcube.dataanalysis.ecoengine.utils.ResourceFactory;
import org.hibernate.SessionFactory;

public class OccurrencePointsMerger
implements Transducerer {
    protected static String finalTableNameL = "final_Table_Name";
    static String longitudeColumn = "longitudeColumn";
    static String latitudeColumn = "latitudeColumn";
    static String recordedByColumn = "recordedByColumn";
    static String scientificNameColumn = "scientificNameColumn";
    static String eventDateColumn = "eventDateColumn";
    static String lastModificationColumn = "lastModificationColumn";
    static String rightTableNameF = "rightTableName";
    static String leftTableNameF = "leftTableName";
    static String finalTableNameF = "finalTableName";
    static String spatialTolerance = "spatialTolerance";
    static String confidence = "confidence";
    protected List<OccurrenceRecord> records_left;
    protected List<OccurrenceRecord> records_right;
    protected AlgorithmConfiguration config;
    protected String lonFld;
    protected String latFld;
    protected String recordedByFld;
    protected String scientificNameFld;
    protected String eventDatFld;
    protected String modifDatFld;
    protected String leftTableName;
    protected String rightTableName;
    protected String finalTableName;
    protected String finalTableLabel;
    protected float spatialToleranceValue;
    protected float confidenceValue;
    protected StringBuffer columns;
    protected List<OccurrenceRecord> objectstoinsert;
    protected List<OccurrenceRecord> objectstodelete;
    protected List<Object> columnsNames;
    protected SessionFactory dbconnection;
    protected float status;
    boolean displaydateconvert = true;
    ResourceFactory resourceManager;

    public static String convert2conventionalFormat(Calendar date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat formatter = new SimpleDateFormat("MM/dd/yy KK:mm:ss a");
        String formattedDate = formatter.format(new Date(date.getTimeInMillis()));
        return formattedDate;
    }

    public OccurrenceRecord row2OccurrenceRecord(Object[] row) {
        OccurrenceRecord record = new OccurrenceRecord();
        int index = 0;
        for (Object name : this.columnsNames) {
            String name$ = "" + name;
            String value$ = "" + row[index];
            if (name$.equalsIgnoreCase(this.lonFld)) {
                record.x = Float.parseFloat(value$);
            } else if (name$.equalsIgnoreCase(this.latFld)) {
                record.y = Float.parseFloat(value$);
            } else if (name$.equalsIgnoreCase(this.recordedByFld)) {
                record.recordedby = value$;
            } else if (name$.equalsIgnoreCase(this.scientificNameFld)) {
                record.scientificName = value$;
            } else if (name$.equalsIgnoreCase(this.eventDatFld)) {
                if (value$ == null || value$.length() == 0) {
                    record.eventdate = null;
                } else {
                    record.eventdate = DateGuesser.convertDate(value$);
                    if (this.displaydateconvert) {
                        AnalysisLogger.getLogger().trace((Object)("From " + value$ + "->" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + " pattern " + DateGuesser.getPattern(value$)));
                        this.displaydateconvert = false;
                    }
                }
            } else if (name$.equalsIgnoreCase(this.modifDatFld)) {
                record.modifdate = DateGuesser.convertDate(value$);
            } else {
                record.otherValues.add(value$);
            }
            ++index;
        }
        return record;
    }

    public String occurrenceRecord2String(OccurrenceRecord record) {
        StringBuffer buffer = new StringBuffer();
        int index = 0;
        int k = 0;
        int nNames = this.columnsNames.size();
        for (Object name : this.columnsNames) {
            String dat;
            String name$ = "" + name;
            String value$ = "NULL";
            if (name$.equalsIgnoreCase(this.lonFld)) {
                value$ = "'" + record.x + "'";
            } else if (name$.equalsIgnoreCase(this.latFld)) {
                value$ = "'" + record.y + "'";
            } else if (name$.equalsIgnoreCase(this.recordedByFld)) {
                if (record.recordedby != null) {
                    value$ = "'" + record.recordedby.replace("'", "") + "'";
                }
            } else if (name$.equalsIgnoreCase(this.scientificNameFld)) {
                if (record.scientificName != null) {
                    value$ = "'" + record.scientificName.replace("'", "") + "'";
                }
            } else if (name$.equalsIgnoreCase(this.eventDatFld)) {
                if (record.eventdate != null) {
                    dat = OccurrencePointsMerger.convert2conventionalFormat(record.eventdate);
                    value$ = dat != null && dat.length() > 0 ? "'" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + "'" : "NULL";
                }
            } else if (name$.equalsIgnoreCase(this.modifDatFld)) {
                if (record.modifdate != null) {
                    dat = OccurrencePointsMerger.convert2conventionalFormat(record.modifdate);
                    value$ = dat != null && dat.length() > 0 ? "'" + OccurrencePointsMerger.convert2conventionalFormat(record.modifdate) + "'" : "NULL";
                }
            } else if (record.otherValues != null) {
                value$ = "'" + record.otherValues.get(k).replace("'", "") + "'";
                ++k;
            }
            if (value$.equals("'null'")) {
                value$ = "NULL";
            }
            buffer.append(value$);
            if (index < nNames - 1) {
                buffer.append(",");
            }
            ++index;
        }
        return buffer.toString();
    }

    @Override
    public List<StatisticalType> getInputParameters() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        PrimitiveType p0 = new PrimitiveType(String.class.getName(), null, PrimitiveTypes.STRING, finalTableNameL, "the name of the produced table", "Occ_");
        InputTable p1 = new InputTable(templatesOccurrence, leftTableNameF, "the First table containing the occurrence points", "");
        InputTable p2 = new InputTable(templatesOccurrence, rightTableNameF, "the Second table containing the occurrence points", "");
        ColumnType p3 = new ColumnType(leftTableNameF, longitudeColumn, "column with longitude values", "decimallongitude", false);
        ColumnType p4 = new ColumnType(leftTableNameF, latitudeColumn, "column with latitude values", "decimallatitude", false);
        ColumnType p5 = new ColumnType(leftTableNameF, recordedByColumn, "column with RecordedBy values", "recordedby", false);
        ColumnType p6 = new ColumnType(leftTableNameF, scientificNameColumn, "column with Scientific Names", "scientificname", false);
        ColumnType p7 = new ColumnType(leftTableNameF, eventDateColumn, "column with EventDate values", "eventdate", false);
        ColumnType p8 = new ColumnType(leftTableNameF, lastModificationColumn, "column with Modified values", "modified", false);
        ServiceType p9 = new ServiceType(ServiceParameters.RANDOMSTRING, finalTableNameF, "name of the resulting table", "processedOccurrences_");
        PrimitiveType p10 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, spatialTolerance, "the tolerance in degree for assessing that two points could be the same", "0.5");
        PrimitiveType p11 = new PrimitiveType(Float.class.getName(), null, PrimitiveTypes.NUMBER, confidence, "the overall acceptance similarity threshold over which two points are the same - from 0 to 100", "80");
        ArrayList<StatisticalType> inputs = new ArrayList<StatisticalType>();
        inputs.add(p0);
        inputs.add(p1);
        inputs.add(p2);
        inputs.add(p3);
        inputs.add(p4);
        inputs.add(p5);
        inputs.add(p6);
        inputs.add(p7);
        inputs.add(p8);
        inputs.add(p9);
        inputs.add(p10);
        inputs.add(p11);
        DatabaseType.addDefaultDBPars(inputs);
        return inputs;
    }

    @Override
    public String getResources() {
        if (this.status > 0.0f && this.status < 100.0f) {
            return ResourceFactory.getResources(100.0f);
        }
        return ResourceFactory.getResources(0.0f);
    }

    @Override
    public String getResourceLoad() {
        if (this.resourceManager == null) {
            this.resourceManager = new ResourceFactory();
        }
        return this.resourceManager.getResourceLoad(1);
    }

    @Override
    public float getStatus() {
        return this.status;
    }

    @Override
    public INFRASTRUCTURE getInfrastructure() {
        return INFRASTRUCTURE.LOCAL;
    }

    @Override
    public StatisticalType getOutput() {
        ArrayList<TableTemplates> templatesOccurrence = new ArrayList<TableTemplates>();
        templatesOccurrence.add(TableTemplates.OCCURRENCE_SPECIES);
        OutputTable p = new OutputTable(templatesOccurrence, this.finalTableLabel, this.finalTableName, "The output table containing the processed points");
        return p;
    }

    @Override
    public void init() throws Exception {
        AnalysisLogger.setLogger(this.config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
        this.lonFld = this.config.getParam(longitudeColumn);
        this.latFld = this.config.getParam(latitudeColumn);
        this.recordedByFld = this.config.getParam(recordedByColumn);
        this.scientificNameFld = this.config.getParam(scientificNameColumn);
        this.eventDatFld = this.config.getParam(eventDateColumn);
        this.modifDatFld = this.config.getParam(lastModificationColumn);
        this.leftTableName = this.config.getParam(leftTableNameF);
        this.rightTableName = this.config.getParam(rightTableNameF);
        this.finalTableName = this.config.getParam(finalTableNameF);
        this.finalTableLabel = this.config.getParam(finalTableNameL);
        this.spatialToleranceValue = Float.parseFloat(this.config.getParam(spatialTolerance));
        this.confidenceValue = Float.parseFloat(this.config.getParam(confidence));
        this.objectstoinsert = new ArrayList<OccurrenceRecord>();
        this.objectstodelete = new ArrayList<OccurrenceRecord>();
        this.status = 0.0f;
    }

    @Override
    public void setConfiguration(AlgorithmConfiguration config) {
        this.config = config;
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getDescription() {
        return "An algorithm for merging two sets of occurrence points of species coming from the Species Discovery Facility of D4Science";
    }

    protected float probabilityStrings(String first, String second) {
        if (first == null || second == null) {
            return 1.0f;
        }
        return (float)new DistanceCalculator().CD(false, first, second);
    }

    protected float probabilityDates(Calendar first, Calendar second) {
        if (first == null || second == null) {
            return 1.0f;
        }
        if (first.compareTo(second) == 0) {
            return 1.0f;
        }
        return 0.0f;
    }

    protected float extProb(OccurrenceRecord right, OccurrenceRecord left) {
        float probability = 0.0f;
        float distance = (float)Math.sqrt(Math.abs(left.x - right.x) + Math.abs(left.y - right.y));
        if (distance > this.spatialToleranceValue) {
            probability = 0.0f;
        } else {
            float pSpecies = this.probabilityStrings(right.scientificName, left.scientificName);
            float pRecordedBy = this.probabilityStrings(right.recordedby, left.recordedby);
            float pDates = this.probabilityDates(right.eventdate, left.eventdate);
            probability = pSpecies * pRecordedBy * pDates;
        }
        return probability * 100.0f;
    }

    protected void manageHighProbability(float probability, OccurrenceRecord leftOcc, OccurrenceRecord rightOcc) {
        if (leftOcc.modifdate != null && rightOcc.modifdate != null && leftOcc.modifdate.before(rightOcc.modifdate) || leftOcc.modifdate == null && rightOcc.modifdate != null) {
            this.objectstodelete.add(leftOcc);
            this.objectstoinsert.add(rightOcc);
        }
    }

    protected void manageLowProbability(float probability, OccurrenceRecord leftOcc, OccurrenceRecord rightOcc) {
        this.objectstoinsert.add(rightOcc);
    }

    protected void persist() throws Exception {
        int todel = this.objectstodelete.size();
        int counter = 0;
        StringBuffer buffer = new StringBuffer();
        AnalysisLogger.getLogger().debug((Object)("Deleting " + todel + " objects"));
        if (todel > 0) {
            for (OccurrenceRecord record : this.objectstodelete) {
                String rec = this.recordedByFld + "='" + record.recordedby.replace("'", "") + "'";
                String sci = this.scientificNameFld + "='" + record.scientificName.replace("'", "") + "'";
                String x = this.lonFld + "='" + record.x + "'";
                String y = this.latFld + "='" + record.y + "'";
                String event = null;
                String modified = null;
                if (record.eventdate != null) {
                    event = this.eventDatFld + "='" + OccurrencePointsMerger.convert2conventionalFormat(record.eventdate) + "'";
                }
                if (record.modifdate != null) {
                    modified = this.modifDatFld + "='" + OccurrencePointsMerger.convert2conventionalFormat(record.modifdate) + "'";
                }
                buffer.append("(");
                buffer.append(rec + " AND " + sci + " AND " + x + " AND " + y);
                if (event != null) {
                    buffer.append(" AND " + event);
                }
                if (modified != null) {
                    buffer.append(" AND " + modified);
                }
                buffer.append(")");
                if (counter < todel - 1) {
                    buffer.append(" OR ");
                }
                ++counter;
            }
            String updateQ = DatabaseUtils.deleteFromBuffer(this.finalTableName, buffer);
            DatabaseFactory.executeSQLUpdate(updateQ, this.dbconnection);
            AnalysisLogger.getLogger().debug((Object)"Objects deleted");
        }
        buffer = new StringBuffer();
        int toins = this.objectstoinsert.size();
        AnalysisLogger.getLogger().debug((Object)("Inserting " + toins + " objects"));
        counter = 0;
        if (toins > 0) {
            for (OccurrenceRecord record : this.objectstoinsert) {
                buffer.append("(");
                buffer.append(this.occurrenceRecord2String(record));
                buffer.append(")");
                if (counter < toins - 1) {
                    buffer.append(",");
                }
                ++counter;
            }
            String updateQ = DatabaseUtils.insertFromBuffer(this.finalTableName, this.columns.toString(), buffer);
            System.out.println("Update:\n" + updateQ);
            AnalysisLogger.getLogger().debug((Object)("Update:\n" + updateQ));
            DatabaseFactory.executeSQLUpdate(updateQ, this.dbconnection);
            AnalysisLogger.getLogger().debug((Object)"Objects inserted");
        }
    }

    protected void prepareFinalTable() throws Exception {
        DatabaseFactory.executeSQLUpdate(DatabaseUtils.duplicateTableStatement(this.leftTableName, this.finalTableName), this.dbconnection);
    }

    protected void extractColumnNames() throws Exception {
        this.columnsNames = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsNamesStatement(this.rightTableName), this.dbconnection);
        int nCols = this.columnsNames.size();
        this.columns = new StringBuffer();
        for (int i = 0; i < nCols; ++i) {
            this.columns.append("\"" + this.columnsNames.get(i) + "\"");
            if (i >= nCols - 1) continue;
            this.columns.append(",");
        }
    }

    @Override
    public void compute() throws Exception {
        try {
            AnalysisLogger.getLogger().trace((Object)"Initializing DB Connection");
            this.dbconnection = DatabaseUtils.initDBSession(this.config);
            AnalysisLogger.getLogger().trace((Object)"Taking Table Description");
            this.extractColumnNames();
            AnalysisLogger.getLogger().trace((Object)("Taken Table Description: " + this.columns));
            AnalysisLogger.getLogger().trace((Object)("Creating final table: " + this.finalTableName));
            try {
                DatabaseFactory.executeSQLUpdate(DatabaseUtils.dropTableStatement(this.finalTableName), this.dbconnection);
            }
            catch (Exception e1) {
                // empty catch block
            }
            this.prepareFinalTable();
            AnalysisLogger.getLogger().trace((Object)("Taking elements from left table: " + this.leftTableName));
            List<Object> leftRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.leftTableName, this.columns.toString(), ""), this.dbconnection);
            AnalysisLogger.getLogger().trace((Object)("Taking elements from right table: " + this.rightTableName));
            List<Object> rightRows = DatabaseFactory.executeSQLQuery(DatabaseUtils.getColumnsElementsStatement(this.rightTableName, this.columns.toString(), ""), this.dbconnection);
            ArrayList<OccurrenceRecord> leftRecords = new ArrayList<OccurrenceRecord>();
            AnalysisLogger.getLogger().trace((Object)("Processing " + this.leftTableName + " vs " + this.rightTableName));
            this.status = 10.0f;
            int rightCounter = 0;
            int similaritiesCounter = 0;
            int allrightrows = rightRows.size();
            for (Object rRow : rightRows) {
                OccurrenceRecord rightOcc = this.row2OccurrenceRecord((Object[])rRow);
                int k = 0;
                int leftrecordsSize = 0;
                boolean found = false;
                float p = 0.0f;
                OccurrenceRecord bestleftOcc = null;
                for (Object lRow : leftRows) {
                    OccurrenceRecord leftOcc = null;
                    if (leftrecordsSize <= k) {
                        leftOcc = this.row2OccurrenceRecord((Object[])lRow);
                        leftRecords.add(leftOcc);
                        ++leftrecordsSize;
                    } else {
                        leftOcc = (OccurrenceRecord)leftRecords.get(k);
                    }
                    p = this.extProb(leftOcc, rightOcc);
                    if (p >= this.confidenceValue) {
                        bestleftOcc = leftOcc;
                        found = true;
                        ++similaritiesCounter;
                        AnalysisLogger.getLogger().trace((Object)("Found a similarity with P=" + p + " between (" + "\"" + leftOcc.scientificName + "\"" + "," + leftOcc.x + "\"" + "," + "\"" + leftOcc.y + "\"" + "," + "\"" + leftOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsMerger.convert2conventionalFormat(leftOcc.eventdate) + "\"" + ") VS " + "(" + "\"" + rightOcc.scientificName + "\"" + "," + "\"" + rightOcc.x + "\"" + "," + "\"" + rightOcc.y + "\"" + "," + "\"" + rightOcc.recordedby + "\"" + "," + "\"" + OccurrencePointsMerger.convert2conventionalFormat(rightOcc.eventdate) + "\"" + ")"));
                        break;
                    }
                    ++k;
                }
                ++rightCounter;
                if (found) {
                    this.manageHighProbability(p, bestleftOcc, rightOcc);
                } else {
                    this.manageLowProbability(p, bestleftOcc, rightOcc);
                }
                this.status = Math.min(90.0f, 10.0f + 80.0f * (float)rightCounter / (float)allrightrows);
            }
            AnalysisLogger.getLogger().trace((Object)("Found " + similaritiesCounter + " similarities on " + rightCounter + " elements"));
            this.status = 90.0f;
            this.persist();
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (this.dbconnection != null) {
                this.dbconnection.close();
            }
            this.status = 100.0f;
            AnalysisLogger.getLogger().trace((Object)"Occ Points Processing Finished and db closed");
        }
    }

    public static void main(String[] args) throws Exception {
        AlgorithmConfiguration config = Regressor.getConfig();
        config.setNumberOfResources(1);
        config.setParam(longitudeColumn, "decimallongitude");
        config.setParam(latitudeColumn, "decimallatitude");
        config.setParam(recordedByColumn, "recordedby");
        config.setParam(scientificNameColumn, "scientificname");
        config.setParam(eventDateColumn, "eventdate");
        config.setParam(lastModificationColumn, "modified");
        config.setParam(rightTableNameF, "whitesharkoccurrences2");
        config.setParam(leftTableNameF, "whitesharkoccurrences1");
        config.setParam(finalTableNameF, "whitesharkoccurrencesmerged");
        config.setParam(spatialTolerance, "0.5");
        config.setParam(confidence, "0.8");
        OccurrencePointsMerger occm = new OccurrencePointsMerger();
        occm.setConfiguration(config);
        occm.init();
        occm.compute();
    }

    protected class OccurrenceRecord {
        public String scientificName;
        public String recordedby;
        public Calendar eventdate;
        public Calendar modifdate;
        public float x;
        public float y;
        public List<String> otherValues = new ArrayList<String>();
    }
}

