/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.Clusterer;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.Evaluator;
import org.gcube.dataanalysis.ecoengine.interfaces.Generator;
import org.gcube.dataanalysis.ecoengine.interfaces.GenericAlgorithm;
import org.gcube.dataanalysis.ecoengine.interfaces.Model;
import org.gcube.dataanalysis.ecoengine.interfaces.Modeler;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.ClusterersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.EvaluatorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.GeneratorsFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.ModelersFactory;
import org.gcube.dataanalysis.ecoengine.processing.factories.TransducerersFactory;
import org.gcube.dataanalysis.ecoengine.utils.DatabaseFactory;

public class ProcessorsFactory {
    public static List<StatisticalType> getDefaultDatabaseConfiguration(String cfgPath) {
        String databasecfgfile = cfgPath + AlgorithmConfiguration.defaultConnectionFile;
        try {
            return DatabaseFactory.getDefaultDatabaseConfiguration(databasecfgfile);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static List<String> getClasses(String file) throws Exception {
        Properties p = AlgorithmConfiguration.getProperties(file);
        ArrayList<String> algs = new ArrayList<String>();
        for (Object algName : p.keySet()) {
            algs.add((String)algName);
        }
        return algs;
    }

    public static String getDescription(String file, String algorithmName) throws Exception {
        Properties p = AlgorithmConfiguration.getProperties(file);
        String algorithmclass = p.getProperty(algorithmName);
        Object algclass = Class.forName(algorithmclass).newInstance();
        if (algclass instanceof Generator) {
            return ((Generator)algclass).getDescription();
        }
        if (algclass instanceof Modeler) {
            return ((Modeler)algclass).getDescription();
        }
        if (algclass instanceof Model) {
            return ((Model)algclass).getDescription();
        }
        if (algclass instanceof Evaluator) {
            return ((Evaluator)algclass).getDescription();
        }
        if (algclass instanceof Clusterer) {
            return ((Clusterer)algclass).getDescription();
        }
        if (algclass instanceof Transducerer) {
            return ((Transducerer)algclass).getDescription();
        }
        return ((GenericAlgorithm)algclass).getDescription();
    }

    public static List<StatisticalType> getParameters(String file, String algorithmName) throws Exception {
        Properties p = AlgorithmConfiguration.getProperties(file);
        String algorithmclass = p.getProperty(algorithmName);
        Object algclass = Class.forName(algorithmclass).newInstance();
        if (algclass instanceof Generator) {
            return ((Generator)algclass).getInputParameters();
        }
        if (algclass instanceof Modeler) {
            return ((Modeler)algclass).getInputParameters();
        }
        if (algclass instanceof Model) {
            return ((Model)algclass).getInputParameters();
        }
        if (algclass instanceof Evaluator) {
            return ((Evaluator)algclass).getInputParameters();
        }
        if (algclass instanceof Clusterer) {
            return ((Clusterer)algclass).getInputParameters();
        }
        if (algclass instanceof Transducerer) {
            return ((Transducerer)algclass).getInputParameters();
        }
        return ((GenericAlgorithm)algclass).getInputParameters();
    }

    public static ComputationalAgent getProcessor(AlgorithmConfiguration config, String file) throws Exception {
        return ProcessorsFactory.getProcessor(config, file, null);
    }

    public static ComputationalAgent getProcessor(AlgorithmConfiguration config, String file, String explicitAlgorithm) throws Exception {
        try {
            AnalysisLogger.setLogger(config.getConfigPath() + AlgorithmConfiguration.defaultLoggerFile);
            String algorithm = explicitAlgorithm;
            if (explicitAlgorithm == null) {
                algorithm = config.getAgent();
            }
            if (algorithm == null) {
                throw new Exception("PROCESSOR NOT SPECIFIED");
            }
            Properties p = AlgorithmConfiguration.getProperties(file);
            String algorithmclass = p.getProperty(algorithm);
            if (algorithmclass == null) {
                return null;
            }
            Object algclass = Class.forName(algorithmclass).newInstance();
            if (algclass instanceof Generator) {
                Generator g = (Generator)algclass;
                g.setConfiguration(config);
                g.setConfiguration(config);
                return g;
            }
            if (algclass instanceof Modeler) {
                Modeler m = (Modeler)algclass;
                m.setConfiguration(config);
                return m;
            }
            if (algclass instanceof Evaluator) {
                Evaluator m = (Evaluator)algclass;
                m.setConfiguration(config);
                return m;
            }
            if (algclass instanceof Clusterer) {
                Clusterer m = (Clusterer)algclass;
                m.setConfiguration(config);
                return m;
            }
            if (algclass instanceof Transducerer) {
                Transducerer m = (Transducerer)algclass;
                m.setConfiguration(config);
                return m;
            }
            return null;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static HashMap<String, List<String>> getAllFeatures(String configPath) throws Exception {
        HashMap<String, List<String>> map = new HashMap<String, List<String>>();
        map.put("DISTRIBUTIONS", GeneratorsFactory.getProbabilityDistributionAlgorithms(configPath));
        map.put("MODELS", ModelersFactory.getModels(configPath));
        map.put("EVALUATORS", EvaluatorsFactory.getAllEvaluators(configPath));
        map.put("CLUSTERERS", ClusterersFactory.getAllClusterers(configPath));
        map.put("TRANSDUCERS", TransducerersFactory.getAllTransducerers(configPath));
        return map;
    }

    public static void addAgent2List(List<ComputationalAgent> agents, ComputationalAgent agent) {
        if (agent == null) {
            return;
        }
        int i = 0;
        boolean inserted = false;
        for (ComputationalAgent g : agents) {
            if (g.getInfrastructure().compareTo(agent.getInfrastructure()) > 0) {
                agents.add(i, agent);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            agents.add(agent);
        }
    }
}

