/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.contentmanagement.graphtools.plotting.graphs;

import com.rapidminer.tools.math.MathFunctions;
import java.awt.BasicStroke;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcube.contentmanagement.graphtools.abstracts.GenericStandaloneGraph;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphData;
import org.gcube.portlets.user.timeseries.charts.support.types.GraphGroups;
import org.gcube.portlets.user.timeseries.charts.support.types.Point;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.function.Function2D;
import org.jfree.data.function.NormalDistributionFunction2D;
import org.jfree.data.general.Dataset;
import org.jfree.data.general.DatasetUtilities;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class GaussianDistributionGraph
extends GenericStandaloneGraph {
    private static final long serialVersionUID = 1L;
    double mean;
    double variance;

    public GaussianDistributionGraph(String title) {
        super(title);
    }

    @Override
    protected Dataset generateDataset() {
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        NormalDistributionFunction2D normaldistributionfunction2d = new NormalDistributionFunction2D(0.0, 1.0);
        XYSeries xyseries = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"N1"));
        xyseriescollection.addSeries(xyseries);
        NormalDistributionFunction2D normaldistributionfunction2d1 = new NormalDistributionFunction2D(0.0, Math.sqrt(0.2));
        XYSeries xyseries1 = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d1, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"N2"));
        xyseriescollection.addSeries(xyseries1);
        NormalDistributionFunction2D normaldistributionfunction2d2 = new NormalDistributionFunction2D(0.0, Math.sqrt(5.0));
        XYSeries xyseries2 = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d2, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"N3"));
        xyseriescollection.addSeries(xyseries2);
        NormalDistributionFunction2D normaldistributionfunction2d3 = new NormalDistributionFunction2D(-2.0, Math.sqrt(0.5));
        XYSeries xyseries3 = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d3, (double)-5.1, (double)5.1, (int)121, (Comparable)((Object)"N4"));
        xyseriescollection.addSeries(xyseries3);
        return xyseriescollection;
    }

    @Override
    protected JFreeChart createChart(Dataset dataset) {
        String label = "mean:" + this.mean + " variance:" + this.variance;
        if (label.length() > 30) {
            label = label.substring(0, 30) + "...";
        }
        JFreeChart jfreechart = ChartFactory.createXYLineChart((String)"", (String)label, (String)"", (XYDataset)((XYSeriesCollection)dataset), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        XYPlot xyplot = (XYPlot)jfreechart.getPlot();
        xyplot.setDomainZeroBaselineVisible(true);
        xyplot.setRangeZeroBaselineVisible(true);
        xyplot.setDomainPannable(true);
        xyplot.setRangePannable(true);
        ValueAxis valueaxis = xyplot.getDomainAxis();
        valueaxis.setLowerMargin(0.0);
        valueaxis.setUpperMargin(0.0);
        XYLineAndShapeRenderer xylineandshaperenderer = (XYLineAndShapeRenderer)xyplot.getRenderer();
        xylineandshaperenderer.setDrawSeriesLineAsPath(true);
        xylineandshaperenderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f));
        return jfreechart;
    }

    @Override
    protected GenericStandaloneGraph getInstance(String title) {
        return new GaussianDistributionGraph(title);
    }

    @Override
    protected Dataset convert2Dataset(GraphData st) {
        List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
        int numbOfSeries = pointslist.size();
        XYSeriesCollection xyseriescollection = new XYSeriesCollection();
        if (numbOfSeries > 0) {
            int numbOfPoints = pointslist.get(0).getEntries().size();
            for (int s = 0; s < numbOfSeries; ++s) {
                String serieslabel = pointslist.get(s).getLabel();
                double maxRange = st.getMaxY().doubleValue();
                double minRange = st.getMinY().doubleValue();
                double[] points = org.gcube.contentmanagement.graphtools.utils.MathFunctions.points2Double(pointslist, s, numbOfPoints);
                this.mean = org.gcube.contentmanagement.graphtools.utils.MathFunctions.mean(points);
                this.variance = MathFunctions.variance((double[])points, (double)Double.NEGATIVE_INFINITY);
                this.mean = Math.round(this.mean);
                this.variance = Math.round(this.variance);
                if (this.variance == 0.0) {
                    this.variance = 0.1;
                }
                AnalysisLogger.getLogger().debug((Object)("mean " + this.mean + " variance " + this.variance));
                NormalDistributionFunction2D normaldistributionfunction2d = new NormalDistributionFunction2D(this.mean, this.variance);
                XYSeries xyseries = DatasetUtilities.sampleFunction2DToSeries((Function2D)normaldistributionfunction2d, (double)minRange, (double)(maxRange *= 2.0), (int)121, (Comparable)((Object)serieslabel));
                xyseriescollection.addSeries(xyseries);
            }
        }
        return xyseriescollection;
    }

    public static Map<String, List<NormalDistributionFunction2D>> graphs2Normals(GraphGroups gg) {
        HashMap<String, List<NormalDistributionFunction2D>> normalsMap = new HashMap<String, List<NormalDistributionFunction2D>>();
        for (String key : gg.getGraphs().keySet()) {
            GraphData st = gg.getGraphs().get(key);
            List<Point<? extends Number, ? extends Number>> pointslist = st.getData();
            ArrayList<NormalDistributionFunction2D> normalsList = new ArrayList<NormalDistributionFunction2D>();
            int numbOfSeries = pointslist.size();
            if (numbOfSeries > 0) {
                int numbOfPoints = pointslist.get(0).getEntries().size();
                for (int s = 0; s < numbOfSeries; ++s) {
                    double[] points = org.gcube.contentmanagement.graphtools.utils.MathFunctions.points2Double(pointslist, s, numbOfPoints);
                    double mean = org.gcube.contentmanagement.graphtools.utils.MathFunctions.mean(points);
                    double variance = MathFunctions.variance((double[])points, (double)Double.NEGATIVE_INFINITY);
                    if (variance == 0.0) {
                        variance = 0.1;
                    }
                    AnalysisLogger.getLogger().debug((Object)("mean " + mean + " variance " + variance));
                    NormalDistributionFunction2D normaldistributionfunction2d = new NormalDistributionFunction2D(mean, variance);
                    normalsList.add(normaldistributionfunction2d);
                }
            }
            normalsMap.put(key, normalsList);
        }
        return normalsMap;
    }
}

