/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.portlets.user.timeseries.charts.support.tablemodel;

import java.io.Serializable;
import java.util.List;
import java.util.Vector;
import org.gcube.portlets.user.timeseries.charts.support.assertions.Assertion;
import org.gcube.portlets.user.timeseries.charts.support.exceptions.InvalidParameterException;
import org.gcube.portlets.user.timeseries.charts.support.tablemodel.FieldDescr;

public final class TableDescr
implements Serializable {
    private static final long serialVersionUID = -4850971456321479627L;
    private String name = null;
    private String alias = null;
    private List<FieldDescr> fields = new Vector<FieldDescr>();

    private TableDescr() {
    }

    public TableDescr(String name) throws InvalidParameterException {
        this();
        this.setName(name);
    }

    public TableDescr(String name, String alias) throws InvalidParameterException {
        this(name);
        this.setAlias(alias);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) throws InvalidParameterException {
        Assertion<InvalidParameterException> checker = new Assertion<InvalidParameterException>();
        checker.validate(name != null && name.trim().length() > 0, new InvalidParameterException("The table name cannot be null or empty."));
        this.name = name.trim();
    }

    public void setAlias(String alias) {
        if (alias != null && alias.trim().length() > 0) {
            this.alias = alias.trim();
        }
    }

    public String getAlias() {
        if (this.alias != null) {
            return this.alias;
        }
        return this.name;
    }

    public List<FieldDescr> getFields() {
        return this.fields;
    }

    public void addFields(FieldDescr ... fields) {
        if (fields == null) {
            return;
        }
        for (FieldDescr field : fields) {
            this.fields.add(field);
        }
    }
}

