/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.configuration.ALG_PROPS;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.ComputationalAgent;
import org.gcube.dataanalysis.ecoengine.interfaces.Model;
import org.gcube.dataanalysis.ecoengine.interfaces.Modeler;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class ModelersFactory {
    public static Modeler getModeler(AlgorithmConfiguration config) throws Exception {
        Modeler modlr = (Modeler)ProcessorsFactory.getProcessor(config, String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.generatorsFile);
        return modlr;
    }

    public static List<String> getModels(String configPath) throws Exception {
        List<String> models = ProcessorsFactory.getClasses(String.valueOf(configPath) + AlgorithmConfiguration.modelsFile);
        return models;
    }

    public static List<String> getModelers(String configPath) throws Exception {
        List<String> modelers = ProcessorsFactory.getClasses(String.valueOf(configPath) + AlgorithmConfiguration.modelersFile);
        return modelers;
    }

    public static List<StatisticalType> getModelParameters(String configPath, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(String.valueOf(configPath) + AlgorithmConfiguration.modelsFile, algorithmName);
        return inputs;
    }

    public static String getDescription(String configPath, String algorithmName) throws Exception {
        String input = ProcessorsFactory.getDescription(String.valueOf(configPath) + AlgorithmConfiguration.modelsFile, algorithmName);
        return input;
    }

    public static List<ComputationalAgent> getModelers(AlgorithmConfiguration config) throws Exception {
        ArrayList<ComputationalAgent> modelers = new ArrayList<ComputationalAgent>();
        try {
            AnalysisLogger.setLogger(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.defaultLoggerFile);
            String algorithm = config.getModel();
            Properties p = AlgorithmConfiguration.getProperties(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.modelsFile);
            String algorithmclass = p.getProperty(algorithm);
            Object algclass = Class.forName(algorithmclass).newInstance();
            if (algclass instanceof Modeler) {
                Modeler g = (Modeler)algclass;
                g.setConfiguration(config);
                modelers.add(g);
            } else {
                Model mod = (Model)algclass;
                ALG_PROPS[] algp = mod.getProperties();
                Properties pg = AlgorithmConfiguration.getProperties(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.modelersFile);
                for (Object modelerName : pg.values()) {
                    Modeler gen = (Modeler)Class.forName((String)modelerName).newInstance();
                    gen.setConfiguration(config);
                    ALG_PROPS[] supportedAlgs = gen.getSupportedModels();
                    boolean genSuitable = false;
                    ALG_PROPS[] aLG_PROPSArray = algp;
                    int n = algp.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ALG_PROPS prop = aLG_PROPSArray[n2];
                        ALG_PROPS[] aLG_PROPSArray2 = supportedAlgs;
                        int n3 = supportedAlgs.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            ALG_PROPS gprop = aLG_PROPSArray2[n4];
                            if (gprop == prop) {
                                genSuitable = true;
                                gen.setmodel(mod);
                                break;
                            }
                            ++n4;
                        }
                        ++n2;
                    }
                    if (!genSuitable) continue;
                    ModelersFactory.addModeler2List(modelers, gen);
                }
            }
            return modelers;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void addModeler2List(List<ComputationalAgent> modelers, Modeler mod) {
        int i = 0;
        boolean inserted = false;
        for (ComputationalAgent g : modelers) {
            if (g.getInfrastructure().compareTo(mod.getInfrastructure()) > 0) {
                modelers.add(i, mod);
                inserted = true;
                break;
            }
            ++i;
        }
        if (!inserted) {
            modelers.add(mod);
        }
    }
}

