/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.processing.factories;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.gcube.dataanalysis.ecoengine.configuration.AlgorithmConfiguration;
import org.gcube.dataanalysis.ecoengine.datatypes.StatisticalType;
import org.gcube.dataanalysis.ecoengine.interfaces.DynamicTransducer;
import org.gcube.dataanalysis.ecoengine.interfaces.Transducerer;
import org.gcube.dataanalysis.ecoengine.processing.factories.ProcessorsFactory;

public class DynamicTransducerersFactory {
    public static Transducerer getTransducerer(AlgorithmConfiguration config) throws Exception {
        String agent = config.getAgent();
        Map<String, Transducerer> subTransducerers = DynamicTransducerersFactory.getAllSubTransducerers(config);
        Transducerer trans = subTransducerers.get(agent);
        return trans;
    }

    public static List<String> getTransducerersNames(AlgorithmConfiguration config) throws Exception {
        Map<String, Transducerer> subTransducerers = DynamicTransducerersFactory.getAllSubTransducerers(config);
        ArrayList<String> names = new ArrayList<String>();
        for (String key : subTransducerers.keySet()) {
            names.add(key);
        }
        return names;
    }

    public static List<String> getAllDynamicTransducerers(AlgorithmConfiguration config) throws Exception {
        List<String> trans = ProcessorsFactory.getClasses(String.valueOf(config.getConfigPath()) + AlgorithmConfiguration.dynamicTransducerersFile);
        return trans;
    }

    public static Map<String, Transducerer> getAllSubTransducerers(AlgorithmConfiguration config) throws Exception {
        List<String> dynatransducers = DynamicTransducerersFactory.getAllDynamicTransducerers(config);
        LinkedHashMap<String, Transducerer> transducerList = new LinkedHashMap<String, Transducerer>();
        for (String dynatransducer : dynatransducers) {
            DynamicTransducer g;
            Map<String, Transducerer> subtrans;
            Object algclass = Class.forName(dynatransducer).newInstance();
            String prefix = dynatransducer;
            if (dynatransducer.length() > 3) {
                prefix = dynatransducer.substring(0, 3);
            }
            if ((subtrans = (g = (DynamicTransducer)algclass).getTransducers(config)) == null) continue;
            for (String stransK : subtrans.keySet()) {
                Transducerer t = subtrans.get(stransK);
                t.setConfiguration(config);
                transducerList.put(String.valueOf(prefix) + "." + stransK, t);
            }
        }
        return transducerList;
    }

    public static List<StatisticalType> getTransducerParameters(String configPath, String algorithmName) throws Exception {
        List<StatisticalType> inputs = ProcessorsFactory.getParameters(String.valueOf(configPath) + AlgorithmConfiguration.transducererFile, algorithmName);
        return inputs;
    }

    public static String getDescription(AlgorithmConfiguration config, String algorithmName) throws Exception {
        Map<String, Transducerer> subTransducerers = DynamicTransducerersFactory.getAllSubTransducerers(config);
        Transducerer tr = subTransducerers.get(algorithmName);
        if (tr != null) {
            return tr.getDescription();
        }
        return "";
    }
}

