/*
 * Decompiled with CFR 0.152.
 */
package org.gcube.dataanalysis.ecoengine.signals;

import com.rapidminer.example.Attribute;
import com.rapidminer.example.Example;
import com.rapidminer.example.ExampleSet;
import com.rapidminer.example.table.MemoryExampleTable;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.JPanel;
import marytts.signalproc.display.SpectrogramCustom;
import marytts.signalproc.window.Window;
import org.gcube.contentmanagement.graphtools.data.BigSamplesTable;
import org.gcube.contentmanagement.lexicalmatcher.utils.AnalysisLogger;
import org.gcube.dataanalysis.ecoengine.signals.Delta;

public class SignalConversions {
    public static double[][] addDeltaDouble(double[][] features) throws Exception {
        int vectorL = features[0].length;
        double[][] delta = new double[features.length][features[0].length * 3];
        int k = 0;
        while (k < features.length) {
            int g = 0;
            while (g < vectorL) {
                delta[k][g] = features[k][g];
                ++g;
            }
            ++k;
        }
        Delta.calcDelta(delta, vectorL);
        Delta.calcDoubleDelta(delta, vectorL);
        return delta;
    }

    public static double centerFreq(int i, double samplingRate, double lowerFilterFreq, int numMelFilters) {
        double[] mel = new double[]{SignalConversions.freqToMel(lowerFilterFreq), SignalConversions.freqToMel(samplingRate / 2.0)};
        double temp = mel[0] + (mel[1] - mel[0]) / (double)(numMelFilters + 1) * (double)i;
        return SignalConversions.inverseMel(temp);
    }

    public static double[] cepCoefficients(double[] f, int numCepstra, int numFilters) {
        double[] cepc = new double[numCepstra];
        int i = 0;
        while (i < cepc.length) {
            int j = 1;
            while (j <= numFilters) {
                int n = i;
                cepc[n] = cepc[n] + f[j - 1] * Math.cos(Math.PI * (double)i / (double)numFilters * ((double)j - 0.5));
                ++j;
            }
            ++i;
        }
        return cepc;
    }

    public static BufferedImage createImage(JPanel panel) {
        int w = panel.getWidth();
        int h = panel.getHeight();
        BufferedImage bi = new BufferedImage(w, h, 1);
        Graphics2D g = bi.createGraphics();
        panel.paint(g);
        return bi;
    }

    public static double[][] cutSpectrum(double[][] spectrum, float minFreq, float maxfreq, int fftWindowSize, int samplingRate) {
        int minFrequencyIndex = SignalConversions.frequencyIndex(minFreq, fftWindowSize, samplingRate);
        int maxFrequencyIndex = SignalConversions.frequencyIndex(maxfreq, fftWindowSize, samplingRate);
        double[][] cutSpectrum = new double[spectrum.length][maxFrequencyIndex - minFrequencyIndex + 1];
        int i = 0;
        while (i < spectrum.length) {
            cutSpectrum[i] = Arrays.copyOfRange(spectrum[i], minFrequencyIndex, maxFrequencyIndex);
            ++i;
        }
        return cutSpectrum;
    }

    public static void exampleSet2Signal(double[] rebuiltSignal, ExampleSet es, Double fillerValueFormissingEntries) {
        MemoryExampleTable met = (MemoryExampleTable)es.getExampleTable();
        int numCol = met.getAttributeCount();
        int numRows = met.size();
        Attribute labelAtt = met.getAttribute(numCol - 1);
        int i = 0;
        while (i < numRows) {
            int index = (int)met.getDataRow(i).get(labelAtt);
            String label = labelAtt.getMapping().mapIndex(index);
            int id = Integer.parseInt(label);
            Example e = es.getExample(i);
            for (Attribute a : e.getAttributes()) {
                Double value = e.getValue(a);
                if (value.equals(Double.NaN) && !fillerValueFormissingEntries.equals(Double.NaN)) {
                    value = fillerValueFormissingEntries;
                }
                rebuiltSignal[id] = value;
            }
            ++i;
        }
    }

    public static void exampleSet2Signal(double[] rebuiltSignal, ExampleSet es) {
        SignalConversions.exampleSet2Signal(rebuiltSignal, es, null);
    }

    public static int[] fftBinIndices(double samplingRate, int frameSize, int numMelFilters, int numFequencies, float lowerFilterFreq, float upperFilterFreq) {
        int[] cbin = new int[numFequencies + 2];
        AnalysisLogger.getLogger().debug((Object)("New Filter banks: " + numFequencies));
        cbin[0] = (int)Math.round((double)lowerFilterFreq / samplingRate * (double)frameSize);
        cbin[cbin.length - 1] = SignalConversions.frequencyIndex(upperFilterFreq, frameSize, (float)samplingRate);
        AnalysisLogger.getLogger().debug((Object)("F0: " + lowerFilterFreq));
        int i = 1;
        while (i <= numFequencies) {
            double fc = SignalConversions.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            AnalysisLogger.getLogger().debug((Object)("F" + i + ": " + fc));
            cbin[i] = (int)Math.round(fc / samplingRate * (double)frameSize);
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("F" + (cbin.length - 1) + ": " + upperFilterFreq));
        return cbin;
    }

    public static int[] fftBinIndices(double samplingRate, int frameSize, int numMelFilters, float lowerFilterFreq) {
        int[] cbin = new int[numMelFilters + 2];
        cbin[0] = (int)Math.round((double)lowerFilterFreq / samplingRate * (double)frameSize);
        cbin[cbin.length - 1] = frameSize / 2;
        int i = 1;
        while (i <= numMelFilters) {
            double fc = SignalConversions.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            cbin[i] = (int)Math.round(fc / samplingRate * (double)frameSize);
            ++i;
        }
        return cbin;
    }

    public static double freqToMel(double freq) {
        return 2595.0 * SignalConversions.log10(1.0 + freq / 700.0);
    }

    public static int frequencyIndex(float frequency, int fftSize, float samplingRate) {
        return Math.round(frequency * (float)fftSize / samplingRate);
    }

    public static double[] generateSinSignal(int signalLength, float timeShift, float frequency) {
        double[] samples = new double[signalLength];
        float time = 0.0f;
        int i = 0;
        while (i < samples.length) {
            samples[i] = (float)Math.sin(Math.PI * 2 * (double)frequency * (double)time);
            time += timeShift;
            ++i;
        }
        return samples;
    }

    public static double inverseMel(double x) {
        double temp = Math.pow(10.0, x / 2595.0) - 1.0;
        return 700.0 * temp;
    }

    public static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public static double[] melFilter(double[] bin, int[] cbin, int numMelFilters) {
        double[] temp = new double[numMelFilters + 2];
        int k = 1;
        while (k <= numMelFilters) {
            double num1 = 0.0;
            double num2 = 0.0;
            int i = cbin[k - 1];
            while (i <= cbin[k]) {
                num1 += (double)((i - cbin[k - 1] + 1) / (cbin[k] - cbin[k - 1] + 1)) * bin[i];
                ++i;
            }
            i = cbin[k] + 1;
            while (i <= cbin[k + 1]) {
                num2 += (double)(1 - (i - cbin[k]) / (cbin[k + 1] - cbin[k] + 1)) * bin[i];
                ++i;
            }
            temp[k] = num1 + num2;
            ++k;
        }
        double[] fbank = new double[numMelFilters];
        int i = 0;
        while (i < numMelFilters) {
            fbank[i] = temp[i + 1];
            ++i;
        }
        return fbank;
    }

    public static int recalculateMaxMelFilters(double samplingRate, int numMelFilters, float lowerFilterFreq, float maxFilterFreq) {
        int bestIndex = 1;
        int i = 1;
        while (i <= numMelFilters) {
            double fc = SignalConversions.centerFreq(i, samplingRate, lowerFilterFreq, numMelFilters);
            AnalysisLogger.getLogger().debug((Object)("fc " + fc));
            if (fc > (double)maxFilterFreq) {
                bestIndex = i;
                break;
            }
            ++i;
        }
        return bestIndex - 1;
    }

    public static double sample2Time(int sample, int sampleRate) {
        return (double)sample / (double)sampleRate;
    }

    public static double[] signalTimeLine(int signalLength, double samplingRate) {
        double[] time = new double[signalLength];
        Arrays.fill(time, Double.NaN);
        int i = 0;
        while (i < signalLength) {
            time[i] = (double)i / samplingRate;
            ++i;
        }
        AnalysisLogger.getLogger().debug((Object)("time " + time[signalLength - 1] * samplingRate + " vs " + signalLength));
        return time;
    }

    public static float spectrumTime(float linearTime, float windowShiftTime) {
        return linearTime / windowShiftTime;
    }

    public static ExampleSet signal2ExampleSet(double[] signal) {
        BigSamplesTable samples = new BigSamplesTable();
        int k = 0;
        while (k < signal.length) {
            samples.addSampleRow("" + k, signal[k]);
            ++k;
        }
        AnalysisLogger.getLogger().debug((Object)"Example Set Created");
        return samples.generateExampleSet();
    }

    public static double[][] spectrogram(String name, double[] signal, int samplingRate, int windowshift, int frameslength, boolean display) throws Exception {
        SpectrogramCustom spec = new SpectrogramCustom(signal, samplingRate, Window.get((int)1, (int)frameslength), windowshift, frameslength, 640, 480);
        double[][] spectrum = (double[][])spec.spectra.toArray((T[])new double[spec.spectra.size()][]);
        if (display) {
            spec.showInJFrame(name, true, true);
        }
        return spectrum;
    }

    public static void displaySpectrogram(double[][] spectrum, double[] signal, String name, int samplingRate, int windowshift, int frameslength) throws Exception {
        SpectrogramCustom spec = new SpectrogramCustom(signal, samplingRate, Window.get((int)1, (int)frameslength), windowshift, frameslength, 640, 480);
        spec.spectra = new ArrayList<double[]>();
        int i = 0;
        while (i < spectrum.length) {
            spec.spectra.add(spectrum[i]);
            ++i;
        }
        spec.showInJFrame(name, true, true);
    }

    public static float spectrumTimeFromIndex(int index, float windowShiftTime) {
        return (float)index * windowShiftTime;
    }

    public static int spectrumIndex(float linearTime, float windowShiftTime) {
        return (int)(linearTime / windowShiftTime);
    }

    public static int time2Sample(double time, int sampleRate) {
        return (int)(time * (double)sampleRate);
    }

    public static double[] takeMaxFrequenciesInSpectrogram(double[][] spectrogram, int samplingRate, int windowSamples, float minfreq) {
        double[] maxs = new double[spectrogram.length];
        int j = 0;
        double[][] dArray = spectrogram;
        int n = spectrogram.length;
        int n2 = 0;
        while (n2 < n) {
            double[] slice = dArray[n2];
            int bestidx = 0;
            double max = -1.7976931348623157E308;
            int k = 0;
            while (k < slice.length) {
                double ele = slice[k];
                if (ele > max) {
                    max = ele;
                    bestidx = k;
                }
                ++k;
            }
            int minFidx = SignalConversions.frequencyIndex(minfreq, windowSamples, samplingRate);
            maxs[j] = SignalConversions.spectrumIdx2Frequency(minFidx + bestidx, samplingRate, windowSamples);
            ++j;
            ++n2;
        }
        return maxs;
    }

    public static double[] takeLongestStableTract(double[] signal, double valuedifftoleranceperc) {
        ArrayList<int[]> pairs = new ArrayList<int[]>();
        int idx1 = -1;
        int[] pair = null;
        int i = 1;
        while (i < signal.length) {
            if (idx1 == -1) {
                idx1 = 1;
                pair = new int[]{i - 1, i - 1};
            }
            if (Math.abs(signal[i] - signal[i - 1]) / Math.max(signal[i], signal[i - 1]) <= valuedifftoleranceperc) {
                pair[1] = i;
            } else {
                idx1 = -1;
                pairs.add(pair);
            }
            ++i;
        }
        if (idx1 > -1) {
            pairs.add(pair);
        }
        int best = 0;
        int maxsize = 0;
        int k = 0;
        for (int[] setcouple : pairs) {
            int diff = setcouple[1] - setcouple[0];
            if (diff > maxsize) {
                maxsize = diff;
                best = k;
            }
            ++k;
        }
        int[] bestcouple = (int[])pairs.get(best);
        double[] subsignal = new double[bestcouple[1] - bestcouple[0]];
        System.out.println("Longest range: from " + bestcouple[0] + " to " + bestcouple[1]);
        int l = 0;
        int i2 = bestcouple[0];
        while (i2 < bestcouple[1]) {
            subsignal[l] = signal[i2];
            ++l;
            ++i2;
        }
        return subsignal;
    }

    public static float spectrumIdx2Frequency(int idx, int samplingRate, int windowsSizeSamples) {
        return (float)idx * (float)samplingRate / (float)(windowsSizeSamples - 1);
    }

    public static int spectrumFreq2Idx(float freq, int samplingRate, int windowsSizeSamples) {
        return Math.round((float)(windowsSizeSamples - 1) * freq / (float)samplingRate);
    }
}

